% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter.R
\name{prm_logit_normal}
\alias{prm_logit_normal}
\title{Parameter with logit-normal distribution}
\usage{
prm_logit_normal(name, mean_logit = 0, var_logit = 1)
}
\arguments{
\item{name}{Parameter name}

\item{mean_logit}{Mean on the logit scale}

\item{var_logit}{Variance on the logit scale}
}
\value{
A building block of type 'parameter'
}
\description{
This building block declares a parameter model for a parameter that follows the normal distribution on the logit-scale.
}
\details{
Parameter models specify type, name, and values for a parameter. The
parameter model type is selected through the function name. The
parameter name and values are provided as function arguments.
\subsection{Parameter names}{

Every parameter must have a valid name. A parameter name can contain
letters, numbers as well as the underscore character. The name needs to
start with a letter.

Adding a parameter with an already existing name will replace the
definition of the parameter. For example, the parameter “base” will have
a log-normal distribution in the following snippet:\preformatted{m <- model() +
 prm_normal("base") +
 prm_log_normal("base")
}
}

\subsection{Parameter values}{

The parameter values that a parameter model expects vary by type. For
example, \code{prm_normal()} requires the mean and the variance, whereas for
\code{prm_log_normal()} median and variance on the log scale need to be
provided. The argument name should indicate what parameter value is
expected.
}

\subsection{MU-referencing}{

\code{assemblerr} can include mu-referencing statements for parameter
distributions that support it. The functionality can be activated by
setting the option \code{prm.use_mu_referencing} to \code{TRUE} as shown in the
following snippet:\preformatted{m <- model() +
  prm_normal("base") +
  prm_log_normal("slp") +
  obs_additive(response~base+slp*time)

render(
  model = m,
  options = assemblerr_options(prm.use_mu_referencing = TRUE)
)
}
}
}
\examples{
# EMAX dose-response model with emax (log-normal) and ed50 (no variability) parameters
m2 <- model() +
  input_variable("dose") +
  prm_log_normal("emax", 10, 0.3) +
  prm_no_var("ed50", 5) +
  obs_proportional(effect~emax*dose/(ed50+dose))

# a log-normal parameter that is directly observed
m <- model() +
  prm_log_normal("wt") +
  obs_additive(~wt)

}
\seealso{
Other parameter models: 
\code{\link{prm_log_normal}()},
\code{\link{prm_no_var}()},
\code{\link{prm_normal}()}
}
\concept{parameter models}
