% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-has-terms.R, R/has-terms.R
\name{assert_has_terms}
\alias{assert_has_terms}
\alias{has_terms}
\title{Does the input have terms?}
\usage{
assert_has_terms(x, severity = getOption("assertive.severity", "stop"))

has_terms(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{has_terms} returns \code{TRUE} if the input has an 
element or an attribute named terms. \code{assert_has_terms} returns 
nothing but throws an error if \code{has_terms} is not \code{TRUE}.
}
\description{
Checks to see if the input has a terms component or attribute.
}
\examples{
model <- lm(uptake ~ conc, datasets::CO2)
# this works because model$terms is not null
assert_has_terms(model)
}
\seealso{
\code{\link[stats]{terms}}.
}
