% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/battingStats.R
\name{BBpct}
\alias{BBpct}
\title{Batting: Calculate base on ball percentage}
\usage{
BBpct(dat = NULL)
}
\arguments{
\item{dat}{A data frame you would wish to calculate. The data frame must have the same column names found in
The \code{Lahman} package or the Chadwick Bureau GitHub repository.}
}
\description{
Find base on ball percentage for batters with more than zero at bats.
Required fields from the Batting table are; "AB", "SO", "BB", "HBP", "SF", and "SH."
Intentional base on balls (IBB) is added for the years that metric is available.
}
\examples{

data("Batting2016")
head(Batting2016)

Batting2016$BBpct <- BBpct(Batting2016)

}
\seealso{
Other Batting functions: \code{\link{BABIP}},
  \code{\link{BA}}, \code{\link{CTpct}},
  \code{\link{HRpct}}, \code{\link{ISO}},
  \code{\link{Kpct}}, \code{\link{OBP}}, \code{\link{OPS}},
  \code{\link{PA}}, \code{\link{RC2002}},
  \code{\link{RCbasic}}, \code{\link{RCtech}},
  \code{\link{SLG}}, \code{\link{TBs}},
  \code{\link{XBHpct}}, \code{\link{XBperH}},
  \code{\link{wOBA}}, \code{\link{wRAA}}, \code{\link{wRC}}
}
\keyword{BBpct}
\keyword{ball}
\keyword{base}
\keyword{bb}
\keyword{on}
\keyword{percentage}
