// Generated by rstantools.  Do not edit by hand.

/*
    mvgamHMC is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    mvgamHMC is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with mvgamHMC.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_multresponse_continuous_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_multresponse_continuous");
    reader.add_event(375, 373, "end", "model_multresponse_continuous");
    return reader;
}
#include <stan_meta_header.hpp>
class model_multresponse_continuous
  : public stan::model::model_base_crtp<model_multresponse_continuous> {
private:
        int N;
        int p;
        int q;
        int r;
        int nk;
        int ny;
        matrix_d y;
        matrix_d X;
        int max_col;
        std::vector<int> zvars;
        int randint;
        int randeff;
        int nrandint;
        int nnp;
        matrix_d Znp;
        matrix_d Zint;
        matrix_d Z;
        int qr;
        int qrsplit;
        int mvindep;
        int famnum;
        int linknum;
        std::vector<int> epsnum;
        int eps_max_params;
        matrix_d eps_param;
        std::vector<int> betanum;
        int beta_max_params;
        matrix_d beta_param;
        std::vector<int> lambdanum;
        int lambda_max_params;
        matrix_d lambda_param;
        int a_num_offdiagonal;
        std::vector<int> anum;
        int a_max_params;
        matrix_d a_param;
        matrix_d Q_x;
        matrix_d R_x;
        matrix_d R_x_inverse;
        matrix_d Q_z;
        matrix_d R_z;
        matrix_d R_z_inverse;
        int q_reff;
        int q_rint;
public:
    model_multresponse_continuous(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_multresponse_continuous(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_multresponse_continuous_namespace::model_multresponse_continuous";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 5;
            context__.validate_dims("data initialization", "N", "int", context__.to_vec());
            N = int(0);
            vals_i__ = context__.vals_i("N");
            pos__ = 0;
            N = vals_i__[pos__++];
            check_greater_or_equal(function__, "N", N, 0);
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "p", "int", context__.to_vec());
            p = int(0);
            vals_i__ = context__.vals_i("p");
            pos__ = 0;
            p = vals_i__[pos__++];
            check_greater_or_equal(function__, "p", p, 0);
            current_statement_begin__ = 9;
            context__.validate_dims("data initialization", "q", "int", context__.to_vec());
            q = int(0);
            vals_i__ = context__.vals_i("q");
            pos__ = 0;
            q = vals_i__[pos__++];
            check_greater_or_equal(function__, "q", q, 0);
            current_statement_begin__ = 11;
            context__.validate_dims("data initialization", "r", "int", context__.to_vec());
            r = int(0);
            vals_i__ = context__.vals_i("r");
            pos__ = 0;
            r = vals_i__[pos__++];
            check_greater_or_equal(function__, "r", r, 0);
            current_statement_begin__ = 13;
            context__.validate_dims("data initialization", "nk", "int", context__.to_vec());
            nk = int(0);
            vals_i__ = context__.vals_i("nk");
            pos__ = 0;
            nk = vals_i__[pos__++];
            check_greater_or_equal(function__, "nk", nk, 0);
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "ny", "int", context__.to_vec());
            ny = int(0);
            vals_i__ = context__.vals_i("ny");
            pos__ = 0;
            ny = vals_i__[pos__++];
            check_greater_or_equal(function__, "ny", ny, 0);
            current_statement_begin__ = 15;
            validate_non_negative_index("y", "N", N);
            validate_non_negative_index("y", "ny", ny);
            context__.validate_dims("data initialization", "y", "matrix_d", context__.to_vec(N,ny));
            y = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, ny);
            vals_r__ = context__.vals_r("y");
            pos__ = 0;
            size_t y_j_2_max__ = ny;
            size_t y_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < y_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < y_j_1_max__; ++j_1__) {
                    y(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 18;
            validate_non_negative_index("X", "N", N);
            validate_non_negative_index("X", "p", p);
            context__.validate_dims("data initialization", "X", "matrix_d", context__.to_vec(N,p));
            X = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, p);
            vals_r__ = context__.vals_r("X");
            pos__ = 0;
            size_t X_j_2_max__ = p;
            size_t X_j_1_max__ = N;
            for (size_t j_2__ = 0; j_2__ < X_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < X_j_1_max__; ++j_1__) {
                    X(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "max_col", "int", context__.to_vec());
            max_col = int(0);
            vals_i__ = context__.vals_i("max_col");
            pos__ = 0;
            max_col = vals_i__[pos__++];
            current_statement_begin__ = 22;
            validate_non_negative_index("zvars", "(logical_gt(nk, 0) ? (q + 1) : 0 )", (logical_gt(nk, 0) ? (q + 1) : 0 ));
            context__.validate_dims("data initialization", "zvars", "int", context__.to_vec((logical_gt(nk, 0) ? (q + 1) : 0 )));
            zvars = std::vector<int>((logical_gt(nk, 0) ? (q + 1) : 0 ), int(0));
            vals_i__ = context__.vals_i("zvars");
            pos__ = 0;
            size_t zvars_k_0_max__ = (logical_gt(nk, 0) ? (q + 1) : 0 );
            for (size_t k_0__ = 0; k_0__ < zvars_k_0_max__; ++k_0__) {
                zvars[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 24;
            context__.validate_dims("data initialization", "randint", "int", context__.to_vec());
            randint = int(0);
            vals_i__ = context__.vals_i("randint");
            pos__ = 0;
            randint = vals_i__[pos__++];
            check_greater_or_equal(function__, "randint", randint, 0);
            check_less_or_equal(function__, "randint", randint, 1);
            current_statement_begin__ = 26;
            context__.validate_dims("data initialization", "randeff", "int", context__.to_vec());
            randeff = int(0);
            vals_i__ = context__.vals_i("randeff");
            pos__ = 0;
            randeff = vals_i__[pos__++];
            check_greater_or_equal(function__, "randeff", randeff, 0);
            check_less_or_equal(function__, "randeff", randeff, 1);
            current_statement_begin__ = 28;
            context__.validate_dims("data initialization", "nrandint", "int", context__.to_vec());
            nrandint = int(0);
            vals_i__ = context__.vals_i("nrandint");
            pos__ = 0;
            nrandint = vals_i__[pos__++];
            check_greater_or_equal(function__, "nrandint", nrandint, 0);
            current_statement_begin__ = 30;
            context__.validate_dims("data initialization", "nnp", "int", context__.to_vec());
            nnp = int(0);
            vals_i__ = context__.vals_i("nnp");
            pos__ = 0;
            nnp = vals_i__[pos__++];
            check_greater_or_equal(function__, "nnp", nnp, 0);
            current_statement_begin__ = 32;
            validate_non_negative_index("Znp", "(randeff ? N : 0 )", (randeff ? N : 0 ));
            validate_non_negative_index("Znp", "(randeff ? nnp : 0 )", (randeff ? nnp : 0 ));
            context__.validate_dims("data initialization", "Znp", "matrix_d", context__.to_vec((randeff ? N : 0 ),(randeff ? nnp : 0 )));
            Znp = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((randeff ? N : 0 ), (randeff ? nnp : 0 ));
            vals_r__ = context__.vals_r("Znp");
            pos__ = 0;
            size_t Znp_j_2_max__ = (randeff ? nnp : 0 );
            size_t Znp_j_1_max__ = (randeff ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < Znp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Znp_j_1_max__; ++j_1__) {
                    Znp(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 34;
            validate_non_negative_index("Zint", "(randint ? N : 0 )", (randint ? N : 0 ));
            validate_non_negative_index("Zint", "(randint ? nrandint : 0 )", (randint ? nrandint : 0 ));
            context__.validate_dims("data initialization", "Zint", "matrix_d", context__.to_vec((randint ? N : 0 ),(randint ? nrandint : 0 )));
            Zint = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((randint ? N : 0 ), (randint ? nrandint : 0 ));
            vals_r__ = context__.vals_r("Zint");
            pos__ = 0;
            size_t Zint_j_2_max__ = (randint ? nrandint : 0 );
            size_t Zint_j_1_max__ = (randint ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < Zint_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Zint_j_1_max__; ++j_1__) {
                    Zint(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 36;
            validate_non_negative_index("Z", "(logical_gt(nk, 0) ? N : 0 )", (logical_gt(nk, 0) ? N : 0 ));
            validate_non_negative_index("Z", "(logical_gt(nk, 0) ? nk : 0 )", (logical_gt(nk, 0) ? nk : 0 ));
            context__.validate_dims("data initialization", "Z", "matrix_d", context__.to_vec((logical_gt(nk, 0) ? N : 0 ),(logical_gt(nk, 0) ? nk : 0 )));
            Z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_gt(nk, 0) ? N : 0 ), (logical_gt(nk, 0) ? nk : 0 ));
            vals_r__ = context__.vals_r("Z");
            pos__ = 0;
            size_t Z_j_2_max__ = (logical_gt(nk, 0) ? nk : 0 );
            size_t Z_j_1_max__ = (logical_gt(nk, 0) ? N : 0 );
            for (size_t j_2__ = 0; j_2__ < Z_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Z_j_1_max__; ++j_1__) {
                    Z(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 38;
            context__.validate_dims("data initialization", "qr", "int", context__.to_vec());
            qr = int(0);
            vals_i__ = context__.vals_i("qr");
            pos__ = 0;
            qr = vals_i__[pos__++];
            check_greater_or_equal(function__, "qr", qr, 0);
            check_less_or_equal(function__, "qr", qr, 1);
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "qrsplit", "int", context__.to_vec());
            qrsplit = int(0);
            vals_i__ = context__.vals_i("qrsplit");
            pos__ = 0;
            qrsplit = vals_i__[pos__++];
            check_greater_or_equal(function__, "qrsplit", qrsplit, 0);
            check_less_or_equal(function__, "qrsplit", qrsplit, 1);
            current_statement_begin__ = 42;
            context__.validate_dims("data initialization", "mvindep", "int", context__.to_vec());
            mvindep = int(0);
            vals_i__ = context__.vals_i("mvindep");
            pos__ = 0;
            mvindep = vals_i__[pos__++];
            check_greater_or_equal(function__, "mvindep", mvindep, 0);
            check_less_or_equal(function__, "mvindep", mvindep, 1);
            current_statement_begin__ = 44;
            context__.validate_dims("data initialization", "famnum", "int", context__.to_vec());
            famnum = int(0);
            vals_i__ = context__.vals_i("famnum");
            pos__ = 0;
            famnum = vals_i__[pos__++];
            check_greater_or_equal(function__, "famnum", famnum, 1);
            check_less_or_equal(function__, "famnum", famnum, 3);
            current_statement_begin__ = 46;
            context__.validate_dims("data initialization", "linknum", "int", context__.to_vec());
            linknum = int(0);
            vals_i__ = context__.vals_i("linknum");
            pos__ = 0;
            linknum = vals_i__[pos__++];
            current_statement_begin__ = 55;
            validate_non_negative_index("epsnum", "(r + 1)", (r + 1));
            context__.validate_dims("data initialization", "epsnum", "int", context__.to_vec((r + 1)));
            epsnum = std::vector<int>((r + 1), int(0));
            vals_i__ = context__.vals_i("epsnum");
            pos__ = 0;
            size_t epsnum_k_0_max__ = (r + 1);
            for (size_t k_0__ = 0; k_0__ < epsnum_k_0_max__; ++k_0__) {
                epsnum[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 56;
            context__.validate_dims("data initialization", "eps_max_params", "int", context__.to_vec());
            eps_max_params = int(0);
            vals_i__ = context__.vals_i("eps_max_params");
            pos__ = 0;
            eps_max_params = vals_i__[pos__++];
            current_statement_begin__ = 57;
            validate_non_negative_index("eps_param", "r", r);
            validate_non_negative_index("eps_param", "eps_max_params", eps_max_params);
            context__.validate_dims("data initialization", "eps_param", "matrix_d", context__.to_vec(r,eps_max_params));
            eps_param = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(r, eps_max_params);
            vals_r__ = context__.vals_r("eps_param");
            pos__ = 0;
            size_t eps_param_j_2_max__ = eps_max_params;
            size_t eps_param_j_1_max__ = r;
            for (size_t j_2__ = 0; j_2__ < eps_param_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < eps_param_j_1_max__; ++j_1__) {
                    eps_param(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 60;
            validate_non_negative_index("betanum", "((p * r) + 1)", ((p * r) + 1));
            context__.validate_dims("data initialization", "betanum", "int", context__.to_vec(((p * r) + 1)));
            betanum = std::vector<int>(((p * r) + 1), int(0));
            vals_i__ = context__.vals_i("betanum");
            pos__ = 0;
            size_t betanum_k_0_max__ = ((p * r) + 1);
            for (size_t k_0__ = 0; k_0__ < betanum_k_0_max__; ++k_0__) {
                betanum[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 61;
            context__.validate_dims("data initialization", "beta_max_params", "int", context__.to_vec());
            beta_max_params = int(0);
            vals_i__ = context__.vals_i("beta_max_params");
            pos__ = 0;
            beta_max_params = vals_i__[pos__++];
            current_statement_begin__ = 62;
            validate_non_negative_index("beta_param", "(p * r)", (p * r));
            validate_non_negative_index("beta_param", "beta_max_params", beta_max_params);
            context__.validate_dims("data initialization", "beta_param", "matrix_d", context__.to_vec((p * r),beta_max_params));
            beta_param = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((p * r), beta_max_params);
            vals_r__ = context__.vals_r("beta_param");
            pos__ = 0;
            size_t beta_param_j_2_max__ = beta_max_params;
            size_t beta_param_j_1_max__ = (p * r);
            for (size_t j_2__ = 0; j_2__ < beta_param_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_param_j_1_max__; ++j_1__) {
                    beta_param(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 65;
            validate_non_negative_index("lambdanum", "(logical_gt(nk, 0) ? ((q * r) + 1) : 0 )", (logical_gt(nk, 0) ? ((q * r) + 1) : 0 ));
            context__.validate_dims("data initialization", "lambdanum", "int", context__.to_vec((logical_gt(nk, 0) ? ((q * r) + 1) : 0 )));
            lambdanum = std::vector<int>((logical_gt(nk, 0) ? ((q * r) + 1) : 0 ), int(0));
            vals_i__ = context__.vals_i("lambdanum");
            pos__ = 0;
            size_t lambdanum_k_0_max__ = (logical_gt(nk, 0) ? ((q * r) + 1) : 0 );
            for (size_t k_0__ = 0; k_0__ < lambdanum_k_0_max__; ++k_0__) {
                lambdanum[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 66;
            context__.validate_dims("data initialization", "lambda_max_params", "int", context__.to_vec());
            lambda_max_params = int(0);
            vals_i__ = context__.vals_i("lambda_max_params");
            pos__ = 0;
            lambda_max_params = vals_i__[pos__++];
            current_statement_begin__ = 67;
            validate_non_negative_index("lambda_param", "(logical_gt(nk, 0) ? (q * r) : 0 )", (logical_gt(nk, 0) ? (q * r) : 0 ));
            validate_non_negative_index("lambda_param", "(logical_gt(nk, 0) ? lambda_max_params : 0 )", (logical_gt(nk, 0) ? lambda_max_params : 0 ));
            context__.validate_dims("data initialization", "lambda_param", "matrix_d", context__.to_vec((logical_gt(nk, 0) ? (q * r) : 0 ),(logical_gt(nk, 0) ? lambda_max_params : 0 )));
            lambda_param = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>((logical_gt(nk, 0) ? (q * r) : 0 ), (logical_gt(nk, 0) ? lambda_max_params : 0 ));
            vals_r__ = context__.vals_r("lambda_param");
            pos__ = 0;
            size_t lambda_param_j_2_max__ = (logical_gt(nk, 0) ? lambda_max_params : 0 );
            size_t lambda_param_j_1_max__ = (logical_gt(nk, 0) ? (q * r) : 0 );
            for (size_t j_2__ = 0; j_2__ < lambda_param_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < lambda_param_j_1_max__; ++j_1__) {
                    lambda_param(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 70;
            context__.validate_dims("data initialization", "a_num_offdiagonal", "int", context__.to_vec());
            a_num_offdiagonal = int(0);
            vals_i__ = context__.vals_i("a_num_offdiagonal");
            pos__ = 0;
            a_num_offdiagonal = vals_i__[pos__++];
            current_statement_begin__ = 71;
            validate_non_negative_index("anum", "(randint ? (a_num_offdiagonal + 1) : 0 )", (randint ? (a_num_offdiagonal + 1) : 0 ));
            context__.validate_dims("data initialization", "anum", "int", context__.to_vec((randint ? (a_num_offdiagonal + 1) : 0 )));
            anum = std::vector<int>((randint ? (a_num_offdiagonal + 1) : 0 ), int(0));
            vals_i__ = context__.vals_i("anum");
            pos__ = 0;
            size_t anum_k_0_max__ = (randint ? (a_num_offdiagonal + 1) : 0 );
            for (size_t k_0__ = 0; k_0__ < anum_k_0_max__; ++k_0__) {
                anum[k_0__] = vals_i__[pos__++];
            }
            current_statement_begin__ = 72;
            context__.validate_dims("data initialization", "a_max_params", "int", context__.to_vec());
            a_max_params = int(0);
            vals_i__ = context__.vals_i("a_max_params");
            pos__ = 0;
            a_max_params = vals_i__[pos__++];
            current_statement_begin__ = 73;
            validate_non_negative_index("a_param", "a_num_offdiagonal", a_num_offdiagonal);
            validate_non_negative_index("a_param", "(randint ? a_max_params : 0 )", (randint ? a_max_params : 0 ));
            context__.validate_dims("data initialization", "a_param", "matrix_d", context__.to_vec(a_num_offdiagonal,(randint ? a_max_params : 0 )));
            a_param = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(a_num_offdiagonal, (randint ? a_max_params : 0 ));
            vals_r__ = context__.vals_r("a_param");
            pos__ = 0;
            size_t a_param_j_2_max__ = (randint ? a_max_params : 0 );
            size_t a_param_j_1_max__ = a_num_offdiagonal;
            for (size_t j_2__ = 0; j_2__ < a_param_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < a_param_j_1_max__; ++j_1__) {
                    a_param(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            // initialize transformed data variables
            current_statement_begin__ = 79;
            validate_non_negative_index("Q_x", "N", N);
            validate_non_negative_index("Q_x", "p", p);
            Q_x = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, p);
            stan::math::fill(Q_x, DUMMY_VAR__);
            current_statement_begin__ = 80;
            validate_non_negative_index("R_x", "p", p);
            validate_non_negative_index("R_x", "p", p);
            R_x = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(p, p);
            stan::math::fill(R_x, DUMMY_VAR__);
            current_statement_begin__ = 81;
            validate_non_negative_index("R_x_inverse", "p", p);
            validate_non_negative_index("R_x_inverse", "p", p);
            R_x_inverse = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(p, p);
            stan::math::fill(R_x_inverse, DUMMY_VAR__);
            current_statement_begin__ = 84;
            validate_non_negative_index("Q_z", "N", N);
            validate_non_negative_index("Q_z", "nnp", nnp);
            Q_z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N, nnp);
            stan::math::fill(Q_z, DUMMY_VAR__);
            current_statement_begin__ = 85;
            validate_non_negative_index("R_z", "nnp", nnp);
            validate_non_negative_index("R_z", "nnp", nnp);
            R_z = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nnp, nnp);
            stan::math::fill(R_z, DUMMY_VAR__);
            current_statement_begin__ = 86;
            validate_non_negative_index("R_z_inverse", "nnp", nnp);
            validate_non_negative_index("R_z_inverse", "nnp", nnp);
            R_z_inverse = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nnp, nnp);
            stan::math::fill(R_z_inverse, DUMMY_VAR__);
            current_statement_begin__ = 88;
            q_reff = int(0);
            stan::math::fill(q_reff, std::numeric_limits<int>::min());
            current_statement_begin__ = 89;
            q_rint = int(0);
            stan::math::fill(q_rint, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 92;
            stan::math::assign(Q_x, multiply(stan::model::rvalue(qr_Q(X), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(1, p), stan::model::nil_index_list())), "qr_Q(X)"), stan::math::sqrt((N - 1))));
            current_statement_begin__ = 93;
            stan::math::assign(R_x, divide(stan::model::rvalue(qr_R(X), stan::model::cons_list(stan::model::index_min_max(1, p), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "qr_R(X)"), stan::math::sqrt((N - 1))));
            current_statement_begin__ = 94;
            stan::math::assign(R_x_inverse, inverse(R_x));
            current_statement_begin__ = 97;
            if (as_bool(logical_eq(randeff, 1))) {
                current_statement_begin__ = 98;
                stan::math::assign(Q_z, multiply(stan::model::rvalue(qr_Q(Znp), stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_min_max(1, nnp), stan::model::nil_index_list())), "qr_Q(Znp)"), stan::math::sqrt((N - 1))));
                current_statement_begin__ = 99;
                stan::math::assign(R_z, divide(stan::model::rvalue(qr_R(Znp), stan::model::cons_list(stan::model::index_min_max(1, nnp), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "qr_R(Znp)"), stan::math::sqrt((N - 1))));
                current_statement_begin__ = 100;
                stan::math::assign(R_z_inverse, inverse(R_z));
            }
            current_statement_begin__ = 103;
            if (as_bool(logical_eq(randint, 1))) {
                current_statement_begin__ = 104;
                stan::math::assign(q_rint, 1);
                current_statement_begin__ = 105;
                stan::math::assign(q_reff, (q - 1));
            } else {
                current_statement_begin__ = 107;
                stan::math::assign(q_rint, 0);
                current_statement_begin__ = 108;
                stan::math::assign(q_reff, q);
            }
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 116;
            validate_non_negative_index("theta_b", "p", p);
            validate_non_negative_index("theta_b", "ny", ny);
            num_params_r__ += (p * ny);
            current_statement_begin__ = 118;
            validate_non_negative_index("rint_u_transpose", "(randint ? nrandint : 0 )", (randint ? nrandint : 0 ));
            validate_non_negative_index("rint_u_transpose", "(randint ? ny : 0 )", (randint ? ny : 0 ));
            num_params_r__ += ((randint ? nrandint : 0 ) * (randint ? ny : 0 ));
            current_statement_begin__ = 119;
            validate_non_negative_index("lambda_rint", "(logical_eq(randint, 1) ? ny : 0 )", (logical_eq(randint, 1) ? ny : 0 ));
            num_params_r__ += (logical_eq(randint, 1) ? ny : 0 );
            current_statement_begin__ = 122;
            validate_non_negative_index("tau", "(randeff ? nnp : 0 )", (randeff ? nnp : 0 ));
            validate_non_negative_index("tau", "ny", ny);
            num_params_r__ += ((randeff ? nnp : 0 ) * ny);
            current_statement_begin__ = 125;
            validate_non_negative_index("lambda_reff", "(logical_eq(randeff, 1) ? q_reff : 0 )", (logical_eq(randeff, 1) ? q_reff : 0 ));
            validate_non_negative_index("lambda_reff", "ny", ny);
            num_params_r__ += ((logical_eq(randeff, 1) ? q_reff : 0 ) * ny);
            current_statement_begin__ = 126;
            validate_non_negative_index("eps", "r", r);
            num_params_r__ += r;
            current_statement_begin__ = 129;
            validate_non_negative_index("a", "(mvindep ? 0 : a_num_offdiagonal )", (mvindep ? 0 : a_num_offdiagonal ));
            num_params_r__ += (mvindep ? 0 : a_num_offdiagonal );
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_multresponse_continuous() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 116;
        if (!(context__.contains_r("theta_b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta_b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta_b");
        pos__ = 0U;
        validate_non_negative_index("theta_b", "p", p);
        validate_non_negative_index("theta_b", "ny", ny);
        context__.validate_dims("parameter initialization", "theta_b", "vector_d", context__.to_vec(ny,p));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > theta_b(ny, Eigen::Matrix<double, Eigen::Dynamic, 1>(p));
        size_t theta_b_j_1_max__ = p;
        size_t theta_b_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < theta_b_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < theta_b_k_0_max__; ++k_0__) {
                theta_b[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t theta_b_i_0_max__ = ny;
        for (size_t i_0__ = 0; i_0__ < theta_b_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(theta_b[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta_b: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 118;
        if (!(context__.contains_r("rint_u_transpose")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable rint_u_transpose missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("rint_u_transpose");
        pos__ = 0U;
        validate_non_negative_index("rint_u_transpose", "(randint ? nrandint : 0 )", (randint ? nrandint : 0 ));
        validate_non_negative_index("rint_u_transpose", "(randint ? ny : 0 )", (randint ? ny : 0 ));
        context__.validate_dims("parameter initialization", "rint_u_transpose", "matrix_d", context__.to_vec((randint ? nrandint : 0 ),(randint ? ny : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> rint_u_transpose((randint ? nrandint : 0 ), (randint ? ny : 0 ));
        size_t rint_u_transpose_j_2_max__ = (randint ? ny : 0 );
        size_t rint_u_transpose_j_1_max__ = (randint ? nrandint : 0 );
        for (size_t j_2__ = 0; j_2__ < rint_u_transpose_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rint_u_transpose_j_1_max__; ++j_1__) {
                rint_u_transpose(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(rint_u_transpose);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable rint_u_transpose: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 119;
        if (!(context__.contains_r("lambda_rint")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_rint missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_rint");
        pos__ = 0U;
        validate_non_negative_index("lambda_rint", "(logical_eq(randint, 1) ? ny : 0 )", (logical_eq(randint, 1) ? ny : 0 ));
        context__.validate_dims("parameter initialization", "lambda_rint", "vector_d", context__.to_vec((logical_eq(randint, 1) ? ny : 0 )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_rint((logical_eq(randint, 1) ? ny : 0 ));
        size_t lambda_rint_j_1_max__ = (logical_eq(randint, 1) ? ny : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_rint_j_1_max__; ++j_1__) {
            lambda_rint(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, lambda_rint);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_rint: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 122;
        if (!(context__.contains_r("tau")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable tau missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("tau");
        pos__ = 0U;
        validate_non_negative_index("tau", "(randeff ? nnp : 0 )", (randeff ? nnp : 0 ));
        validate_non_negative_index("tau", "ny", ny);
        context__.validate_dims("parameter initialization", "tau", "vector_d", context__.to_vec(ny,(randeff ? nnp : 0 )));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > tau(ny, Eigen::Matrix<double, Eigen::Dynamic, 1>((randeff ? nnp : 0 )));
        size_t tau_j_1_max__ = (randeff ? nnp : 0 );
        size_t tau_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
                tau[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t tau_i_0_max__ = ny;
        for (size_t i_0__ = 0; i_0__ < tau_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(tau[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable tau: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 125;
        if (!(context__.contains_r("lambda_reff")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable lambda_reff missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("lambda_reff");
        pos__ = 0U;
        validate_non_negative_index("lambda_reff", "(logical_eq(randeff, 1) ? q_reff : 0 )", (logical_eq(randeff, 1) ? q_reff : 0 ));
        validate_non_negative_index("lambda_reff", "ny", ny);
        context__.validate_dims("parameter initialization", "lambda_reff", "vector_d", context__.to_vec(ny,(logical_eq(randeff, 1) ? q_reff : 0 )));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > lambda_reff(ny, Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_eq(randeff, 1) ? q_reff : 0 )));
        size_t lambda_reff_j_1_max__ = (logical_eq(randeff, 1) ? q_reff : 0 );
        size_t lambda_reff_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < lambda_reff_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < lambda_reff_k_0_max__; ++k_0__) {
                lambda_reff[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t lambda_reff_i_0_max__ = ny;
        for (size_t i_0__ = 0; i_0__ < lambda_reff_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lb_unconstrain(0, lambda_reff[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable lambda_reff: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 126;
        if (!(context__.contains_r("eps")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable eps missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("eps");
        pos__ = 0U;
        validate_non_negative_index("eps", "r", r);
        context__.validate_dims("parameter initialization", "eps", "vector_d", context__.to_vec(r));
        Eigen::Matrix<double, Eigen::Dynamic, 1> eps(r);
        size_t eps_j_1_max__ = r;
        for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
            eps(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, eps);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable eps: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 129;
        if (!(context__.contains_r("a")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a");
        pos__ = 0U;
        validate_non_negative_index("a", "(mvindep ? 0 : a_num_offdiagonal )", (mvindep ? 0 : a_num_offdiagonal ));
        context__.validate_dims("parameter initialization", "a", "vector_d", context__.to_vec((mvindep ? 0 : a_num_offdiagonal )));
        Eigen::Matrix<double, Eigen::Dynamic, 1> a((mvindep ? 0 : a_num_offdiagonal ));
        size_t a_j_1_max__ = (mvindep ? 0 : a_num_offdiagonal );
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            a(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(a);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 116;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > theta_b;
            size_t theta_b_d_0_max__ = ny;
            theta_b.reserve(theta_b_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < theta_b_d_0_max__; ++d_0__) {
                if (jacobian__)
                    theta_b.push_back(in__.vector_constrain(p, lp__));
                else
                    theta_b.push_back(in__.vector_constrain(p));
            }
            current_statement_begin__ = 118;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> rint_u_transpose;
            (void) rint_u_transpose;  // dummy to suppress unused var warning
            if (jacobian__)
                rint_u_transpose = in__.matrix_constrain((randint ? nrandint : 0 ), (randint ? ny : 0 ), lp__);
            else
                rint_u_transpose = in__.matrix_constrain((randint ? nrandint : 0 ), (randint ? ny : 0 ));
            current_statement_begin__ = 119;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> lambda_rint;
            (void) lambda_rint;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda_rint = in__.vector_lb_constrain(0, (logical_eq(randint, 1) ? ny : 0 ), lp__);
            else
                lambda_rint = in__.vector_lb_constrain(0, (logical_eq(randint, 1) ? ny : 0 ));
            current_statement_begin__ = 122;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > tau;
            size_t tau_d_0_max__ = ny;
            tau.reserve(tau_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < tau_d_0_max__; ++d_0__) {
                if (jacobian__)
                    tau.push_back(in__.vector_constrain((randeff ? nnp : 0 ), lp__));
                else
                    tau.push_back(in__.vector_constrain((randeff ? nnp : 0 )));
            }
            current_statement_begin__ = 125;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > lambda_reff;
            size_t lambda_reff_d_0_max__ = ny;
            lambda_reff.reserve(lambda_reff_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < lambda_reff_d_0_max__; ++d_0__) {
                if (jacobian__)
                    lambda_reff.push_back(in__.vector_lb_constrain(0, (logical_eq(randeff, 1) ? q_reff : 0 ), lp__));
                else
                    lambda_reff.push_back(in__.vector_lb_constrain(0, (logical_eq(randeff, 1) ? q_reff : 0 )));
            }
            current_statement_begin__ = 126;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> eps;
            (void) eps;  // dummy to suppress unused var warning
            if (jacobian__)
                eps = in__.vector_lb_constrain(0, r, lp__);
            else
                eps = in__.vector_lb_constrain(0, r);
            current_statement_begin__ = 129;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a;
            (void) a;  // dummy to suppress unused var warning
            if (jacobian__)
                a = in__.vector_constrain((mvindep ? 0 : a_num_offdiagonal ), lp__);
            else
                a = in__.vector_constrain((mvindep ? 0 : a_num_offdiagonal ));
            // transformed parameters
            current_statement_begin__ = 133;
            validate_non_negative_index("theta_u", "(randeff ? nnp : 0 )", (randeff ? nnp : 0 ));
            validate_non_negative_index("theta_u", "ny", ny);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > theta_u(ny, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>((randeff ? nnp : 0 )));
            stan::math::initialize(theta_u, DUMMY_VAR__);
            stan::math::fill(theta_u, DUMMY_VAR__);
            current_statement_begin__ = 134;
            validate_non_negative_index("beta", "p", p);
            validate_non_negative_index("beta", "ny", ny);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > beta(ny, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(p));
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 135;
            validate_non_negative_index("u", "(logical_gt(nk, 0) ? (nrandint + nnp) : 0 )", (logical_gt(nk, 0) ? (nrandint + nnp) : 0 ));
            validate_non_negative_index("u", "ny", ny);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > u(ny, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>((logical_gt(nk, 0) ? (nrandint + nnp) : 0 )));
            stan::math::initialize(u, DUMMY_VAR__);
            stan::math::fill(u, DUMMY_VAR__);
            current_statement_begin__ = 136;
            validate_non_negative_index("reff_u", "(randeff ? nnp : 0 )", (randeff ? nnp : 0 ));
            validate_non_negative_index("reff_u", "ny", ny);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > reff_u(ny, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>((randeff ? nnp : 0 )));
            stan::math::initialize(reff_u, DUMMY_VAR__);
            stan::math::fill(reff_u, DUMMY_VAR__);
            current_statement_begin__ = 137;
            validate_non_negative_index("rint_u", "(randint ? nrandint : 0 )", (randint ? nrandint : 0 ));
            validate_non_negative_index("rint_u", "ny", ny);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > rint_u(ny, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>((randint ? nrandint : 0 )));
            stan::math::initialize(rint_u, DUMMY_VAR__);
            stan::math::fill(rint_u, DUMMY_VAR__);
            current_statement_begin__ = 142;
            validate_non_negative_index("sigma_u_random", "(randint ? ny : 0 )", (randint ? ny : 0 ));
            validate_non_negative_index("sigma_u_random", "(randint ? ny : 0 )", (randint ? ny : 0 ));
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> sigma_u_random((randint ? ny : 0 ), (randint ? ny : 0 ));
            stan::math::initialize(sigma_u_random, DUMMY_VAR__);
            stan::math::fill(sigma_u_random, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 145;
            if (as_bool(logical_eq(randint, 1))) {
                current_statement_begin__ = 146;
                for (int ll2 = 1; ll2 <= 1; ++ll2) {
                    {
                    current_statement_begin__ = 148;
                    validate_non_negative_index("L", "ny", ny);
                    validate_non_negative_index("L", "ny", ny);
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> L(ny, ny);
                    stan::math::initialize(L, DUMMY_VAR__);
                    stan::math::fill(L, DUMMY_VAR__);
                    current_statement_begin__ = 149;
                    validate_non_negative_index("Dhalf", "ny", ny);
                    validate_non_negative_index("Dhalf", "ny", ny);
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Dhalf(ny, ny);
                    stan::math::initialize(Dhalf, DUMMY_VAR__);
                    stan::math::fill(Dhalf, DUMMY_VAR__);
                    current_statement_begin__ = 152;
                    stan::math::assign(Dhalf, diag_matrix(lambda_rint));
                    current_statement_begin__ = 153;
                    stan::math::assign(L, diag_matrix(rep_vector(1.0, ny)));
                    current_statement_begin__ = 154;
                    for (int ll = 1; ll <= 1; ++ll) {
                        {
                        current_statement_begin__ = 155;
                        int iter(0);
                        (void) iter;  // dummy to suppress unused var warning
                        stan::math::fill(iter, std::numeric_limits<int>::min());
                        stan::math::assign(iter,1);
                        current_statement_begin__ = 156;
                        for (int ii = 1; ii <= ny; ++ii) {
                            current_statement_begin__ = 157;
                            for (int jj = 1; jj <= ny; ++jj) {
                                current_statement_begin__ = 158;
                                if (as_bool(logical_gt(jj, ii))) {
                                    current_statement_begin__ = 159;
                                    if (as_bool(logical_eq(mvindep, 1))) {
                                        current_statement_begin__ = 160;
                                        stan::model::assign(L, 
                                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(ii), stan::model::nil_index_list())), 
                                                    0, 
                                                    "assigning variable L");
                                    } else {
                                        current_statement_begin__ = 162;
                                        stan::model::assign(L, 
                                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(ii), stan::model::nil_index_list())), 
                                                    get_base1(a, iter, "a", 1), 
                                                    "assigning variable L");
                                    }
                                    current_statement_begin__ = 164;
                                    stan::math::assign(iter, (iter + 1));
                                }
                            }
                        }
                        }
                    }
                    current_statement_begin__ = 171;
                    stan::math::assign(sigma_u_random, tcrossprod(multiply(L, Dhalf)));
                    }
                }
            }
            current_statement_begin__ = 179;
            if (as_bool(logical_eq(randeff, 1))) {
                {
                current_statement_begin__ = 180;
                int zindex(0);
                (void) zindex;  // dummy to suppress unused var warning
                stan::math::fill(zindex, std::numeric_limits<int>::min());
                stan::math::assign(zindex,0);
                current_statement_begin__ = 181;
                if (as_bool(logical_eq(randint, 1))) {
                    current_statement_begin__ = 182;
                    stan::math::assign(zindex, 1);
                }
                current_statement_begin__ = 184;
                for (int l4 = 1; l4 <= ny; ++l4) {
                    {
                    current_statement_begin__ = 185;
                    int i(0);
                    (void) i;  // dummy to suppress unused var warning
                    stan::math::fill(i, std::numeric_limits<int>::min());
                    stan::math::assign(i,1);
                    current_statement_begin__ = 186;
                    for (int j4 = 1; j4 <= q_reff; ++j4) {
                        current_statement_begin__ = 187;
                        for (int k4 = 1; k4 <= get_base1(zvars, (j4 + zindex), "zvars", 1); ++k4) {
                            current_statement_begin__ = 188;
                            stan::model::assign(theta_u, 
                                        stan::model::cons_list(stan::model::index_uni(l4), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                        (get_base1(get_base1(tau, l4, "tau", 1), i, "tau", 2) * get_base1(get_base1(lambda_reff, l4, "lambda_reff", 1), j4, "lambda_reff", 2)), 
                                        "assigning variable theta_u");
                            current_statement_begin__ = 189;
                            stan::math::assign(i, (i + 1));
                        }
                    }
                    }
                }
                }
            }
            current_statement_begin__ = 195;
            if (as_bool(logical_eq(qr, 1))) {
                current_statement_begin__ = 196;
                for (int jj = 1; jj <= ny; ++jj) {
                    current_statement_begin__ = 197;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                multiply(R_x_inverse, get_base1(theta_b, jj, "theta_b", 1)), 
                                "assigning variable beta");
                    current_statement_begin__ = 198;
                    if (as_bool(logical_eq(randeff, 1))) {
                        current_statement_begin__ = 199;
                        stan::model::assign(reff_u, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                    multiply(R_z_inverse, get_base1(theta_u, jj, "theta_u", 1)), 
                                    "assigning variable reff_u");
                    }
                }
            } else {
                current_statement_begin__ = 204;
                for (int jj = 1; jj <= ny; ++jj) {
                    current_statement_begin__ = 205;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                get_base1(theta_b, jj, "theta_b", 1), 
                                "assigning variable beta");
                    current_statement_begin__ = 206;
                    if (as_bool(logical_eq(randeff, 1))) {
                        current_statement_begin__ = 207;
                        stan::model::assign(reff_u, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                    get_base1(theta_u, jj, "theta_u", 1), 
                                    "assigning variable reff_u");
                    }
                }
            }
            current_statement_begin__ = 213;
            for (int jj = 1; jj <= ny; ++jj) {
                current_statement_begin__ = 214;
                if (as_bool(logical_eq(randint, 1))) {
                    current_statement_begin__ = 215;
                    for (int kk = 1; kk <= nrandint; ++kk) {
                        current_statement_begin__ = 216;
                        stan::model::assign(u, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(kk), stan::model::nil_index_list())), 
                                    get_base1(rint_u_transpose, kk, jj, "rint_u_transpose", 1), 
                                    "assigning variable u");
                        current_statement_begin__ = 217;
                        stan::model::assign(rint_u, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(kk), stan::model::nil_index_list())), 
                                    get_base1(rint_u_transpose, kk, jj, "rint_u_transpose", 1), 
                                    "assigning variable rint_u");
                    }
                }
                current_statement_begin__ = 220;
                if (as_bool(logical_eq(randeff, 1))) {
                    current_statement_begin__ = 221;
                    for (int ll = 1; ll <= nnp; ++ll) {
                        current_statement_begin__ = 222;
                        stan::model::assign(u, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni((nrandint + ll)), stan::model::nil_index_list())), 
                                    get_base1(get_base1(reff_u, jj, "reff_u", 1), ll, "reff_u", 2), 
                                    "assigning variable u");
                    }
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 133;
            size_t theta_u_k_0_max__ = ny;
            size_t theta_u_j_1_max__ = (randeff ? nnp : 0 );
            for (size_t k_0__ = 0; k_0__ < theta_u_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < theta_u_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(theta_u[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: theta_u" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta_u: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 134;
            size_t beta_k_0_max__ = ny;
            size_t beta_j_1_max__ = p;
            for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(beta[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: beta" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 135;
            size_t u_k_0_max__ = ny;
            size_t u_j_1_max__ = (logical_gt(nk, 0) ? (nrandint + nnp) : 0 );
            for (size_t k_0__ = 0; k_0__ < u_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(u[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: u" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable u: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 136;
            size_t reff_u_k_0_max__ = ny;
            size_t reff_u_j_1_max__ = (randeff ? nnp : 0 );
            for (size_t k_0__ = 0; k_0__ < reff_u_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < reff_u_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(reff_u[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: reff_u" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable reff_u: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 137;
            size_t rint_u_k_0_max__ = ny;
            size_t rint_u_j_1_max__ = (randint ? nrandint : 0 );
            for (size_t k_0__ = 0; k_0__ < rint_u_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < rint_u_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(rint_u[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: rint_u" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rint_u: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 142;
            size_t sigma_u_random_j_1_max__ = (randint ? ny : 0 );
            size_t sigma_u_random_j_2_max__ = (randint ? ny : 0 );
            for (size_t j_1__ = 0; j_1__ < sigma_u_random_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < sigma_u_random_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(sigma_u_random(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: sigma_u_random" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable sigma_u_random: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            // model body
            current_statement_begin__ = 232;
            if (as_bool(logical_eq(mvindep, 0))) {
                current_statement_begin__ = 233;
                for (int jj = 1; jj <= a_num_offdiagonal; ++jj) {
                    current_statement_begin__ = 234;
                    if (as_bool(logical_eq(get_base1(anum, jj, "anum", 1), 1))) {
                        current_statement_begin__ = 235;
                        lp_accum__.add(normal_log<propto__>(get_base1(a, jj, "a", 1), get_base1(a_param, jj, 1, "a_param", 1), get_base1(a_param, jj, 2, "a_param", 1)));
                    } else if (as_bool(logical_eq(get_base1(anum, jj, "anum", 1), 2))) {
                        current_statement_begin__ = 237;
                        lp_accum__.add(student_t_log<propto__>(get_base1(a, jj, "a", 1), get_base1(a_param, jj, 1, "a_param", 1), get_base1(a_param, jj, 2, "a_param", 1), get_base1(a_param, jj, 3, "a_param", 1)));
                    }
                }
            }
            current_statement_begin__ = 242;
            for (int jj = 1; jj <= nrandint; ++jj) {
                current_statement_begin__ = 243;
                lp_accum__.add(multi_normal_log<propto__>(get_base1(rint_u_transpose, jj, "rint_u_transpose", 1), rep_vector(0.0, ny), sigma_u_random));
            }
            current_statement_begin__ = 246;
            for (int j1 = 1; j1 <= r; ++j1) {
                current_statement_begin__ = 247;
                for (int k1 = 1; k1 <= p; ++k1) {
                    current_statement_begin__ = 248;
                    if (as_bool(logical_eq(get_base1(betanum, (k1 * j1), "betanum", 1), 1))) {
                        current_statement_begin__ = 249;
                        lp_accum__.add(normal_log<propto__>(get_base1(get_base1(theta_b, j1, "theta_b", 1), k1, "theta_b", 2), get_base1(beta_param, (k1 * j1), 1, "beta_param", 1), get_base1(beta_param, (k1 * j1), 2, "beta_param", 1)));
                    } else if (as_bool(logical_eq(get_base1(betanum, k1, "betanum", 1), 2))) {
                        current_statement_begin__ = 251;
                        lp_accum__.add(student_t_log<propto__>(get_base1(get_base1(theta_b, j1, "theta_b", 1), k1, "theta_b", 2), get_base1(beta_param, (k1 * j1), 1, "beta_param", 1), get_base1(beta_param, (k1 * j1), 2, "beta_param", 1), get_base1(beta_param, (k1 * j1), 3, "beta_param", 1)));
                    }
                }
            }
            current_statement_begin__ = 257;
            for (int j1 = 1; j1 <= r; ++j1) {
                current_statement_begin__ = 258;
                if (as_bool(logical_eq(randint, 1))) {
                    current_statement_begin__ = 259;
                    if (as_bool(logical_eq(get_base1(lambdanum, 1, "lambdanum", 1), 1))) {
                        current_statement_begin__ = 260;
                        lp_accum__.add(normal_log<propto__>(get_base1(lambda_rint, j1, "lambda_rint", 1), get_base1(lambda_param, j1, 1, "lambda_param", 1), get_base1(lambda_param, j1, 2, "lambda_param", 1)));
                    } else if (as_bool(logical_eq(get_base1(lambdanum, 1, "lambdanum", 1), 2))) {
                        current_statement_begin__ = 262;
                        lp_accum__.add(student_t_log<propto__>(get_base1(lambda_rint, j1, "lambda_rint", 1), get_base1(lambda_param, j1, 1, "lambda_param", 1), get_base1(lambda_param, j1, 2, "lambda_param", 1), get_base1(lambda_param, j1, 3, "lambda_param", 1)));
                    }
                }
                current_statement_begin__ = 266;
                if (as_bool(logical_eq(randeff, 1))) {
                    current_statement_begin__ = 267;
                    for (int k1 = 1; k1 <= q_reff; ++k1) {
                        current_statement_begin__ = 268;
                        if (as_bool(logical_eq(get_base1(lambdanum, (k1 * j1), "lambdanum", 1), 1))) {
                            current_statement_begin__ = 269;
                            lp_accum__.add(normal_log<propto__>(get_base1(get_base1(lambda_reff, j1, "lambda_reff", 1), k1, "lambda_reff", 2), get_base1(lambda_param, (k1 * j1), 1, "lambda_param", 1), get_base1(lambda_param, (k1 * j1), 2, "lambda_param", 1)));
                        } else if (as_bool(logical_eq(get_base1(lambdanum, (k1 * j1), "lambdanum", 1), 2))) {
                            current_statement_begin__ = 271;
                            lp_accum__.add(student_t_log<propto__>(get_base1(get_base1(lambda_reff, j1, "lambda_reff", 1), k1, "lambda_reff", 2), get_base1(lambda_param, (k1 * j1), 1, "lambda_param", 1), get_base1(lambda_param, (k1 * j1), 2, "lambda_param", 1), get_base1(lambda_param, (k1 * j1), 3, "lambda_param", 1)));
                        }
                    }
                }
            }
            current_statement_begin__ = 278;
            for (int jj = 1; jj <= ny; ++jj) {
                current_statement_begin__ = 279;
                lp_accum__.add(normal_log<propto__>(get_base1(tau, jj, "tau", 1), 0, 1));
            }
            current_statement_begin__ = 282;
            if (as_bool(logical_eq(famnum, 1))) {
                {
                current_statement_begin__ = 284;
                validate_non_negative_index("yhat", "N", N);
                validate_non_negative_index("yhat", "ny", ny);
                std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>  > yhat(ny, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(N));
                stan::math::initialize(yhat, DUMMY_VAR__);
                stan::math::fill(yhat, DUMMY_VAR__);
                current_statement_begin__ = 286;
                for (int jj = 1; jj <= ny; ++jj) {
                    current_statement_begin__ = 287;
                    if (as_bool((primitive_value(logical_eq(randint, 1)) && primitive_value(logical_eq(randeff, 1))))) {
                        current_statement_begin__ = 288;
                        stan::model::assign(yhat, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                    add(add(multiply(Q_x, get_base1(theta_b, jj, "theta_b", 1)), multiply(get_base1(Q_z, jj, "Q_z", 1), get_base1(theta_u, jj, "theta_u", 1))), multiply(Zint, col(rint_u_transpose, jj))), 
                                    "assigning variable yhat");
                    } else if (as_bool((primitive_value(logical_eq(randint, 0)) && primitive_value(logical_eq(randeff, 1))))) {
                        current_statement_begin__ = 290;
                        stan::model::assign(yhat, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                    add(multiply(Q_x, get_base1(theta_b, jj, "theta_b", 1)), multiply(get_base1(Q_z, jj, "Q_z", 1), get_base1(theta_u, jj, "theta_u", 1))), 
                                    "assigning variable yhat");
                    } else if (as_bool((primitive_value(logical_eq(randint, 1)) && primitive_value(logical_eq(randeff, 0))))) {
                        current_statement_begin__ = 292;
                        stan::model::assign(yhat, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                    add(multiply(Q_x, get_base1(theta_b, jj, "theta_b", 1)), multiply(Zint, col(rint_u_transpose, jj))), 
                                    "assigning variable yhat");
                    } else if (as_bool((primitive_value(logical_eq(randint, 0)) && primitive_value(logical_eq(randeff, 0))))) {
                        current_statement_begin__ = 294;
                        stan::model::assign(yhat, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                    multiply(Q_x, get_base1(theta_b, jj, "theta_b", 1)), 
                                    "assigning variable yhat");
                    }
                }
                current_statement_begin__ = 298;
                for (int k2 = 1; k2 <= r; ++k2) {
                    current_statement_begin__ = 299;
                    if (as_bool(logical_eq(get_base1(epsnum, k2, "epsnum", 1), 1))) {
                        current_statement_begin__ = 300;
                        lp_accum__.add(normal_log<propto__>(get_base1(eps, k2, "eps", 1), get_base1(eps_param, k2, 1, "eps_param", 1), get_base1(eps_param, k2, 2, "eps_param", 1)));
                    } else if (as_bool(logical_eq(get_base1(epsnum, k2, "epsnum", 1), 2))) {
                        current_statement_begin__ = 302;
                        lp_accum__.add(student_t_log<propto__>(get_base1(eps, k2, "eps", 1), get_base1(eps_param, k2, 1, "eps_param", 1), get_base1(eps_param, k2, 2, "eps_param", 1), get_base1(eps_param, k2, 3, "eps_param", 1)));
                    }
                }
                current_statement_begin__ = 307;
                for (int jj = 1; jj <= ny; ++jj) {
                    current_statement_begin__ = 308;
                    if (as_bool(logical_eq(linknum, 1))) {
                        current_statement_begin__ = 309;
                        lp_accum__.add(normal_log<propto__>(stan::model::rvalue(y, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list())), "y"), get_base1(yhat, jj, "yhat", 1), get_base1(eps, jj, "eps", 1)));
                    } else if (as_bool(logical_eq(linknum, 2))) {
                        current_statement_begin__ = 313;
                        lp_accum__.add(normal_log<propto__>(stan::model::rvalue(y, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list())), "y"), stan::math::exp(get_base1(yhat, jj, "yhat", 1)), get_base1(eps, jj, "eps", 1)));
                    } else if (as_bool(logical_eq(linknum, 3))) {
                        current_statement_begin__ = 317;
                        lp_accum__.add(normal_log<propto__>(stan::model::rvalue(y, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list())), "y"), inv(get_base1(yhat, jj, "yhat", 1)), get_base1(eps, jj, "eps", 1)));
                    }
                }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("theta_b");
        names__.push_back("rint_u_transpose");
        names__.push_back("lambda_rint");
        names__.push_back("tau");
        names__.push_back("lambda_reff");
        names__.push_back("eps");
        names__.push_back("a");
        names__.push_back("theta_u");
        names__.push_back("beta");
        names__.push_back("u");
        names__.push_back("reff_u");
        names__.push_back("rint_u");
        names__.push_back("sigma_u_random");
        names__.push_back("dhalf_inv");
        names__.push_back("sigma_u_correlation");
        names__.push_back("log_lik");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(ny);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((randint ? nrandint : 0 ));
        dims__.push_back((randint ? ny : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((logical_eq(randint, 1) ? ny : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ny);
        dims__.push_back((randeff ? nnp : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ny);
        dims__.push_back((logical_eq(randeff, 1) ? q_reff : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(r);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((mvindep ? 0 : a_num_offdiagonal ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ny);
        dims__.push_back((randeff ? nnp : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ny);
        dims__.push_back(p);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ny);
        dims__.push_back((logical_gt(nk, 0) ? (nrandint + nnp) : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ny);
        dims__.push_back((randeff ? nnp : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ny);
        dims__.push_back((randint ? nrandint : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((randint ? ny : 0 ));
        dims__.push_back((randint ? ny : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((randint ? ny : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((randint ? ny : 0 ));
        dims__.push_back((randint ? ny : 0 ));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(ny);
        dims__.push_back(N);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_multresponse_continuous_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > theta_b;
        size_t theta_b_d_0_max__ = ny;
        theta_b.reserve(theta_b_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < theta_b_d_0_max__; ++d_0__) {
            theta_b.push_back(in__.vector_constrain(p));
        }
        size_t theta_b_j_1_max__ = p;
        size_t theta_b_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < theta_b_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < theta_b_k_0_max__; ++k_0__) {
                vars__.push_back(theta_b[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> rint_u_transpose = in__.matrix_constrain((randint ? nrandint : 0 ), (randint ? ny : 0 ));
        size_t rint_u_transpose_j_2_max__ = (randint ? ny : 0 );
        size_t rint_u_transpose_j_1_max__ = (randint ? nrandint : 0 );
        for (size_t j_2__ = 0; j_2__ < rint_u_transpose_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rint_u_transpose_j_1_max__; ++j_1__) {
                vars__.push_back(rint_u_transpose(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> lambda_rint = in__.vector_lb_constrain(0, (logical_eq(randint, 1) ? ny : 0 ));
        size_t lambda_rint_j_1_max__ = (logical_eq(randint, 1) ? ny : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_rint_j_1_max__; ++j_1__) {
            vars__.push_back(lambda_rint(j_1__));
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > tau;
        size_t tau_d_0_max__ = ny;
        tau.reserve(tau_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < tau_d_0_max__; ++d_0__) {
            tau.push_back(in__.vector_constrain((randeff ? nnp : 0 )));
        }
        size_t tau_j_1_max__ = (randeff ? nnp : 0 );
        size_t tau_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
                vars__.push_back(tau[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > lambda_reff;
        size_t lambda_reff_d_0_max__ = ny;
        lambda_reff.reserve(lambda_reff_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < lambda_reff_d_0_max__; ++d_0__) {
            lambda_reff.push_back(in__.vector_lb_constrain(0, (logical_eq(randeff, 1) ? q_reff : 0 )));
        }
        size_t lambda_reff_j_1_max__ = (logical_eq(randeff, 1) ? q_reff : 0 );
        size_t lambda_reff_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < lambda_reff_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < lambda_reff_k_0_max__; ++k_0__) {
                vars__.push_back(lambda_reff[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> eps = in__.vector_lb_constrain(0, r);
        size_t eps_j_1_max__ = r;
        for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
            vars__.push_back(eps(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> a = in__.vector_constrain((mvindep ? 0 : a_num_offdiagonal ));
        size_t a_j_1_max__ = (mvindep ? 0 : a_num_offdiagonal );
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            vars__.push_back(a(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 133;
            validate_non_negative_index("theta_u", "(randeff ? nnp : 0 )", (randeff ? nnp : 0 ));
            validate_non_negative_index("theta_u", "ny", ny);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > theta_u(ny, Eigen::Matrix<double, Eigen::Dynamic, 1>((randeff ? nnp : 0 )));
            stan::math::initialize(theta_u, DUMMY_VAR__);
            stan::math::fill(theta_u, DUMMY_VAR__);
            current_statement_begin__ = 134;
            validate_non_negative_index("beta", "p", p);
            validate_non_negative_index("beta", "ny", ny);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > beta(ny, Eigen::Matrix<double, Eigen::Dynamic, 1>(p));
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            current_statement_begin__ = 135;
            validate_non_negative_index("u", "(logical_gt(nk, 0) ? (nrandint + nnp) : 0 )", (logical_gt(nk, 0) ? (nrandint + nnp) : 0 ));
            validate_non_negative_index("u", "ny", ny);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > u(ny, Eigen::Matrix<double, Eigen::Dynamic, 1>((logical_gt(nk, 0) ? (nrandint + nnp) : 0 )));
            stan::math::initialize(u, DUMMY_VAR__);
            stan::math::fill(u, DUMMY_VAR__);
            current_statement_begin__ = 136;
            validate_non_negative_index("reff_u", "(randeff ? nnp : 0 )", (randeff ? nnp : 0 ));
            validate_non_negative_index("reff_u", "ny", ny);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > reff_u(ny, Eigen::Matrix<double, Eigen::Dynamic, 1>((randeff ? nnp : 0 )));
            stan::math::initialize(reff_u, DUMMY_VAR__);
            stan::math::fill(reff_u, DUMMY_VAR__);
            current_statement_begin__ = 137;
            validate_non_negative_index("rint_u", "(randint ? nrandint : 0 )", (randint ? nrandint : 0 ));
            validate_non_negative_index("rint_u", "ny", ny);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > rint_u(ny, Eigen::Matrix<double, Eigen::Dynamic, 1>((randint ? nrandint : 0 )));
            stan::math::initialize(rint_u, DUMMY_VAR__);
            stan::math::fill(rint_u, DUMMY_VAR__);
            current_statement_begin__ = 142;
            validate_non_negative_index("sigma_u_random", "(randint ? ny : 0 )", (randint ? ny : 0 ));
            validate_non_negative_index("sigma_u_random", "(randint ? ny : 0 )", (randint ? ny : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> sigma_u_random((randint ? ny : 0 ), (randint ? ny : 0 ));
            stan::math::initialize(sigma_u_random, DUMMY_VAR__);
            stan::math::fill(sigma_u_random, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 145;
            if (as_bool(logical_eq(randint, 1))) {
                current_statement_begin__ = 146;
                for (int ll2 = 1; ll2 <= 1; ++ll2) {
                    {
                    current_statement_begin__ = 148;
                    validate_non_negative_index("L", "ny", ny);
                    validate_non_negative_index("L", "ny", ny);
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> L(ny, ny);
                    stan::math::initialize(L, DUMMY_VAR__);
                    stan::math::fill(L, DUMMY_VAR__);
                    current_statement_begin__ = 149;
                    validate_non_negative_index("Dhalf", "ny", ny);
                    validate_non_negative_index("Dhalf", "ny", ny);
                    Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Dhalf(ny, ny);
                    stan::math::initialize(Dhalf, DUMMY_VAR__);
                    stan::math::fill(Dhalf, DUMMY_VAR__);
                    current_statement_begin__ = 152;
                    stan::math::assign(Dhalf, diag_matrix(lambda_rint));
                    current_statement_begin__ = 153;
                    stan::math::assign(L, diag_matrix(rep_vector(1.0, ny)));
                    current_statement_begin__ = 154;
                    for (int ll = 1; ll <= 1; ++ll) {
                        {
                        current_statement_begin__ = 155;
                        int iter(0);
                        (void) iter;  // dummy to suppress unused var warning
                        stan::math::fill(iter, std::numeric_limits<int>::min());
                        stan::math::assign(iter,1);
                        current_statement_begin__ = 156;
                        for (int ii = 1; ii <= ny; ++ii) {
                            current_statement_begin__ = 157;
                            for (int jj = 1; jj <= ny; ++jj) {
                                current_statement_begin__ = 158;
                                if (as_bool(logical_gt(jj, ii))) {
                                    current_statement_begin__ = 159;
                                    if (as_bool(logical_eq(mvindep, 1))) {
                                        current_statement_begin__ = 160;
                                        stan::model::assign(L, 
                                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(ii), stan::model::nil_index_list())), 
                                                    0, 
                                                    "assigning variable L");
                                    } else {
                                        current_statement_begin__ = 162;
                                        stan::model::assign(L, 
                                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(ii), stan::model::nil_index_list())), 
                                                    get_base1(a, iter, "a", 1), 
                                                    "assigning variable L");
                                    }
                                    current_statement_begin__ = 164;
                                    stan::math::assign(iter, (iter + 1));
                                }
                            }
                        }
                        }
                    }
                    current_statement_begin__ = 171;
                    stan::math::assign(sigma_u_random, tcrossprod(multiply(L, Dhalf)));
                    }
                }
            }
            current_statement_begin__ = 179;
            if (as_bool(logical_eq(randeff, 1))) {
                {
                current_statement_begin__ = 180;
                int zindex(0);
                (void) zindex;  // dummy to suppress unused var warning
                stan::math::fill(zindex, std::numeric_limits<int>::min());
                stan::math::assign(zindex,0);
                current_statement_begin__ = 181;
                if (as_bool(logical_eq(randint, 1))) {
                    current_statement_begin__ = 182;
                    stan::math::assign(zindex, 1);
                }
                current_statement_begin__ = 184;
                for (int l4 = 1; l4 <= ny; ++l4) {
                    {
                    current_statement_begin__ = 185;
                    int i(0);
                    (void) i;  // dummy to suppress unused var warning
                    stan::math::fill(i, std::numeric_limits<int>::min());
                    stan::math::assign(i,1);
                    current_statement_begin__ = 186;
                    for (int j4 = 1; j4 <= q_reff; ++j4) {
                        current_statement_begin__ = 187;
                        for (int k4 = 1; k4 <= get_base1(zvars, (j4 + zindex), "zvars", 1); ++k4) {
                            current_statement_begin__ = 188;
                            stan::model::assign(theta_u, 
                                        stan::model::cons_list(stan::model::index_uni(l4), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                        (get_base1(get_base1(tau, l4, "tau", 1), i, "tau", 2) * get_base1(get_base1(lambda_reff, l4, "lambda_reff", 1), j4, "lambda_reff", 2)), 
                                        "assigning variable theta_u");
                            current_statement_begin__ = 189;
                            stan::math::assign(i, (i + 1));
                        }
                    }
                    }
                }
                }
            }
            current_statement_begin__ = 195;
            if (as_bool(logical_eq(qr, 1))) {
                current_statement_begin__ = 196;
                for (int jj = 1; jj <= ny; ++jj) {
                    current_statement_begin__ = 197;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                multiply(R_x_inverse, get_base1(theta_b, jj, "theta_b", 1)), 
                                "assigning variable beta");
                    current_statement_begin__ = 198;
                    if (as_bool(logical_eq(randeff, 1))) {
                        current_statement_begin__ = 199;
                        stan::model::assign(reff_u, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                    multiply(R_z_inverse, get_base1(theta_u, jj, "theta_u", 1)), 
                                    "assigning variable reff_u");
                    }
                }
            } else {
                current_statement_begin__ = 204;
                for (int jj = 1; jj <= ny; ++jj) {
                    current_statement_begin__ = 205;
                    stan::model::assign(beta, 
                                stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                get_base1(theta_b, jj, "theta_b", 1), 
                                "assigning variable beta");
                    current_statement_begin__ = 206;
                    if (as_bool(logical_eq(randeff, 1))) {
                        current_statement_begin__ = 207;
                        stan::model::assign(reff_u, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                    get_base1(theta_u, jj, "theta_u", 1), 
                                    "assigning variable reff_u");
                    }
                }
            }
            current_statement_begin__ = 213;
            for (int jj = 1; jj <= ny; ++jj) {
                current_statement_begin__ = 214;
                if (as_bool(logical_eq(randint, 1))) {
                    current_statement_begin__ = 215;
                    for (int kk = 1; kk <= nrandint; ++kk) {
                        current_statement_begin__ = 216;
                        stan::model::assign(u, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(kk), stan::model::nil_index_list())), 
                                    get_base1(rint_u_transpose, kk, jj, "rint_u_transpose", 1), 
                                    "assigning variable u");
                        current_statement_begin__ = 217;
                        stan::model::assign(rint_u, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(kk), stan::model::nil_index_list())), 
                                    get_base1(rint_u_transpose, kk, jj, "rint_u_transpose", 1), 
                                    "assigning variable rint_u");
                    }
                }
                current_statement_begin__ = 220;
                if (as_bool(logical_eq(randeff, 1))) {
                    current_statement_begin__ = 221;
                    for (int ll = 1; ll <= nnp; ++ll) {
                        current_statement_begin__ = 222;
                        stan::model::assign(u, 
                                    stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni((nrandint + ll)), stan::model::nil_index_list())), 
                                    get_base1(get_base1(reff_u, jj, "reff_u", 1), ll, "reff_u", 2), 
                                    "assigning variable u");
                    }
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            // write transformed parameters
            if (include_tparams__) {
                size_t theta_u_j_1_max__ = (randeff ? nnp : 0 );
                size_t theta_u_k_0_max__ = ny;
                for (size_t j_1__ = 0; j_1__ < theta_u_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < theta_u_k_0_max__; ++k_0__) {
                        vars__.push_back(theta_u[k_0__](j_1__));
                    }
                }
                size_t beta_j_1_max__ = p;
                size_t beta_k_0_max__ = ny;
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                        vars__.push_back(beta[k_0__](j_1__));
                    }
                }
                size_t u_j_1_max__ = (logical_gt(nk, 0) ? (nrandint + nnp) : 0 );
                size_t u_k_0_max__ = ny;
                for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < u_k_0_max__; ++k_0__) {
                        vars__.push_back(u[k_0__](j_1__));
                    }
                }
                size_t reff_u_j_1_max__ = (randeff ? nnp : 0 );
                size_t reff_u_k_0_max__ = ny;
                for (size_t j_1__ = 0; j_1__ < reff_u_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < reff_u_k_0_max__; ++k_0__) {
                        vars__.push_back(reff_u[k_0__](j_1__));
                    }
                }
                size_t rint_u_j_1_max__ = (randint ? nrandint : 0 );
                size_t rint_u_k_0_max__ = ny;
                for (size_t j_1__ = 0; j_1__ < rint_u_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < rint_u_k_0_max__; ++k_0__) {
                        vars__.push_back(rint_u[k_0__](j_1__));
                    }
                }
                size_t sigma_u_random_j_2_max__ = (randint ? ny : 0 );
                size_t sigma_u_random_j_1_max__ = (randint ? ny : 0 );
                for (size_t j_2__ = 0; j_2__ < sigma_u_random_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < sigma_u_random_j_1_max__; ++j_1__) {
                        vars__.push_back(sigma_u_random(j_1__, j_2__));
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 324;
            validate_non_negative_index("dhalf_inv", "(randint ? ny : 0 )", (randint ? ny : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, 1> dhalf_inv((randint ? ny : 0 ));
            stan::math::initialize(dhalf_inv, DUMMY_VAR__);
            stan::math::fill(dhalf_inv, DUMMY_VAR__);
            current_statement_begin__ = 325;
            validate_non_negative_index("sigma_u_correlation", "(randint ? ny : 0 )", (randint ? ny : 0 ));
            validate_non_negative_index("sigma_u_correlation", "(randint ? ny : 0 )", (randint ? ny : 0 ));
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> sigma_u_correlation((randint ? ny : 0 ), (randint ? ny : 0 ));
            stan::math::initialize(sigma_u_correlation, DUMMY_VAR__);
            stan::math::fill(sigma_u_correlation, DUMMY_VAR__);
            current_statement_begin__ = 326;
            validate_non_negative_index("log_lik", "N", N);
            validate_non_negative_index("log_lik", "ny", ny);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > log_lik(ny, Eigen::Matrix<double, Eigen::Dynamic, 1>(N));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 329;
            if (as_bool(logical_eq(randint, 1))) {
                current_statement_begin__ = 330;
                stan::math::assign(dhalf_inv, diagonal(sigma_u_random));
                current_statement_begin__ = 331;
                for (int jj = 1; jj <= ny; ++jj) {
                    current_statement_begin__ = 332;
                    stan::model::assign(dhalf_inv, 
                                stan::model::cons_list(stan::model::index_uni(jj), stan::model::nil_index_list()), 
                                (1 / stan::math::sqrt(get_base1(dhalf_inv, jj, "dhalf_inv", 1))), 
                                "assigning variable dhalf_inv");
                }
                current_statement_begin__ = 335;
                stan::math::assign(sigma_u_correlation, quad_form_diag(sigma_u_random, dhalf_inv));
            }
            current_statement_begin__ = 339;
            if (as_bool((primitive_value(logical_gt(randint, 0)) || primitive_value(logical_gt(randeff, 0))))) {
                current_statement_begin__ = 340;
                for (int jj = 1; jj <= ny; ++jj) {
                    current_statement_begin__ = 341;
                    for (int n = 1; n <= N; ++n) {
                        current_statement_begin__ = 342;
                        if (as_bool(logical_eq(linknum, 1))) {
                            current_statement_begin__ = 343;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                        normal_log(get_base1(y, n, "y", 1), (multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), get_base1(beta, jj, "beta", 1)) + multiply(stan::model::rvalue(Z, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "Z"), get_base1(u, jj, "u", 1))), get_base1(eps, jj, "eps", 1)), 
                                        "assigning variable log_lik");
                        } else if (as_bool(logical_eq(linknum, 2))) {
                            current_statement_begin__ = 347;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                        normal_log(stan::math::exp(get_base1(y, n, "y", 1)), (multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), get_base1(beta, jj, "beta", 1)) + multiply(stan::model::rvalue(Z, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "Z"), get_base1(u, jj, "u", 1))), get_base1(eps, jj, "eps", 1)), 
                                        "assigning variable log_lik");
                        } else if (as_bool(logical_eq(linknum, 3))) {
                            current_statement_begin__ = 351;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                        normal_log(inv(get_base1(y, n, "y", 1)), (multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), get_base1(beta, jj, "beta", 1)) + multiply(stan::model::rvalue(Z, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "Z"), get_base1(u, jj, "u", 1))), get_base1(eps, jj, "eps", 1)), 
                                        "assigning variable log_lik");
                        }
                    }
                }
            } else {
                current_statement_begin__ = 356;
                for (int jj = 1; jj <= ny; ++jj) {
                    current_statement_begin__ = 357;
                    for (int n = 1; n <= N; ++n) {
                        current_statement_begin__ = 358;
                        if (as_bool(logical_eq(linknum, 1))) {
                            current_statement_begin__ = 359;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                        normal_log(get_base1(y, n, "y", 1), multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), get_base1(beta, jj, "beta", 1)), get_base1(eps, jj, "eps", 1)), 
                                        "assigning variable log_lik");
                        } else if (as_bool(logical_eq(linknum, 2))) {
                            current_statement_begin__ = 363;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                        normal_log(stan::math::exp(get_base1(y, n, "y", 1)), multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), get_base1(beta, jj, "beta", 1)), get_base1(eps, jj, "eps", 1)), 
                                        "assigning variable log_lik");
                        } else if (as_bool(logical_eq(linknum, 3))) {
                            current_statement_begin__ = 367;
                            stan::model::assign(log_lik, 
                                        stan::model::cons_list(stan::model::index_uni(jj), stan::model::cons_list(stan::model::index_uni(n), stan::model::nil_index_list())), 
                                        normal_log(inv(get_base1(y, n, "y", 1)), multiply(stan::model::rvalue(X, stan::model::cons_list(stan::model::index_uni(n), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "X"), get_base1(beta, jj, "beta", 1)), get_base1(eps, jj, "eps", 1)), 
                                        "assigning variable log_lik");
                        }
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 324;
            size_t dhalf_inv_j_1_max__ = (randint ? ny : 0 );
            for (size_t j_1__ = 0; j_1__ < dhalf_inv_j_1_max__; ++j_1__) {
                vars__.push_back(dhalf_inv(j_1__));
            }
            current_statement_begin__ = 325;
            size_t sigma_u_correlation_j_2_max__ = (randint ? ny : 0 );
            size_t sigma_u_correlation_j_1_max__ = (randint ? ny : 0 );
            for (size_t j_2__ = 0; j_2__ < sigma_u_correlation_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < sigma_u_correlation_j_1_max__; ++j_1__) {
                    vars__.push_back(sigma_u_correlation(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 326;
            size_t log_lik_j_1_max__ = N;
            size_t log_lik_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
                    vars__.push_back(log_lik[k_0__](j_1__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_multresponse_continuous";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t theta_b_j_1_max__ = p;
        size_t theta_b_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < theta_b_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < theta_b_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_b" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rint_u_transpose_j_2_max__ = (randint ? ny : 0 );
        size_t rint_u_transpose_j_1_max__ = (randint ? nrandint : 0 );
        for (size_t j_2__ = 0; j_2__ < rint_u_transpose_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rint_u_transpose_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rint_u_transpose" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t lambda_rint_j_1_max__ = (logical_eq(randint, 1) ? ny : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_rint_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_rint" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = (randeff ? nnp : 0 );
        size_t tau_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t lambda_reff_j_1_max__ = (logical_eq(randeff, 1) ? q_reff : 0 );
        size_t lambda_reff_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < lambda_reff_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < lambda_reff_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_reff" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t eps_j_1_max__ = r;
        for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eps" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t a_j_1_max__ = (mvindep ? 0 : a_num_offdiagonal );
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_u_j_1_max__ = (randeff ? nnp : 0 );
            size_t theta_u_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < theta_u_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < theta_u_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "theta_u" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t beta_j_1_max__ = p;
            size_t beta_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t u_j_1_max__ = (logical_gt(nk, 0) ? (nrandint + nnp) : 0 );
            size_t u_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < u_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "u" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t reff_u_j_1_max__ = (randeff ? nnp : 0 );
            size_t reff_u_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < reff_u_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < reff_u_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "reff_u" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t rint_u_j_1_max__ = (randint ? nrandint : 0 );
            size_t rint_u_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < rint_u_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rint_u_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "rint_u" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sigma_u_random_j_2_max__ = (randint ? ny : 0 );
            size_t sigma_u_random_j_1_max__ = (randint ? ny : 0 );
            for (size_t j_2__ = 0; j_2__ < sigma_u_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < sigma_u_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sigma_u_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t dhalf_inv_j_1_max__ = (randint ? ny : 0 );
        for (size_t j_1__ = 0; j_1__ < dhalf_inv_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "dhalf_inv" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_u_correlation_j_2_max__ = (randint ? ny : 0 );
        size_t sigma_u_correlation_j_1_max__ = (randint ? ny : 0 );
        for (size_t j_2__ = 0; j_2__ < sigma_u_correlation_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < sigma_u_correlation_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_u_correlation" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_j_1_max__ = N;
        size_t log_lik_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lik" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t theta_b_j_1_max__ = p;
        size_t theta_b_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < theta_b_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < theta_b_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta_b" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t rint_u_transpose_j_2_max__ = (randint ? ny : 0 );
        size_t rint_u_transpose_j_1_max__ = (randint ? nrandint : 0 );
        for (size_t j_2__ = 0; j_2__ < rint_u_transpose_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rint_u_transpose_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rint_u_transpose" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t lambda_rint_j_1_max__ = (logical_eq(randint, 1) ? ny : 0 );
        for (size_t j_1__ = 0; j_1__ < lambda_rint_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "lambda_rint" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t tau_j_1_max__ = (randeff ? nnp : 0 );
        size_t tau_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < tau_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < tau_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "tau" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t lambda_reff_j_1_max__ = (logical_eq(randeff, 1) ? q_reff : 0 );
        size_t lambda_reff_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < lambda_reff_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < lambda_reff_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "lambda_reff" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t eps_j_1_max__ = r;
        for (size_t j_1__ = 0; j_1__ < eps_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "eps" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t a_j_1_max__ = (mvindep ? 0 : a_num_offdiagonal );
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t theta_u_j_1_max__ = (randeff ? nnp : 0 );
            size_t theta_u_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < theta_u_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < theta_u_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "theta_u" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t beta_j_1_max__ = p;
            size_t beta_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < beta_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t u_j_1_max__ = (logical_gt(nk, 0) ? (nrandint + nnp) : 0 );
            size_t u_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < u_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < u_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "u" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t reff_u_j_1_max__ = (randeff ? nnp : 0 );
            size_t reff_u_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < reff_u_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < reff_u_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "reff_u" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t rint_u_j_1_max__ = (randint ? nrandint : 0 );
            size_t rint_u_k_0_max__ = ny;
            for (size_t j_1__ = 0; j_1__ < rint_u_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rint_u_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "rint_u" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t sigma_u_random_j_2_max__ = (randint ? ny : 0 );
            size_t sigma_u_random_j_1_max__ = (randint ? ny : 0 );
            for (size_t j_2__ = 0; j_2__ < sigma_u_random_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < sigma_u_random_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "sigma_u_random" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        if (!include_gqs__) return;
        size_t dhalf_inv_j_1_max__ = (randint ? ny : 0 );
        for (size_t j_1__ = 0; j_1__ < dhalf_inv_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "dhalf_inv" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigma_u_correlation_j_2_max__ = (randint ? ny : 0 );
        size_t sigma_u_correlation_j_1_max__ = (randint ? ny : 0 );
        for (size_t j_2__ = 0; j_2__ < sigma_u_correlation_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < sigma_u_correlation_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "sigma_u_correlation" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_j_1_max__ = N;
        size_t log_lik_k_0_max__ = ny;
        for (size_t j_1__ = 0; j_1__ < log_lik_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "log_lik" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_multresponse_continuous_namespace::model_multresponse_continuous stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
