% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Regression_Functions.R
\name{distreg.asymp}
\alias{distreg.asymp}
\title{Asymptotic distribution regression}
\usage{
distreg.asymp(ind, drabj, data, vcovfn = "vcov", ...)
}
\arguments{
\item{ind}{index of object in list \code{drabj} (i.e. a threshold value) from which to take draws}

\item{drabj}{object from dr_asympar()}

\item{data}{dataframe, first column is the outcome}

\item{vcovfn}{a string denoting the function to extract the variance-covariance. Defaults at
"vcov". Other variance-covariance estimators in the sandwich package are usable.}

\item{...}{additional input to pass to \code{vcovfn}}
}
\value{
a mean \code{Fhat} and a variance \code{varF}
}
\description{
\code{distreg.asymp} takes input object from dr_asympar() for asymptotic bayesian distribution.
}
\examples{
y = faithful$waiting
x = scale(cbind(faithful$eruptions,faithful$eruptions^2))
qtaus = quantile(y,c(0.05,0.25,0.5,0.75,0.95))
drabj<- dr_asympar(y=y,x=x,thresh = qtaus); data = data.frame(y,x)
(asymp.obj<- distreg.asymp(ind=2,drabj,data,vcovfn="vcov"))

}
