% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.r
\name{bb.dating.states}
\alias{bb.dating.states}
\title{Prints out the dating of bull-bear states}
\usage{
bb.dating.states(price, bull, dates)
}
\arguments{
\item{price}{a numeric vector of price values}

\item{bull}{a logical vector that contains the states of the market. This vector
is returned by function \code{\link{run_dating_alg}} or \code{\link{run_filtering_alg}}.}

\item{dates}{a vector of dates}
}
\value{
A data frame object that contains the dating of bull-bear states.
}
\description{
This function prints out (in console window) the dating of bull-bear states.
The outcome of this function is a table in LaTeX format.
}
\examples{
{
library(zoo)
library(xtable)
library(ggplot2)
sp500 <- sp500m # choose the monthly data
dates <- index(sp500) # retrieve dates
dates <- as.yearmon(dates) # convert dates to "yearmon" format if monthly data
price <- as.vector(coredata(sp500)) # retrieve prices
setpar_dating_alg(4, 6, 4, 16, 20) # parameters for monthly data
bull <- run_dating_alg(price) # detect the states
bb.dating.states(price, bull, dates)
}
}
