% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gaussian_Inference.r
\name{rPosterior.LinearGaussianGaussian}
\alias{rPosterior.LinearGaussianGaussian}
\title{Posterior random generation of a "LinearGaussianGaussian" object}
\usage{
\method{rPosterior}{LinearGaussianGaussian}(obj, n = 1, ...)
}
\arguments{
\item{obj}{A "LinearGaussianGaussian" object.}

\item{n}{integer, number of samples.}

\item{...}{Additional arguments to be passed to other inherited types.}
}
\value{
A matrix of n rows, each row is a sample of z.
}
\description{
Generate random samples from the posterior distribution of the following structure:
     \deqn{x \sim Gaussian(A z + b, Sigma)}
     \deqn{z \sim Gaussian(m,S)}
Where Sigma is known. A is a \eqn{dimx x dimz} matrix, x is a \eqn{dimx x 1} random vector, z is a \eqn{dimz x 1} random vector, b is a \eqn{dimm x 1} vector. Gaussian() is the Gaussian distribution. See \code{?dGaussian} for the definition of Gaussian distribution.\cr
The model structure and prior parameters are stored in a "LinearGaussianGaussian" object. \cr
Posterior distribution is Gaussian(z|m,S).
}
\examples{
obj <- LinearGaussianGaussian(gamma=list(Sigma=matrix(c(2,1,1,2),2,2),
                                         m=c(0.2,0.5,0.6),S=diag(3)))
rPosterior(obj = obj,n=20)
}
\seealso{
\code{\link{LinearGaussianGaussian}}, \code{\link{dPosterior.LinearGaussianGaussian}}
}
