% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality_checks.R
\name{earliest_date}
\alias{earliest_date}
\title{Clean data based on earliest date.}
\usage{
earliest_date(bddata, res = "1700-01-01")
}
\arguments{
\item{bddata}{Bio diversity data in a data frame}

\item{res}{The earliest data required}
}
\description{
Clean data based on earliest date.
}
\section{samplePassData}{

When resolution is 20-Jan-2005, records recorded after the date will pass.
}

\section{sampleFailData}{

When resolution is 20-Jan-2005, records recorded before the date will fail.
}

\section{targetDWCField}{

eventDate
}

\section{checkCategory}{

temporal
}

\examples{

if(interactive()){

library(rgbif)
occdat <- occ_data(
  country = 'AU', # Country code for australia
  classKey = 359, # Class code for mammalia
  limit = 50 # Get only 50 records
)
myData <- occdat$data

responses <- earliest_date(myData, '2000-01-01')

}

}
