% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Instance.R
\name{Instance}
\alias{Instance}
\title{Abstract super class that handles the management of the Instances}
\description{
Provides the required methods to successfully handle each
\code{\link{Instance}} class.
}
\seealso{
\code{\link{ExtractorEml}}, \code{\link{ExtractorSms}},
\code{\link{ExtractorTwtid}}, \code{\link{ExtractorYtbid}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Instance$new()}}
\item \href{#method-obtainDate}{\code{Instance$obtainDate()}}
\item \href{#method-obtainSource}{\code{Instance$obtainSource()}}
\item \href{#method-getDate}{\code{Instance$getDate()}}
\item \href{#method-getSource}{\code{Instance$getSource()}}
\item \href{#method-getPath}{\code{Instance$getPath()}}
\item \href{#method-getData}{\code{Instance$getData()}}
\item \href{#method-getProperties}{\code{Instance$getProperties()}}
\item \href{#method-setSource}{\code{Instance$setSource()}}
\item \href{#method-setData}{\code{Instance$setData()}}
\item \href{#method-setDate}{\code{Instance$setDate()}}
\item \href{#method-setProperties}{\code{Instance$setProperties()}}
\item \href{#method-addProperties}{\code{Instance$addProperties()}}
\item \href{#method-getSpecificProperty}{\code{Instance$getSpecificProperty()}}
\item \href{#method-isSpecificProperty}{\code{Instance$isSpecificProperty()}}
\item \href{#method-setSpecificProperty}{\code{Instance$setSpecificProperty()}}
\item \href{#method-getNamesOfProperties}{\code{Instance$getNamesOfProperties()}}
\item \href{#method-isInstanceValid}{\code{Instance$isInstanceValid()}}
\item \href{#method-invalidate}{\code{Instance$invalidate()}}
\item \href{#method-getFlowPipes}{\code{Instance$getFlowPipes()}}
\item \href{#method-addFlowPipes}{\code{Instance$addFlowPipes()}}
\item \href{#method-getBanPipes}{\code{Instance$getBanPipes()}}
\item \href{#method-addBanPipes}{\code{Instance$addBanPipes()}}
\item \href{#method-checkCompatibility}{\code{Instance$checkCompatibility()}}
\item \href{#method-toString}{\code{Instance$toString()}}
\item \href{#method-clone}{\code{Instance$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{Instance}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$new(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{A \code{\link{character}} value. Path of the file.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obtainDate"></a>}}
\if{latex}{\out{\hypertarget{method-obtainDate}{}}}
\subsection{Method \code{obtainDate()}}{
Abstract function responsible for obtaining the date of the
\code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$obtainDate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-obtainSource"></a>}}
\if{latex}{\out{\hypertarget{method-obtainSource}{}}}
\subsection{Method \code{obtainSource()}}{
Abstract function responsible for determining the source of
the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$obtainSource()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getDate"></a>}}
\if{latex}{\out{\hypertarget{method-getDate}{}}}
\subsection{Method \code{getDate()}}{
Gets the date.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$getDate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of date.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSource"></a>}}
\if{latex}{\out{\hypertarget{method-getSource}{}}}
\subsection{Method \code{getSource()}}{
Gets the source.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$getSource()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of source.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPath"></a>}}
\if{latex}{\out{\hypertarget{method-getPath}{}}}
\subsection{Method \code{getPath()}}{
Gets the path.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$getPath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of path.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getData"></a>}}
\if{latex}{\out{\hypertarget{method-getData}{}}}
\subsection{Method \code{getData()}}{
Gets the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$getData()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of data.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getProperties"></a>}}
\if{latex}{\out{\hypertarget{method-getProperties}{}}}
\subsection{Method \code{getProperties()}}{
Gets the properties
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$getProperties()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setSource"></a>}}
\if{latex}{\out{\hypertarget{method-setSource}{}}}
\subsection{Method \code{setSource()}}{
Modifies the source value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$setSource(source)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{A \code{\link{character}} value. The new value of source.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setData"></a>}}
\if{latex}{\out{\hypertarget{method-setData}{}}}
\subsection{Method \code{setData()}}{
Modifies the data value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$setData(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The new value of data.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setDate"></a>}}
\if{latex}{\out{\hypertarget{method-setDate}{}}}
\subsection{Method \code{setDate()}}{
Modifies the date value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$setDate(date)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{date}}{A \code{\link{character}} value. The new value of date.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setProperties"></a>}}
\if{latex}{\out{\hypertarget{method-setProperties}{}}}
\subsection{Method \code{setProperties()}}{
Modifies the properties value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$setProperties(properties)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{properties}}{A \code{\link{list}} value. The new list of properties.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addProperties"></a>}}
\if{latex}{\out{\hypertarget{method-addProperties}{}}}
\subsection{Method \code{addProperties()}}{
Adds a property to the list of the properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$addProperties(propertyValue, propertyName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyValue}}{A \code{Object} value. The value of the new property.}

\item{\code{propertyName}}{A \code{\link{character}} value. The name of the new
property.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getSpecificProperty"></a>}}
\if{latex}{\out{\hypertarget{method-getSpecificProperty}{}}}
\subsection{Method \code{getSpecificProperty()}}{
Obtains a specific property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$getSpecificProperty(propertyName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. The name of the
property to obtain.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The value of the specific property.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isSpecificProperty"></a>}}
\if{latex}{\out{\hypertarget{method-isSpecificProperty}{}}}
\subsection{Method \code{isSpecificProperty()}}{
Checks for the existence of an specific property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$isSpecificProperty(propertyName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. The name of the
property to check.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A logical results according to the existence of the specific
property in the list of properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setSpecificProperty"></a>}}
\if{latex}{\out{\hypertarget{method-setSpecificProperty}{}}}
\subsection{Method \code{setSpecificProperty()}}{
Modifies the value of the one property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$setSpecificProperty(propertyName, propertyValue)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. The name of the
property.}

\item{\code{propertyValue}}{A \code{Object} value. The new value of the property.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getNamesOfProperties"></a>}}
\if{latex}{\out{\hypertarget{method-getNamesOfProperties}{}}}
\subsection{Method \code{getNamesOfProperties()}}{
Gets of the names of all properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$getNamesOfProperties()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The names of properties.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isInstanceValid"></a>}}
\if{latex}{\out{\hypertarget{method-isInstanceValid}{}}}
\subsection{Method \code{isInstanceValid()}}{
Checks if the \code{\link{Instance}} is valid.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$isInstanceValid()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of isValid flag.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-invalidate"></a>}}
\if{latex}{\out{\hypertarget{method-invalidate}{}}}
\subsection{Method \code{invalidate()}}{
Forces the invalidation of an specific \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$invalidate()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getFlowPipes"></a>}}
\if{latex}{\out{\hypertarget{method-getFlowPipes}{}}}
\subsection{Method \code{getFlowPipes()}}{
Gets the list of the flow of \code{\link{GenericPipe}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$getFlowPipes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Names of the \code{\link{GenericPipe}} used.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addFlowPipes"></a>}}
\if{latex}{\out{\hypertarget{method-addFlowPipes}{}}}
\subsection{Method \code{addFlowPipes()}}{
Gets the list of the flow of \code{\link{GenericPipe}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$addFlowPipes(namePipe)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{namePipe}}{A \code{\link{character}} value. Name of the new
\code{\link{GenericPipe}} to be added in the \code{\link{GenericPipeline}}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getBanPipes"></a>}}
\if{latex}{\out{\hypertarget{method-getBanPipes}{}}}
\subsection{Method \code{getBanPipes()}}{
Gets an array with containing all the ban
\code{\link{GenericPipe}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$getBanPipes()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Value of ban \code{\link{GenericPipe}} array.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-addBanPipes"></a>}}
\if{latex}{\out{\hypertarget{method-addBanPipes}{}}}
\subsection{Method \code{addBanPipes()}}{
Added the name of the Pipe to the array that keeps the track
of \code{\link{GenericPipe}s} having running after restrictions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$addBanPipes(namePipe)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{namePipe}}{A \code{\link{character}} value.
\code{\link{GenericPipe}} name to be introduced into the ban array.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-checkCompatibility"></a>}}
\if{latex}{\out{\hypertarget{method-checkCompatibility}{}}}
\subsection{Method \code{checkCompatibility()}}{
Check compatibility between \code{\link{GenericPipe}s}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$checkCompatibility(namePipe, alwaysBefore)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{namePipe}}{A \code{\link{character}} value. The name of the
\code{\link{GenericPipe}} name to check the compatibility.}

\item{\code{alwaysBefore}}{A \code{\link{list}} value.
\code{\link{GenericPipe}s} that the \code{\link{Instance}} had to go
through.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-toString"></a>}}
\if{latex}{\out{\hypertarget{method-toString}{}}}
\subsection{Method \code{toString()}}{
Returns a \code{\link{character}} representing the instance
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$toString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{\link{Instance}} \code{\link{character}} representation
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Instance$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
