% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_game.R
\name{analyze_game}
\alias{analyze_game}
\title{Analyze game}
\usage{
analyze_game(engine, san = NULL, lan = NULL, quiet = FALSE, ...)
}
\arguments{
\item{engine}{engine path or engine object from uci_engine()}

\item{san}{movetext in short algebraic notation, default NULL}

\item{lan}{movetext in long algebraic notation, default NULL}

\item{quiet}{boolean, hide system messages? Default FALSE}

\item{...}{further arguments passed directly to uci_go(), i.e. depth = 10}
}
\value{
list containg analyze_position() result (score and bestlines) for each move in the game. Note that if black moves, then score is multiplied by -1.
}
\description{
Analyze game using UCI engine and R API
}
\examples{
\donttest{
# Linux (make sure you have executable permission):
engine_path <- "./stockfish_10_x64"
# Windows
# engine_path <- "./stockfish_10_x64.exe"
g <- "1. e4 e5 2. Nf3 Nc6 3. d4 exd4 4. Bc4 Nf6 5. O-O Be7"
G <- analyze_game(engine_path,san = g ,depth = 20)
G[[1]] # handles info about first move in the game
G[[1]]$comment # "book"
G[[10]]$curmove_san # "Be7"
G[[10]]$score # 62
}
}
