// Generated by rstantools.  Do not edit by hand.

/*
    bmgarch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bmgarch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bmgarch.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_pdBEKKMGARCH_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_pdBEKKMGARCH");
    reader.add_event(2, 2, "include", "/functions/cov2cor.stan");
    reader.add_event(2, 0, "start", "/functions/cov2cor.stan");
    reader.add_event(10, 8, "end", "/functions/cov2cor.stan");
    reader.add_event(10, 3, "restart", "model_pdBEKKMGARCH");
    reader.add_event(13, 6, "include", "/data/data.stan");
    reader.add_event(13, 0, "start", "/data/data.stan");
    reader.add_event(21, 8, "end", "/data/data.stan");
    reader.add_event(21, 7, "restart", "model_pdBEKKMGARCH");
    reader.add_event(29, 15, "include", "/transformed_data/xh_marker.stan");
    reader.add_event(29, 0, "start", "/transformed_data/xh_marker.stan");
    reader.add_event(41, 12, "end", "/transformed_data/xh_marker.stan");
    reader.add_event(41, 16, "restart", "model_pdBEKKMGARCH");
    reader.add_event(58, 33, "include", "/parameters/arma.stan");
    reader.add_event(58, 0, "start", "/parameters/arma.stan");
    reader.add_event(65, 7, "end", "/parameters/arma.stan");
    reader.add_event(65, 34, "restart", "model_pdBEKKMGARCH");
    reader.add_event(147, 116, "include", "/model_components/mu.stan");
    reader.add_event(147, 0, "start", "/model_components/mu.stan");
    reader.add_event(157, 10, "end", "/model_components/mu.stan");
    reader.add_event(157, 117, "restart", "model_pdBEKKMGARCH");
    reader.add_event(237, 197, "include", "/generated/retrodict_H.stan");
    reader.add_event(237, 0, "start", "/generated/retrodict_H.stan");
    reader.add_event(251, 14, "end", "/generated/retrodict_H.stan");
    reader.add_event(251, 198, "restart", "model_pdBEKKMGARCH");
    reader.add_event(254, 199, "end", "model_pdBEKKMGARCH");
    return reader;
}
template <typename T0__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
cov2cor(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& C, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 4;
        int dm(0);
        (void) dm;  // dummy to suppress unused var warning
        stan::math::fill(dm, std::numeric_limits<int>::min());
        stan::math::assign(dm,rows(C));
        current_statement_begin__ = 5;
        validate_non_negative_index("s", "dm", dm);
        validate_non_negative_index("s", "dm", dm);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> s(dm, dm);
        stan::math::initialize(s, DUMMY_VAR__);
        stan::math::fill(s, DUMMY_VAR__);
        current_statement_begin__ = 6;
        validate_non_negative_index("R", "dm", dm);
        validate_non_negative_index("R", "dm", dm);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> R(dm, dm);
        stan::math::initialize(R, DUMMY_VAR__);
        stan::math::fill(R, DUMMY_VAR__);
        current_statement_begin__ = 7;
        stan::math::assign(s, diag_matrix(elt_divide(1.0, stan::math::sqrt(diagonal(C)))));
        current_statement_begin__ = 8;
        stan::math::assign(R, multiply(multiply(s, C), s));
        current_statement_begin__ = 9;
        return stan::math::promote_scalar<fun_return_scalar_t__>(R);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct cov2cor_functor__ {
    template <typename T0__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__>::type, Eigen::Dynamic, Eigen::Dynamic>
    operator()(const Eigen::Matrix<T0__, Eigen::Dynamic, Eigen::Dynamic>& C, std::ostream* pstream__) const {
        return cov2cor(C, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_pdBEKKMGARCH
  : public stan::model::model_base_crtp<model_pdBEKKMGARCH> {
private:
        int T;
        int nt;
        int Q;
        int P;
        std::vector<vector_d> rts;
        std::vector<vector_d> xC;
        int distribution;
        int meanstructure;
        vector_d rts_m;
        vector_d rts_sd;
        int od;
        std::vector<matrix_d> xC_m;
        int xC_marker;
        double cp;
public:
    model_pdBEKKMGARCH(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_pdBEKKMGARCH(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_pdBEKKMGARCH_namespace::model_pdBEKKMGARCH";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 14;
            context__.validate_dims("data initialization", "T", "int", context__.to_vec());
            T = int(0);
            vals_i__ = context__.vals_i("T");
            pos__ = 0;
            T = vals_i__[pos__++];
            check_greater_or_equal(function__, "T", T, 2);
            current_statement_begin__ = 15;
            context__.validate_dims("data initialization", "nt", "int", context__.to_vec());
            nt = int(0);
            vals_i__ = context__.vals_i("nt");
            pos__ = 0;
            nt = vals_i__[pos__++];
            check_greater_or_equal(function__, "nt", nt, 2);
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "Q", "int", context__.to_vec());
            Q = int(0);
            vals_i__ = context__.vals_i("Q");
            pos__ = 0;
            Q = vals_i__[pos__++];
            check_greater_or_equal(function__, "Q", Q, 1);
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "P", "int", context__.to_vec());
            P = int(0);
            vals_i__ = context__.vals_i("P");
            pos__ = 0;
            P = vals_i__[pos__++];
            check_greater_or_equal(function__, "P", P, 1);
            current_statement_begin__ = 18;
            validate_non_negative_index("rts", "nt", nt);
            validate_non_negative_index("rts", "T", T);
            context__.validate_dims("data initialization", "rts", "vector_d", context__.to_vec(T,nt));
            rts = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("rts");
            pos__ = 0;
            size_t rts_j_1_max__ = nt;
            size_t rts_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < rts_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < rts_k_0_max__; ++k_0__) {
                    rts[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 19;
            validate_non_negative_index("xC", "nt", nt);
            validate_non_negative_index("xC", "T", T);
            context__.validate_dims("data initialization", "xC", "vector_d", context__.to_vec(T,nt));
            xC = std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> >(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            vals_r__ = context__.vals_r("xC");
            pos__ = 0;
            size_t xC_j_1_max__ = nt;
            size_t xC_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < xC_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < xC_k_0_max__; ++k_0__) {
                    xC[k_0__](j_1__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "distribution", "int", context__.to_vec());
            distribution = int(0);
            vals_i__ = context__.vals_i("distribution");
            pos__ = 0;
            distribution = vals_i__[pos__++];
            check_greater_or_equal(function__, "distribution", distribution, 0);
            check_less_or_equal(function__, "distribution", distribution, 1);
            current_statement_begin__ = 21;
            context__.validate_dims("data initialization", "meanstructure", "int", context__.to_vec());
            meanstructure = int(0);
            vals_i__ = context__.vals_i("meanstructure");
            pos__ = 0;
            meanstructure = vals_i__[pos__++];
            check_greater_or_equal(function__, "meanstructure", meanstructure, 0);
            check_less_or_equal(function__, "meanstructure", meanstructure, 2);
            // initialize transformed data variables
            current_statement_begin__ = 26;
            validate_non_negative_index("rts_m", "nt", nt);
            rts_m = Eigen::Matrix<double, Eigen::Dynamic, 1>(nt);
            stan::math::fill(rts_m, DUMMY_VAR__);
            current_statement_begin__ = 27;
            validate_non_negative_index("rts_sd", "nt", nt);
            rts_sd = Eigen::Matrix<double, Eigen::Dynamic, 1>(nt);
            stan::math::fill(rts_sd, DUMMY_VAR__);
            current_statement_begin__ = 29;
            od = int(0);
            stan::math::fill(od, std::numeric_limits<int>::min());
            stan::math::assign(od,divide(((nt * nt) - nt), 2));
            current_statement_begin__ = 31;
            validate_non_negative_index("xC_m", "nt", nt);
            validate_non_negative_index("xC_m", "nt", nt);
            validate_non_negative_index("xC_m", "T", T);
            xC_m = std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> >(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::fill(xC_m, DUMMY_VAR__);
            current_statement_begin__ = 32;
            xC_marker = int(0);
            stan::math::fill(xC_marker, std::numeric_limits<int>::min());
            stan::math::assign(xC_marker,0);
            current_statement_begin__ = 33;
            cp = double(0);
            stan::math::fill(cp, DUMMY_VAR__);
            // execute transformed data statements
            current_statement_begin__ = 35;
            for (int t = 1; t <= T; ++t) {
                current_statement_begin__ = 36;
                stan::model::assign(xC_m, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                            diag_matrix(get_base1(xC, t, "xC", 1)), 
                            "assigning variable xC_m");
                current_statement_begin__ = 38;
                stan::math::assign(cp, sum(multiply(transpose(get_base1(xC_m, t, "xC_m", 1)), get_base1(xC_m, t, "xC_m", 1))));
                current_statement_begin__ = 39;
                if (as_bool(logical_neq(cp, 0))) {
                    current_statement_begin__ = 40;
                    stan::math::assign(xC_marker, (xC_marker + 1));
                }
            }
            current_statement_begin__ = 43;
            if (as_bool(logical_eq(meanstructure, 0))) {
                current_statement_begin__ = 44;
                for (int i = 1; i <= nt; ++i) {
                    current_statement_begin__ = 45;
                    stan::model::assign(rts_m, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                mean(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "rts")), 
                                "assigning variable rts_m");
                    current_statement_begin__ = 46;
                    stan::model::assign(rts_sd, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                sd(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "rts")), 
                                "assigning variable rts_sd");
                }
            } else if (as_bool((primitive_value(logical_eq(meanstructure, 1)) || primitive_value(logical_eq(meanstructure, 2))))) {
                current_statement_begin__ = 50;
                for (int i = 1; i <= nt; ++i) {
                    current_statement_begin__ = 51;
                    stan::model::assign(rts_m, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                get_base1(get_base1(rts, 1, "rts", 1), i, "rts", 2), 
                                "assigning variable rts_m");
                    current_statement_begin__ = 52;
                    stan::model::assign(rts_sd, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                sd(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "rts")), 
                                "assigning variable rts_sd");
                }
            }
            // validate transformed data
            current_statement_begin__ = 29;
            check_greater_or_equal(function__, "od", od, 1);
            current_statement_begin__ = 32;
            check_greater_or_equal(function__, "xC_marker", xC_marker, 0);
            current_statement_begin__ = 33;
            check_greater_or_equal(function__, "cp", cp, 0);
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 59;
            validate_non_negative_index("phi0", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 64;
            validate_non_negative_index("phi", "nt", nt);
            validate_non_negative_index("phi", "nt", nt);
            num_params_r__ += (nt * nt);
            current_statement_begin__ = 65;
            validate_non_negative_index("theta", "nt", nt);
            validate_non_negative_index("theta", "nt", nt);
            num_params_r__ += (nt * nt);
            current_statement_begin__ = 69;
            validate_non_negative_index("beta0", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 70;
            validate_non_negative_index("beta1", "nt", nt);
            num_params_r__ += nt;
            current_statement_begin__ = 74;
            validate_non_negative_index("C_R", "nt", nt);
            validate_non_negative_index("C_R", "nt", nt);
            num_params_r__ += ((nt * (nt - 1)) / 2);
            current_statement_begin__ = 76;
            validate_non_negative_index("A_diag", "nt", nt);
            validate_non_negative_index("A_diag", "Q", Q);
            num_params_r__ += (nt * Q);
            current_statement_begin__ = 77;
            validate_non_negative_index("B_diag", "nt", nt);
            validate_non_negative_index("B_diag", "P", P);
            num_params_r__ += (nt * P);
            current_statement_begin__ = 79;
            validate_non_negative_index("A_lower", "od", od);
            validate_non_negative_index("A_lower", "Q", Q);
            num_params_r__ += (od * Q);
            current_statement_begin__ = 80;
            validate_non_negative_index("B_lower", "od", od);
            validate_non_negative_index("B_lower", "P", P);
            num_params_r__ += (od * P);
            current_statement_begin__ = 81;
            validate_non_negative_index("A_upper", "od", od);
            validate_non_negative_index("A_upper", "Q", Q);
            num_params_r__ += (od * Q);
            current_statement_begin__ = 82;
            validate_non_negative_index("B_upper", "od", od);
            validate_non_negative_index("B_upper", "P", P);
            num_params_r__ += (od * P);
            current_statement_begin__ = 85;
            validate_non_negative_index("H1_init", "nt", nt);
            validate_non_negative_index("H1_init", "nt", nt);
            num_params_r__ += (nt + ((nt * (nt - 1)) / 2));
            current_statement_begin__ = 86;
            num_params_r__ += 1;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_pdBEKKMGARCH() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 59;
        if (!(context__.contains_r("phi0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi0");
        pos__ = 0U;
        validate_non_negative_index("phi0", "nt", nt);
        context__.validate_dims("parameter initialization", "phi0", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi0(nt);
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            phi0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(phi0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 64;
        if (!(context__.contains_r("phi")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable phi missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("phi");
        pos__ = 0U;
        validate_non_negative_index("phi", "nt", nt);
        validate_non_negative_index("phi", "nt", nt);
        context__.validate_dims("parameter initialization", "phi", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> phi(nt, nt);
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                phi(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_lub_unconstrain(-(1), 1, phi);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable phi: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 65;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "nt", nt);
        validate_non_negative_index("theta", "nt", nt);
        context__.validate_dims("parameter initialization", "theta", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta(nt, nt);
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                theta(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_lub_unconstrain(-(1), 1, theta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 69;
        if (!(context__.contains_r("beta0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta0");
        pos__ = 0U;
        validate_non_negative_index("beta0", "nt", nt);
        context__.validate_dims("parameter initialization", "beta0", "row_vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, 1, Eigen::Dynamic> beta0(nt);
        size_t beta0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            beta0(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.row_vector_unconstrain(beta0);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta0: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 70;
        if (!(context__.contains_r("beta1")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable beta1 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("beta1");
        pos__ = 0U;
        validate_non_negative_index("beta1", "nt", nt);
        context__.validate_dims("parameter initialization", "beta1", "vector_d", context__.to_vec(nt));
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta1(nt);
        size_t beta1_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta1_j_1_max__; ++j_1__) {
            beta1(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(beta1);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable beta1: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 74;
        if (!(context__.contains_r("C_R")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable C_R missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("C_R");
        pos__ = 0U;
        validate_non_negative_index("C_R", "nt", nt);
        validate_non_negative_index("C_R", "nt", nt);
        context__.validate_dims("parameter initialization", "C_R", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> C_R(nt, nt);
        size_t C_R_j_2_max__ = nt;
        size_t C_R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < C_R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < C_R_j_1_max__; ++j_1__) {
                C_R(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.corr_matrix_unconstrain(C_R);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable C_R: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 76;
        if (!(context__.contains_r("A_diag")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable A_diag missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("A_diag");
        pos__ = 0U;
        validate_non_negative_index("A_diag", "nt", nt);
        validate_non_negative_index("A_diag", "Q", Q);
        context__.validate_dims("parameter initialization", "A_diag", "vector_d", context__.to_vec(Q,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > A_diag(Q, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
        size_t A_diag_j_1_max__ = nt;
        size_t A_diag_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_diag_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_diag_k_0_max__; ++k_0__) {
                A_diag[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t A_diag_i_0_max__ = Q;
        for (size_t i_0__ = 0; i_0__ < A_diag_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lub_unconstrain(0, 1, A_diag[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable A_diag: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 77;
        if (!(context__.contains_r("B_diag")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable B_diag missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("B_diag");
        pos__ = 0U;
        validate_non_negative_index("B_diag", "nt", nt);
        validate_non_negative_index("B_diag", "P", P);
        context__.validate_dims("parameter initialization", "B_diag", "vector_d", context__.to_vec(P,nt));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > B_diag(P, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
        size_t B_diag_j_1_max__ = nt;
        size_t B_diag_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_diag_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_diag_k_0_max__; ++k_0__) {
                B_diag[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t B_diag_i_0_max__ = P;
        for (size_t i_0__ = 0; i_0__ < B_diag_i_0_max__; ++i_0__) {
            try {
                writer__.vector_lub_unconstrain(0, 1, B_diag[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable B_diag: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 79;
        if (!(context__.contains_r("A_lower")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable A_lower missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("A_lower");
        pos__ = 0U;
        validate_non_negative_index("A_lower", "od", od);
        validate_non_negative_index("A_lower", "Q", Q);
        context__.validate_dims("parameter initialization", "A_lower", "vector_d", context__.to_vec(Q,od));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > A_lower(Q, Eigen::Matrix<double, Eigen::Dynamic, 1>(od));
        size_t A_lower_j_1_max__ = od;
        size_t A_lower_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_lower_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_lower_k_0_max__; ++k_0__) {
                A_lower[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t A_lower_i_0_max__ = Q;
        for (size_t i_0__ = 0; i_0__ < A_lower_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(A_lower[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable A_lower: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 80;
        if (!(context__.contains_r("B_lower")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable B_lower missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("B_lower");
        pos__ = 0U;
        validate_non_negative_index("B_lower", "od", od);
        validate_non_negative_index("B_lower", "P", P);
        context__.validate_dims("parameter initialization", "B_lower", "vector_d", context__.to_vec(P,od));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > B_lower(P, Eigen::Matrix<double, Eigen::Dynamic, 1>(od));
        size_t B_lower_j_1_max__ = od;
        size_t B_lower_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_lower_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_lower_k_0_max__; ++k_0__) {
                B_lower[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t B_lower_i_0_max__ = P;
        for (size_t i_0__ = 0; i_0__ < B_lower_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(B_lower[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable B_lower: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 81;
        if (!(context__.contains_r("A_upper")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable A_upper missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("A_upper");
        pos__ = 0U;
        validate_non_negative_index("A_upper", "od", od);
        validate_non_negative_index("A_upper", "Q", Q);
        context__.validate_dims("parameter initialization", "A_upper", "vector_d", context__.to_vec(Q,od));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > A_upper(Q, Eigen::Matrix<double, Eigen::Dynamic, 1>(od));
        size_t A_upper_j_1_max__ = od;
        size_t A_upper_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_upper_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_upper_k_0_max__; ++k_0__) {
                A_upper[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t A_upper_i_0_max__ = Q;
        for (size_t i_0__ = 0; i_0__ < A_upper_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(A_upper[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable A_upper: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 82;
        if (!(context__.contains_r("B_upper")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable B_upper missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("B_upper");
        pos__ = 0U;
        validate_non_negative_index("B_upper", "od", od);
        validate_non_negative_index("B_upper", "P", P);
        context__.validate_dims("parameter initialization", "B_upper", "vector_d", context__.to_vec(P,od));
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > B_upper(P, Eigen::Matrix<double, Eigen::Dynamic, 1>(od));
        size_t B_upper_j_1_max__ = od;
        size_t B_upper_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_upper_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_upper_k_0_max__; ++k_0__) {
                B_upper[k_0__](j_1__) = vals_r__[pos__++];
            }
        }
        size_t B_upper_i_0_max__ = P;
        for (size_t i_0__ = 0; i_0__ < B_upper_i_0_max__; ++i_0__) {
            try {
                writer__.vector_unconstrain(B_upper[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable B_upper: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 85;
        if (!(context__.contains_r("H1_init")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable H1_init missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("H1_init");
        pos__ = 0U;
        validate_non_negative_index("H1_init", "nt", nt);
        validate_non_negative_index("H1_init", "nt", nt);
        context__.validate_dims("parameter initialization", "H1_init", "matrix_d", context__.to_vec(nt,nt));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> H1_init(nt, nt);
        size_t H1_init_j_2_max__ = nt;
        size_t H1_init_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < H1_init_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H1_init_j_1_max__; ++j_1__) {
                H1_init(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.cov_matrix_unconstrain(H1_init);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable H1_init: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 86;
        if (!(context__.contains_r("nu")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable nu missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("nu");
        pos__ = 0U;
        context__.validate_dims("parameter initialization", "nu", "double", context__.to_vec());
        double nu(0);
        nu = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(2, nu);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable nu: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 59;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> phi0;
            (void) phi0;  // dummy to suppress unused var warning
            if (jacobian__)
                phi0 = in__.vector_constrain(nt, lp__);
            else
                phi0 = in__.vector_constrain(nt);
            current_statement_begin__ = 64;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> phi;
            (void) phi;  // dummy to suppress unused var warning
            if (jacobian__)
                phi = in__.matrix_lub_constrain(-(1), 1, nt, nt, lp__);
            else
                phi = in__.matrix_lub_constrain(-(1), 1, nt, nt);
            current_statement_begin__ = 65;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> theta;
            (void) theta;  // dummy to suppress unused var warning
            if (jacobian__)
                theta = in__.matrix_lub_constrain(-(1), 1, nt, nt, lp__);
            else
                theta = in__.matrix_lub_constrain(-(1), 1, nt, nt);
            current_statement_begin__ = 69;
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> beta0;
            (void) beta0;  // dummy to suppress unused var warning
            if (jacobian__)
                beta0 = in__.row_vector_constrain(nt, lp__);
            else
                beta0 = in__.row_vector_constrain(nt);
            current_statement_begin__ = 70;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> beta1;
            (void) beta1;  // dummy to suppress unused var warning
            if (jacobian__)
                beta1 = in__.vector_constrain(nt, lp__);
            else
                beta1 = in__.vector_constrain(nt);
            current_statement_begin__ = 74;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> C_R;
            (void) C_R;  // dummy to suppress unused var warning
            if (jacobian__)
                C_R = in__.corr_matrix_constrain(nt, lp__);
            else
                C_R = in__.corr_matrix_constrain(nt);
            current_statement_begin__ = 76;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > A_diag;
            size_t A_diag_d_0_max__ = Q;
            A_diag.reserve(A_diag_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < A_diag_d_0_max__; ++d_0__) {
                if (jacobian__)
                    A_diag.push_back(in__.vector_lub_constrain(0, 1, nt, lp__));
                else
                    A_diag.push_back(in__.vector_lub_constrain(0, 1, nt));
            }
            current_statement_begin__ = 77;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > B_diag;
            size_t B_diag_d_0_max__ = P;
            B_diag.reserve(B_diag_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < B_diag_d_0_max__; ++d_0__) {
                if (jacobian__)
                    B_diag.push_back(in__.vector_lub_constrain(0, 1, nt, lp__));
                else
                    B_diag.push_back(in__.vector_lub_constrain(0, 1, nt));
            }
            current_statement_begin__ = 79;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > A_lower;
            size_t A_lower_d_0_max__ = Q;
            A_lower.reserve(A_lower_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < A_lower_d_0_max__; ++d_0__) {
                if (jacobian__)
                    A_lower.push_back(in__.vector_constrain(od, lp__));
                else
                    A_lower.push_back(in__.vector_constrain(od));
            }
            current_statement_begin__ = 80;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > B_lower;
            size_t B_lower_d_0_max__ = P;
            B_lower.reserve(B_lower_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < B_lower_d_0_max__; ++d_0__) {
                if (jacobian__)
                    B_lower.push_back(in__.vector_constrain(od, lp__));
                else
                    B_lower.push_back(in__.vector_constrain(od));
            }
            current_statement_begin__ = 81;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > A_upper;
            size_t A_upper_d_0_max__ = Q;
            A_upper.reserve(A_upper_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < A_upper_d_0_max__; ++d_0__) {
                if (jacobian__)
                    A_upper.push_back(in__.vector_constrain(od, lp__));
                else
                    A_upper.push_back(in__.vector_constrain(od));
            }
            current_statement_begin__ = 82;
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > B_upper;
            size_t B_upper_d_0_max__ = P;
            B_upper.reserve(B_upper_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < B_upper_d_0_max__; ++d_0__) {
                if (jacobian__)
                    B_upper.push_back(in__.vector_constrain(od, lp__));
                else
                    B_upper.push_back(in__.vector_constrain(od));
            }
            current_statement_begin__ = 85;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> H1_init;
            (void) H1_init;  // dummy to suppress unused var warning
            if (jacobian__)
                H1_init = in__.cov_matrix_constrain(nt, lp__);
            else
                H1_init = in__.cov_matrix_constrain(nt);
            current_statement_begin__ = 86;
            local_scalar_t__ nu;
            (void) nu;  // dummy to suppress unused var warning
            if (jacobian__)
                nu = in__.scalar_lb_constrain(2, lp__);
            else
                nu = in__.scalar_lb_constrain(2);
            // transformed parameters
            current_statement_begin__ = 90;
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "T", T);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > H(T, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(H, DUMMY_VAR__);
            stan::math::fill(H, DUMMY_VAR__);
            current_statement_begin__ = 91;
            validate_non_negative_index("rr", "nt", nt);
            validate_non_negative_index("rr", "nt", nt);
            validate_non_negative_index("rr", "(T - 1)", (T - 1));
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > rr((T - 1), Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(rr, DUMMY_VAR__);
            stan::math::fill(rr, DUMMY_VAR__);
            current_statement_begin__ = 92;
            validate_non_negative_index("mu", "nt", nt);
            validate_non_negative_index("mu", "T", T);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> > mu(T, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 94;
            validate_non_negative_index("A_part", "nt", nt);
            validate_non_negative_index("A_part", "nt", nt);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> A_part(nt, nt);
            stan::math::initialize(A_part, DUMMY_VAR__);
            stan::math::fill(A_part, DUMMY_VAR__);
            stan::math::assign(A_part,diag_matrix(rep_vector(0.0, nt)));
            current_statement_begin__ = 95;
            validate_non_negative_index("B_part", "nt", nt);
            validate_non_negative_index("B_part", "nt", nt);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> B_part(nt, nt);
            stan::math::initialize(B_part, DUMMY_VAR__);
            stan::math::fill(B_part, DUMMY_VAR__);
            stan::math::assign(B_part,diag_matrix(rep_vector(0.0, nt)));
            current_statement_begin__ = 97;
            validate_non_negative_index("beta", "(nt + 1)", (nt + 1));
            validate_non_negative_index("beta", "nt", nt);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> beta((nt + 1), nt);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            stan::math::assign(beta,append_row(beta0, diag_matrix(beta1)));
            current_statement_begin__ = 98;
            validate_non_negative_index("C_sd", "nt", nt);
            Eigen::Matrix<local_scalar_t__, 1, Eigen::Dynamic> C_sd(nt);
            stan::math::initialize(C_sd, DUMMY_VAR__);
            stan::math::fill(C_sd, DUMMY_VAR__);
            current_statement_begin__ = 99;
            validate_non_negative_index("Cnst", "nt", nt);
            validate_non_negative_index("Cnst", "nt", nt);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Cnst(nt, nt);
            stan::math::initialize(Cnst, DUMMY_VAR__);
            stan::math::fill(Cnst, DUMMY_VAR__);
            current_statement_begin__ = 102;
            validate_non_negative_index("A_raw", "nt", nt);
            validate_non_negative_index("A_raw", "nt", nt);
            validate_non_negative_index("A_raw", "Q", Q);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > A_raw(Q, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(A_raw, DUMMY_VAR__);
            stan::math::fill(A_raw, DUMMY_VAR__);
            current_statement_begin__ = 103;
            validate_non_negative_index("B_raw", "nt", nt);
            validate_non_negative_index("B_raw", "nt", nt);
            validate_non_negative_index("B_raw", "P", P);
            std::vector<Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> > B_raw(P, Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(B_raw, DUMMY_VAR__);
            stan::math::fill(B_raw, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 105;
            for (int q = 1; q <= Q; ++q) {
                {
                current_statement_begin__ = 106;
                int L(0);
                (void) L;  // dummy to suppress unused var warning
                stan::math::fill(L, std::numeric_limits<int>::min());
                stan::math::assign(L,0);
                current_statement_begin__ = 107;
                int U(0);
                (void) U;  // dummy to suppress unused var warning
                stan::math::fill(U, std::numeric_limits<int>::min());
                stan::math::assign(U,0);
                current_statement_begin__ = 108;
                for (int i = 1; i <= nt; ++i) {
                    current_statement_begin__ = 109;
                    for (int j = 1; j <= nt; ++j) {
                        current_statement_begin__ = 110;
                        if (as_bool(logical_lt(i, j))) {
                            current_statement_begin__ = 111;
                            stan::math::assign(U, (U + 1));
                            current_statement_begin__ = 112;
                            stan::model::assign(A_raw, 
                                        stan::model::cons_list(stan::model::index_uni(q), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(A_upper, q, "A_upper", 1), U, "A_upper", 2), 
                                        "assigning variable A_raw");
                        } else if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 114;
                            stan::math::assign(L, (L + 1));
                            current_statement_begin__ = 115;
                            stan::model::assign(A_raw, 
                                        stan::model::cons_list(stan::model::index_uni(q), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(A_lower, q, "A_lower", 1), L, "A_lower", 2), 
                                        "assigning variable A_raw");
                        } else if (as_bool(logical_eq(i, j))) {
                            current_statement_begin__ = 117;
                            stan::model::assign(A_raw, 
                                        stan::model::cons_list(stan::model::index_uni(q), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(A_diag, q, "A_diag", 1), i, "A_diag", 2), 
                                        "assigning variable A_raw");
                        }
                    }
                }
                }
            }
            current_statement_begin__ = 124;
            for (int p = 1; p <= P; ++p) {
                {
                current_statement_begin__ = 125;
                int L(0);
                (void) L;  // dummy to suppress unused var warning
                stan::math::fill(L, std::numeric_limits<int>::min());
                stan::math::assign(L,0);
                current_statement_begin__ = 126;
                int U(0);
                (void) U;  // dummy to suppress unused var warning
                stan::math::fill(U, std::numeric_limits<int>::min());
                stan::math::assign(U,0);
                current_statement_begin__ = 127;
                for (int i = 1; i <= nt; ++i) {
                    current_statement_begin__ = 128;
                    for (int j = 1; j <= nt; ++j) {
                        current_statement_begin__ = 129;
                        if (as_bool(logical_lt(i, j))) {
                            current_statement_begin__ = 130;
                            stan::math::assign(U, (U + 1));
                            current_statement_begin__ = 131;
                            stan::model::assign(B_raw, 
                                        stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(B_upper, p, "B_upper", 1), U, "B_upper", 2), 
                                        "assigning variable B_raw");
                        } else if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 133;
                            stan::math::assign(L, (L + 1));
                            current_statement_begin__ = 134;
                            stan::model::assign(B_raw, 
                                        stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(B_lower, p, "B_lower", 1), L, "B_lower", 2), 
                                        "assigning variable B_raw");
                        } else if (as_bool(logical_eq(i, j))) {
                            current_statement_begin__ = 136;
                            stan::model::assign(B_raw, 
                                        stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(B_diag, p, "B_diag", 1), i, "B_diag", 2), 
                                        "assigning variable B_raw");
                        }
                    }
                }
                }
            }
            current_statement_begin__ = 143;
            stan::model::assign(mu, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        phi0, 
                        "assigning variable mu");
            current_statement_begin__ = 144;
            stan::model::assign(H, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        H1_init, 
                        "assigning variable H");
            current_statement_begin__ = 146;
            for (int t = 2; t <= T; ++t) {
                current_statement_begin__ = 148;
                if (as_bool(logical_eq(meanstructure, 0))) {
                    current_statement_begin__ = 150;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                phi0, 
                                "assigning variable mu");
                } else if (as_bool(logical_eq(meanstructure, 1))) {
                    current_statement_begin__ = 153;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                stan::model::deep_copy(add(add(phi0, multiply(phi, stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"))), multiply(theta, subtract(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"))))), 
                                "assigning variable mu");
                } else if (as_bool(logical_eq(meanstructure, 2))) {
                    current_statement_begin__ = 156;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                add(phi0, multiply(phi, stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"))), 
                                "assigning variable mu");
                }
                current_statement_begin__ = 160;
                stan::math::assign(A_part, diag_matrix(rep_vector(0.0, nt)));
                current_statement_begin__ = 161;
                stan::math::assign(B_part, diag_matrix(rep_vector(0.0, nt)));
                current_statement_begin__ = 163;
                for (int q = 1; q <= std::min((t - 1), Q); ++q) {
                    current_statement_begin__ = 164;
                    stan::model::assign(rr, 
                                stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                multiply(subtract(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu")), transpose(subtract(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu")))), 
                                "assigning variable rr");
                    current_statement_begin__ = 165;
                    stan::math::assign(A_part, add(A_part, multiply(multiply(transpose(get_base1(A_raw, q, "A_raw", 1)), stan::model::rvalue(rr, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rr")), get_base1(A_raw, q, "A_raw", 1))));
                }
                current_statement_begin__ = 167;
                for (int p = 1; p <= std::min((t - 1), P); ++p) {
                    current_statement_begin__ = 168;
                    stan::math::assign(B_part, add(B_part, multiply(multiply(transpose(get_base1(B_raw, p, "B_raw", 1)), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni((t - p)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H")), get_base1(B_raw, p, "B_raw", 1))));
                }
                current_statement_begin__ = 170;
                if (as_bool(logical_eq(xC_marker, 0))) {
                    current_statement_begin__ = 171;
                    stan::math::assign(C_sd, stan::math::exp(beta0));
                    current_statement_begin__ = 172;
                    stan::math::assign(Cnst, quad_form_diag(C_R, C_sd));
                    current_statement_begin__ = 173;
                    stan::model::assign(H, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                add(add(Cnst, A_part), B_part), 
                                "assigning variable H");
                } else if (as_bool(logical_gte(xC_marker, 1))) {
                    current_statement_begin__ = 175;
                    stan::math::assign(C_sd, stan::math::exp(multiply(append_col(1.0, transpose(get_base1(xC, t, "xC", 1))), beta)));
                    current_statement_begin__ = 176;
                    stan::math::assign(Cnst, quad_form_diag(C_R, C_sd));
                    current_statement_begin__ = 177;
                    stan::model::assign(H, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                add(add(Cnst, A_part), B_part), 
                                "assigning variable H");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 90;
            size_t H_k_0_max__ = T;
            size_t H_j_1_max__ = nt;
            size_t H_j_2_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(H[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: H" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable H: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            size_t H_i_0_max__ = T;
            for (size_t i_0__ = 0; i_0__ < H_i_0_max__; ++i_0__) {
                stan::math::check_cov_matrix(function__, "H[i_0__]", H[i_0__]);
            }
            current_statement_begin__ = 91;
            size_t rr_k_0_max__ = (T - 1);
            size_t rr_j_1_max__ = nt;
            size_t rr_j_2_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < rr_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(rr[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: rr" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable rr: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 92;
            size_t mu_k_0_max__ = T;
            size_t mu_j_1_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    if (stan::math::is_uninitialized(mu[k_0__](j_1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: mu" << "[" << k_0__ << "]" << "(" << j_1__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable mu: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 94;
            size_t A_part_j_1_max__ = nt;
            size_t A_part_j_2_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < A_part_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < A_part_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(A_part(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: A_part" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable A_part: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 95;
            size_t B_part_j_1_max__ = nt;
            size_t B_part_j_2_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < B_part_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < B_part_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(B_part(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: B_part" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable B_part: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 97;
            size_t beta_j_1_max__ = (nt + 1);
            size_t beta_j_2_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(beta(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: beta" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable beta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 98;
            size_t C_sd_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < C_sd_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(C_sd(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: C_sd" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable C_sd: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            current_statement_begin__ = 99;
            size_t Cnst_j_1_max__ = nt;
            size_t Cnst_j_2_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < Cnst_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Cnst_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Cnst(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Cnst" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Cnst: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            stan::math::check_cov_matrix(function__, "Cnst", Cnst);
            current_statement_begin__ = 102;
            size_t A_raw_k_0_max__ = Q;
            size_t A_raw_j_1_max__ = nt;
            size_t A_raw_j_2_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < A_raw_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < A_raw_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < A_raw_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(A_raw[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: A_raw" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable A_raw: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            current_statement_begin__ = 103;
            size_t B_raw_k_0_max__ = P;
            size_t B_raw_j_1_max__ = nt;
            size_t B_raw_j_2_max__ = nt;
            for (size_t k_0__ = 0; k_0__ < B_raw_k_0_max__; ++k_0__) {
                for (size_t j_1__ = 0; j_1__ < B_raw_j_1_max__; ++j_1__) {
                    for (size_t j_2__ = 0; j_2__ < B_raw_j_2_max__; ++j_2__) {
                        if (stan::math::is_uninitialized(B_raw[k_0__](j_1__, j_2__))) {
                            std::stringstream msg__;
                            msg__ << "Undefined transformed parameter: B_raw" << "[" << k_0__ << "]" << "(" << j_1__ << ", " << j_2__ << ")";
                            stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable B_raw: ") + msg__.str()), current_statement_begin__, prog_reader__());
                        }
                    }
                }
            }
            // model body
            current_statement_begin__ = 185;
            lp_accum__.add(normal_log<propto__>(nu, nt, 50));
            current_statement_begin__ = 188;
            lp_accum__.add(wishart_log<propto__>(H1_init, (nt + 1.0), diag_matrix(rep_vector(1.0, nt))));
            current_statement_begin__ = 190;
            lp_accum__.add(std_normal_log<propto__>(to_vector(theta)));
            current_statement_begin__ = 191;
            lp_accum__.add(std_normal_log<propto__>(to_vector(phi)));
            current_statement_begin__ = 192;
            lp_accum__.add(multi_normal_log<propto__>(phi0, rts_m, diag_matrix(rts_sd)));
            current_statement_begin__ = 194;
            lp_accum__.add(std_normal_log<propto__>(to_vector(beta0)));
            current_statement_begin__ = 195;
            lp_accum__.add(std_normal_log<propto__>(to_vector(beta1)));
            current_statement_begin__ = 196;
            lp_accum__.add(lkj_corr_log<propto__>(C_R, 1));
            current_statement_begin__ = 198;
            for (int q = 1; q <= Q; ++q) {
                current_statement_begin__ = 199;
                lp_accum__.add(std_normal_log<propto__>(to_vector(get_base1(A_upper, q, "A_upper", 1))));
                current_statement_begin__ = 200;
                lp_accum__.add(std_normal_log<propto__>(to_vector(get_base1(A_lower, q, "A_lower", 1))));
                current_statement_begin__ = 201;
                lp_accum__.add(uniform_log<propto__>(to_vector(get_base1(A_diag, q, "A_diag", 1)), 0, 1));
            }
            current_statement_begin__ = 205;
            for (int p = 1; p <= P; ++p) {
                current_statement_begin__ = 206;
                lp_accum__.add(std_normal_log<propto__>(to_vector(get_base1(B_upper, p, "B_upper", 1))));
                current_statement_begin__ = 207;
                lp_accum__.add(std_normal_log<propto__>(to_vector(get_base1(B_lower, p, "B_lower", 1))));
                current_statement_begin__ = 208;
                lp_accum__.add(uniform_log<propto__>(to_vector(get_base1(B_diag, p, "B_diag", 1)), 0, 1));
            }
            current_statement_begin__ = 212;
            if (as_bool(logical_eq(distribution, 0))) {
                current_statement_begin__ = 213;
                for (int t = 1; t <= T; ++t) {
                    current_statement_begin__ = 214;
                    lp_accum__.add(multi_normal_log(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H")));
                }
            } else if (as_bool(logical_eq(distribution, 1))) {
                current_statement_begin__ = 217;
                for (int t = 1; t <= T; ++t) {
                    current_statement_begin__ = 218;
                    lp_accum__.add(multi_student_t_log(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), nu, stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H")));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("phi0");
        names__.push_back("phi");
        names__.push_back("theta");
        names__.push_back("beta0");
        names__.push_back("beta1");
        names__.push_back("C_R");
        names__.push_back("A_diag");
        names__.push_back("B_diag");
        names__.push_back("A_lower");
        names__.push_back("B_lower");
        names__.push_back("A_upper");
        names__.push_back("B_upper");
        names__.push_back("H1_init");
        names__.push_back("nu");
        names__.push_back("H");
        names__.push_back("rr");
        names__.push_back("mu");
        names__.push_back("A_part");
        names__.push_back("B_part");
        names__.push_back("beta");
        names__.push_back("C_sd");
        names__.push_back("Cnst");
        names__.push_back("A_raw");
        names__.push_back("B_raw");
        names__.push_back("A");
        names__.push_back("B");
        names__.push_back("rts_out");
        names__.push_back("log_lik");
        names__.push_back("corC");
        names__.push_back("corH");
        names__.push_back("C_var");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(od);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(od);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(od);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(od);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((T - 1));
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((nt + 1));
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(Q);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(P);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(T);
        dims__.push_back(nt);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(nt);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_pdBEKKMGARCH_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> phi0 = in__.vector_constrain(nt);
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            vars__.push_back(phi0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> phi = in__.matrix_lub_constrain(-(1), 1, nt, nt);
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                vars__.push_back(phi(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta = in__.matrix_lub_constrain(-(1), 1, nt, nt);
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                vars__.push_back(theta(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, 1, Eigen::Dynamic> beta0 = in__.row_vector_constrain(nt);
        size_t beta0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            vars__.push_back(beta0(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> beta1 = in__.vector_constrain(nt);
        size_t beta1_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta1_j_1_max__; ++j_1__) {
            vars__.push_back(beta1(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> C_R = in__.corr_matrix_constrain(nt);
        size_t C_R_j_2_max__ = nt;
        size_t C_R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < C_R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < C_R_j_1_max__; ++j_1__) {
                vars__.push_back(C_R(j_1__, j_2__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > A_diag;
        size_t A_diag_d_0_max__ = Q;
        A_diag.reserve(A_diag_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < A_diag_d_0_max__; ++d_0__) {
            A_diag.push_back(in__.vector_lub_constrain(0, 1, nt));
        }
        size_t A_diag_j_1_max__ = nt;
        size_t A_diag_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_diag_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_diag_k_0_max__; ++k_0__) {
                vars__.push_back(A_diag[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > B_diag;
        size_t B_diag_d_0_max__ = P;
        B_diag.reserve(B_diag_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < B_diag_d_0_max__; ++d_0__) {
            B_diag.push_back(in__.vector_lub_constrain(0, 1, nt));
        }
        size_t B_diag_j_1_max__ = nt;
        size_t B_diag_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_diag_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_diag_k_0_max__; ++k_0__) {
                vars__.push_back(B_diag[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > A_lower;
        size_t A_lower_d_0_max__ = Q;
        A_lower.reserve(A_lower_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < A_lower_d_0_max__; ++d_0__) {
            A_lower.push_back(in__.vector_constrain(od));
        }
        size_t A_lower_j_1_max__ = od;
        size_t A_lower_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_lower_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_lower_k_0_max__; ++k_0__) {
                vars__.push_back(A_lower[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > B_lower;
        size_t B_lower_d_0_max__ = P;
        B_lower.reserve(B_lower_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < B_lower_d_0_max__; ++d_0__) {
            B_lower.push_back(in__.vector_constrain(od));
        }
        size_t B_lower_j_1_max__ = od;
        size_t B_lower_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_lower_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_lower_k_0_max__; ++k_0__) {
                vars__.push_back(B_lower[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > A_upper;
        size_t A_upper_d_0_max__ = Q;
        A_upper.reserve(A_upper_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < A_upper_d_0_max__; ++d_0__) {
            A_upper.push_back(in__.vector_constrain(od));
        }
        size_t A_upper_j_1_max__ = od;
        size_t A_upper_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_upper_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_upper_k_0_max__; ++k_0__) {
                vars__.push_back(A_upper[k_0__](j_1__));
            }
        }
        std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > B_upper;
        size_t B_upper_d_0_max__ = P;
        B_upper.reserve(B_upper_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < B_upper_d_0_max__; ++d_0__) {
            B_upper.push_back(in__.vector_constrain(od));
        }
        size_t B_upper_j_1_max__ = od;
        size_t B_upper_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_upper_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_upper_k_0_max__; ++k_0__) {
                vars__.push_back(B_upper[k_0__](j_1__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> H1_init = in__.cov_matrix_constrain(nt);
        size_t H1_init_j_2_max__ = nt;
        size_t H1_init_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < H1_init_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H1_init_j_1_max__; ++j_1__) {
                vars__.push_back(H1_init(j_1__, j_2__));
            }
        }
        double nu = in__.scalar_lb_constrain(2);
        vars__.push_back(nu);
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 90;
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "nt", nt);
            validate_non_negative_index("H", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > H(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(H, DUMMY_VAR__);
            stan::math::fill(H, DUMMY_VAR__);
            current_statement_begin__ = 91;
            validate_non_negative_index("rr", "nt", nt);
            validate_non_negative_index("rr", "nt", nt);
            validate_non_negative_index("rr", "(T - 1)", (T - 1));
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > rr((T - 1), Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(rr, DUMMY_VAR__);
            stan::math::fill(rr, DUMMY_VAR__);
            current_statement_begin__ = 92;
            validate_non_negative_index("mu", "nt", nt);
            validate_non_negative_index("mu", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, 1> > mu(T, Eigen::Matrix<double, Eigen::Dynamic, 1>(nt));
            stan::math::initialize(mu, DUMMY_VAR__);
            stan::math::fill(mu, DUMMY_VAR__);
            current_statement_begin__ = 94;
            validate_non_negative_index("A_part", "nt", nt);
            validate_non_negative_index("A_part", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> A_part(nt, nt);
            stan::math::initialize(A_part, DUMMY_VAR__);
            stan::math::fill(A_part, DUMMY_VAR__);
            stan::math::assign(A_part,diag_matrix(rep_vector(0.0, nt)));
            current_statement_begin__ = 95;
            validate_non_negative_index("B_part", "nt", nt);
            validate_non_negative_index("B_part", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> B_part(nt, nt);
            stan::math::initialize(B_part, DUMMY_VAR__);
            stan::math::fill(B_part, DUMMY_VAR__);
            stan::math::assign(B_part,diag_matrix(rep_vector(0.0, nt)));
            current_statement_begin__ = 97;
            validate_non_negative_index("beta", "(nt + 1)", (nt + 1));
            validate_non_negative_index("beta", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> beta((nt + 1), nt);
            stan::math::initialize(beta, DUMMY_VAR__);
            stan::math::fill(beta, DUMMY_VAR__);
            stan::math::assign(beta,append_row(beta0, diag_matrix(beta1)));
            current_statement_begin__ = 98;
            validate_non_negative_index("C_sd", "nt", nt);
            Eigen::Matrix<double, 1, Eigen::Dynamic> C_sd(nt);
            stan::math::initialize(C_sd, DUMMY_VAR__);
            stan::math::fill(C_sd, DUMMY_VAR__);
            current_statement_begin__ = 99;
            validate_non_negative_index("Cnst", "nt", nt);
            validate_non_negative_index("Cnst", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Cnst(nt, nt);
            stan::math::initialize(Cnst, DUMMY_VAR__);
            stan::math::fill(Cnst, DUMMY_VAR__);
            current_statement_begin__ = 102;
            validate_non_negative_index("A_raw", "nt", nt);
            validate_non_negative_index("A_raw", "nt", nt);
            validate_non_negative_index("A_raw", "Q", Q);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > A_raw(Q, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(A_raw, DUMMY_VAR__);
            stan::math::fill(A_raw, DUMMY_VAR__);
            current_statement_begin__ = 103;
            validate_non_negative_index("B_raw", "nt", nt);
            validate_non_negative_index("B_raw", "nt", nt);
            validate_non_negative_index("B_raw", "P", P);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > B_raw(P, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(B_raw, DUMMY_VAR__);
            stan::math::fill(B_raw, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 105;
            for (int q = 1; q <= Q; ++q) {
                {
                current_statement_begin__ = 106;
                int L(0);
                (void) L;  // dummy to suppress unused var warning
                stan::math::fill(L, std::numeric_limits<int>::min());
                stan::math::assign(L,0);
                current_statement_begin__ = 107;
                int U(0);
                (void) U;  // dummy to suppress unused var warning
                stan::math::fill(U, std::numeric_limits<int>::min());
                stan::math::assign(U,0);
                current_statement_begin__ = 108;
                for (int i = 1; i <= nt; ++i) {
                    current_statement_begin__ = 109;
                    for (int j = 1; j <= nt; ++j) {
                        current_statement_begin__ = 110;
                        if (as_bool(logical_lt(i, j))) {
                            current_statement_begin__ = 111;
                            stan::math::assign(U, (U + 1));
                            current_statement_begin__ = 112;
                            stan::model::assign(A_raw, 
                                        stan::model::cons_list(stan::model::index_uni(q), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(A_upper, q, "A_upper", 1), U, "A_upper", 2), 
                                        "assigning variable A_raw");
                        } else if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 114;
                            stan::math::assign(L, (L + 1));
                            current_statement_begin__ = 115;
                            stan::model::assign(A_raw, 
                                        stan::model::cons_list(stan::model::index_uni(q), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(A_lower, q, "A_lower", 1), L, "A_lower", 2), 
                                        "assigning variable A_raw");
                        } else if (as_bool(logical_eq(i, j))) {
                            current_statement_begin__ = 117;
                            stan::model::assign(A_raw, 
                                        stan::model::cons_list(stan::model::index_uni(q), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(A_diag, q, "A_diag", 1), i, "A_diag", 2), 
                                        "assigning variable A_raw");
                        }
                    }
                }
                }
            }
            current_statement_begin__ = 124;
            for (int p = 1; p <= P; ++p) {
                {
                current_statement_begin__ = 125;
                int L(0);
                (void) L;  // dummy to suppress unused var warning
                stan::math::fill(L, std::numeric_limits<int>::min());
                stan::math::assign(L,0);
                current_statement_begin__ = 126;
                int U(0);
                (void) U;  // dummy to suppress unused var warning
                stan::math::fill(U, std::numeric_limits<int>::min());
                stan::math::assign(U,0);
                current_statement_begin__ = 127;
                for (int i = 1; i <= nt; ++i) {
                    current_statement_begin__ = 128;
                    for (int j = 1; j <= nt; ++j) {
                        current_statement_begin__ = 129;
                        if (as_bool(logical_lt(i, j))) {
                            current_statement_begin__ = 130;
                            stan::math::assign(U, (U + 1));
                            current_statement_begin__ = 131;
                            stan::model::assign(B_raw, 
                                        stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(B_upper, p, "B_upper", 1), U, "B_upper", 2), 
                                        "assigning variable B_raw");
                        } else if (as_bool(logical_gt(i, j))) {
                            current_statement_begin__ = 133;
                            stan::math::assign(L, (L + 1));
                            current_statement_begin__ = 134;
                            stan::model::assign(B_raw, 
                                        stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(B_lower, p, "B_lower", 1), L, "B_lower", 2), 
                                        "assigning variable B_raw");
                        } else if (as_bool(logical_eq(i, j))) {
                            current_statement_begin__ = 136;
                            stan::model::assign(B_raw, 
                                        stan::model::cons_list(stan::model::index_uni(p), stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list()))), 
                                        get_base1(get_base1(B_diag, p, "B_diag", 1), i, "B_diag", 2), 
                                        "assigning variable B_raw");
                        }
                    }
                }
                }
            }
            current_statement_begin__ = 143;
            stan::model::assign(mu, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        phi0, 
                        "assigning variable mu");
            current_statement_begin__ = 144;
            stan::model::assign(H, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                        H1_init, 
                        "assigning variable H");
            current_statement_begin__ = 146;
            for (int t = 2; t <= T; ++t) {
                current_statement_begin__ = 148;
                if (as_bool(logical_eq(meanstructure, 0))) {
                    current_statement_begin__ = 150;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                phi0, 
                                "assigning variable mu");
                } else if (as_bool(logical_eq(meanstructure, 1))) {
                    current_statement_begin__ = 153;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                stan::model::deep_copy(add(add(phi0, multiply(phi, stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"))), multiply(theta, subtract(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"))))), 
                                "assigning variable mu");
                } else if (as_bool(logical_eq(meanstructure, 2))) {
                    current_statement_begin__ = 156;
                    stan::model::assign(mu, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                add(phi0, multiply(phi, stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - 1)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"))), 
                                "assigning variable mu");
                }
                current_statement_begin__ = 160;
                stan::math::assign(A_part, diag_matrix(rep_vector(0.0, nt)));
                current_statement_begin__ = 161;
                stan::math::assign(B_part, diag_matrix(rep_vector(0.0, nt)));
                current_statement_begin__ = 163;
                for (int q = 1; q <= std::min((t - 1), Q); ++q) {
                    current_statement_begin__ = 164;
                    stan::model::assign(rr, 
                                stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                multiply(subtract(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu")), transpose(subtract(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu")))), 
                                "assigning variable rr");
                    current_statement_begin__ = 165;
                    stan::math::assign(A_part, add(A_part, multiply(multiply(transpose(get_base1(A_raw, q, "A_raw", 1)), stan::model::rvalue(rr, stan::model::cons_list(stan::model::index_uni((t - q)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rr")), get_base1(A_raw, q, "A_raw", 1))));
                }
                current_statement_begin__ = 167;
                for (int p = 1; p <= std::min((t - 1), P); ++p) {
                    current_statement_begin__ = 168;
                    stan::math::assign(B_part, add(B_part, multiply(multiply(transpose(get_base1(B_raw, p, "B_raw", 1)), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni((t - p)), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H")), get_base1(B_raw, p, "B_raw", 1))));
                }
                current_statement_begin__ = 170;
                if (as_bool(logical_eq(xC_marker, 0))) {
                    current_statement_begin__ = 171;
                    stan::math::assign(C_sd, stan::math::exp(beta0));
                    current_statement_begin__ = 172;
                    stan::math::assign(Cnst, quad_form_diag(C_R, C_sd));
                    current_statement_begin__ = 173;
                    stan::model::assign(H, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                add(add(Cnst, A_part), B_part), 
                                "assigning variable H");
                } else if (as_bool(logical_gte(xC_marker, 1))) {
                    current_statement_begin__ = 175;
                    stan::math::assign(C_sd, stan::math::exp(multiply(append_col(1.0, transpose(get_base1(xC, t, "xC", 1))), beta)));
                    current_statement_begin__ = 176;
                    stan::math::assign(Cnst, quad_form_diag(C_R, C_sd));
                    current_statement_begin__ = 177;
                    stan::model::assign(H, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                add(add(Cnst, A_part), B_part), 
                                "assigning variable H");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 90;
            size_t H_i_0_max__ = T;
            for (size_t i_0__ = 0; i_0__ < H_i_0_max__; ++i_0__) {
                stan::math::check_cov_matrix(function__, "H[i_0__]", H[i_0__]);
            }
            current_statement_begin__ = 99;
            stan::math::check_cov_matrix(function__, "Cnst", Cnst);
            // write transformed parameters
            if (include_tparams__) {
                size_t H_j_2_max__ = nt;
                size_t H_j_1_max__ = nt;
                size_t H_k_0_max__ = T;
                for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                            vars__.push_back(H[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t rr_j_2_max__ = nt;
                size_t rr_j_1_max__ = nt;
                size_t rr_k_0_max__ = (T - 1);
                for (size_t j_2__ = 0; j_2__ < rr_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                            vars__.push_back(rr[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t mu_j_1_max__ = nt;
                size_t mu_k_0_max__ = T;
                for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                        vars__.push_back(mu[k_0__](j_1__));
                    }
                }
                size_t A_part_j_2_max__ = nt;
                size_t A_part_j_1_max__ = nt;
                for (size_t j_2__ = 0; j_2__ < A_part_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < A_part_j_1_max__; ++j_1__) {
                        vars__.push_back(A_part(j_1__, j_2__));
                    }
                }
                size_t B_part_j_2_max__ = nt;
                size_t B_part_j_1_max__ = nt;
                for (size_t j_2__ = 0; j_2__ < B_part_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < B_part_j_1_max__; ++j_1__) {
                        vars__.push_back(B_part(j_1__, j_2__));
                    }
                }
                size_t beta_j_2_max__ = nt;
                size_t beta_j_1_max__ = (nt + 1);
                for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                        vars__.push_back(beta(j_1__, j_2__));
                    }
                }
                size_t C_sd_j_1_max__ = nt;
                for (size_t j_1__ = 0; j_1__ < C_sd_j_1_max__; ++j_1__) {
                    vars__.push_back(C_sd(j_1__));
                }
                size_t Cnst_j_2_max__ = nt;
                size_t Cnst_j_1_max__ = nt;
                for (size_t j_2__ = 0; j_2__ < Cnst_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Cnst_j_1_max__; ++j_1__) {
                        vars__.push_back(Cnst(j_1__, j_2__));
                    }
                }
                size_t A_raw_j_2_max__ = nt;
                size_t A_raw_j_1_max__ = nt;
                size_t A_raw_k_0_max__ = Q;
                for (size_t j_2__ = 0; j_2__ < A_raw_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < A_raw_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < A_raw_k_0_max__; ++k_0__) {
                            vars__.push_back(A_raw[k_0__](j_1__, j_2__));
                        }
                    }
                }
                size_t B_raw_j_2_max__ = nt;
                size_t B_raw_j_1_max__ = nt;
                size_t B_raw_k_0_max__ = P;
                for (size_t j_2__ = 0; j_2__ < B_raw_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < B_raw_j_1_max__; ++j_1__) {
                        for (size_t k_0__ = 0; k_0__ < B_raw_k_0_max__; ++k_0__) {
                            vars__.push_back(B_raw[k_0__](j_1__, j_2__));
                        }
                    }
                }
            }
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 224;
            validate_non_negative_index("A", "nt", nt);
            validate_non_negative_index("A", "nt", nt);
            validate_non_negative_index("A", "Q", Q);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > A(Q, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(A, DUMMY_VAR__);
            stan::math::fill(A, DUMMY_VAR__);
            stan::math::assign(A,A_raw);
            current_statement_begin__ = 225;
            validate_non_negative_index("B", "nt", nt);
            validate_non_negative_index("B", "nt", nt);
            validate_non_negative_index("B", "P", P);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > B(P, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(B, DUMMY_VAR__);
            stan::math::fill(B, DUMMY_VAR__);
            stan::math::assign(B,B_raw);
            current_statement_begin__ = 226;
            validate_non_negative_index("rts_out", "nt", nt);
            validate_non_negative_index("rts_out", "T", T);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> rts_out(nt, T);
            stan::math::initialize(rts_out, DUMMY_VAR__);
            stan::math::fill(rts_out, DUMMY_VAR__);
            current_statement_begin__ = 227;
            validate_non_negative_index("log_lik", "T", T);
            std::vector<double> log_lik(T, double(0));
            stan::math::initialize(log_lik, DUMMY_VAR__);
            stan::math::fill(log_lik, DUMMY_VAR__);
            current_statement_begin__ = 228;
            validate_non_negative_index("corC", "nt", nt);
            validate_non_negative_index("corC", "nt", nt);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> corC(nt, nt);
            stan::math::initialize(corC, DUMMY_VAR__);
            stan::math::fill(corC, DUMMY_VAR__);
            current_statement_begin__ = 229;
            validate_non_negative_index("corH", "nt", nt);
            validate_non_negative_index("corH", "nt", nt);
            validate_non_negative_index("corH", "T", T);
            std::vector<Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> > corH(T, Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(nt, nt));
            stan::math::initialize(corH, DUMMY_VAR__);
            stan::math::fill(corH, DUMMY_VAR__);
            current_statement_begin__ = 230;
            validate_non_negative_index("C_var", "nt", nt);
            Eigen::Matrix<double, 1, Eigen::Dynamic> C_var(nt);
            stan::math::initialize(C_var, DUMMY_VAR__);
            stan::math::fill(C_var, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 234;
            stan::math::assign(corC, C_R);
            current_statement_begin__ = 235;
            stan::math::assign(C_var, stan::math::exp(multiply(2, beta0)));
            current_statement_begin__ = 239;
            if (as_bool(logical_eq(distribution, 0))) {
                current_statement_begin__ = 240;
                for (int t = 1; t <= T; ++t) {
                    current_statement_begin__ = 241;
                    stan::model::assign(rts_out, 
                                stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                multi_normal_rng(stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), base_rng__), 
                                "assigning variable rts_out");
                    current_statement_begin__ = 242;
                    stan::model::assign(corH, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                cov2cor(stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), pstream__), 
                                "assigning variable corH");
                    current_statement_begin__ = 243;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                multi_normal_log(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H")), 
                                "assigning variable log_lik");
                }
            } else if (as_bool(logical_eq(distribution, 1))) {
                current_statement_begin__ = 246;
                for (int t = 1; t <= T; ++t) {
                    current_statement_begin__ = 247;
                    stan::model::assign(rts_out, 
                                stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list())), 
                                multi_student_t_rng(nu, stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), base_rng__), 
                                "assigning variable rts_out");
                    current_statement_begin__ = 248;
                    stan::model::assign(corH, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), 
                                cov2cor(stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H"), pstream__), 
                                "assigning variable corH");
                    current_statement_begin__ = 249;
                    stan::model::assign(log_lik, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                multi_student_t_log(stan::model::rvalue(rts, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "rts"), nu, stan::model::rvalue(mu, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "mu"), stan::model::rvalue(H, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_omni(), stan::model::nil_index_list())), "H")), 
                                "assigning variable log_lik");
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 224;
            size_t A_j_2_max__ = nt;
            size_t A_j_1_max__ = nt;
            size_t A_k_0_max__ = Q;
            for (size_t j_2__ = 0; j_2__ < A_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < A_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < A_k_0_max__; ++k_0__) {
                        vars__.push_back(A[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 225;
            size_t B_j_2_max__ = nt;
            size_t B_j_1_max__ = nt;
            size_t B_k_0_max__ = P;
            for (size_t j_2__ = 0; j_2__ < B_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < B_k_0_max__; ++k_0__) {
                        vars__.push_back(B[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 226;
            size_t rts_out_j_2_max__ = T;
            size_t rts_out_j_1_max__ = nt;
            for (size_t j_2__ = 0; j_2__ < rts_out_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < rts_out_j_1_max__; ++j_1__) {
                    vars__.push_back(rts_out(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 227;
            size_t log_lik_k_0_max__ = T;
            for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
                vars__.push_back(log_lik[k_0__]);
            }
            current_statement_begin__ = 228;
            stan::math::check_corr_matrix(function__, "corC", corC);
            size_t corC_j_2_max__ = nt;
            size_t corC_j_1_max__ = nt;
            for (size_t j_2__ = 0; j_2__ < corC_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < corC_j_1_max__; ++j_1__) {
                    vars__.push_back(corC(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 229;
            size_t corH_i_0_max__ = T;
            for (size_t i_0__ = 0; i_0__ < corH_i_0_max__; ++i_0__) {
                stan::math::check_corr_matrix(function__, "corH[i_0__]", corH[i_0__]);
            }
            size_t corH_j_2_max__ = nt;
            size_t corH_j_1_max__ = nt;
            size_t corH_k_0_max__ = T;
            for (size_t j_2__ = 0; j_2__ < corH_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < corH_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < corH_k_0_max__; ++k_0__) {
                        vars__.push_back(corH[k_0__](j_1__, j_2__));
                    }
                }
            }
            current_statement_begin__ = 230;
            size_t C_var_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < C_var_j_1_max__; ++j_1__) {
                vars__.push_back(C_var(j_1__));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_pdBEKKMGARCH";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta1_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t C_R_j_2_max__ = nt;
        size_t C_R_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < C_R_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < C_R_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "C_R" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t A_diag_j_1_max__ = nt;
        size_t A_diag_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_diag_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_diag_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_diag" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t B_diag_j_1_max__ = nt;
        size_t B_diag_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_diag_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_diag_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "B_diag" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t A_lower_j_1_max__ = od;
        size_t A_lower_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_lower_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_lower_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_lower" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t B_lower_j_1_max__ = od;
        size_t B_lower_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_lower_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_lower_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "B_lower" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t A_upper_j_1_max__ = od;
        size_t A_upper_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_upper_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_upper_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_upper" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t B_upper_j_1_max__ = od;
        size_t B_upper_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_upper_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_upper_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "B_upper" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t H1_init_j_2_max__ = nt;
        size_t H1_init_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < H1_init_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < H1_init_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "H1_init" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t H_j_2_max__ = nt;
            size_t H_j_1_max__ = nt;
            size_t H_k_0_max__ = T;
            for (size_t j_2__ = 0; j_2__ < H_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "H" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t rr_j_2_max__ = nt;
            size_t rr_j_1_max__ = nt;
            size_t rr_k_0_max__ = (T - 1);
            for (size_t j_2__ = 0; j_2__ < rr_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "rr" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t mu_j_1_max__ = nt;
            size_t mu_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t A_part_j_2_max__ = nt;
            size_t A_part_j_1_max__ = nt;
            for (size_t j_2__ = 0; j_2__ < A_part_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < A_part_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "A_part" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t B_part_j_2_max__ = nt;
            size_t B_part_j_1_max__ = nt;
            for (size_t j_2__ = 0; j_2__ < B_part_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < B_part_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "B_part" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t beta_j_2_max__ = nt;
            size_t beta_j_1_max__ = (nt + 1);
            for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t C_sd_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < C_sd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "C_sd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Cnst_j_2_max__ = nt;
            size_t Cnst_j_1_max__ = nt;
            for (size_t j_2__ = 0; j_2__ < Cnst_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Cnst_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Cnst" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t A_raw_j_2_max__ = nt;
            size_t A_raw_j_1_max__ = nt;
            size_t A_raw_k_0_max__ = Q;
            for (size_t j_2__ = 0; j_2__ < A_raw_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < A_raw_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < A_raw_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "A_raw" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t B_raw_j_2_max__ = nt;
            size_t B_raw_j_1_max__ = nt;
            size_t B_raw_k_0_max__ = P;
            for (size_t j_2__ = 0; j_2__ < B_raw_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < B_raw_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < B_raw_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "B_raw" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
        if (!include_gqs__) return;
        size_t A_j_2_max__ = nt;
        size_t A_j_1_max__ = nt;
        size_t A_k_0_max__ = Q;
        for (size_t j_2__ = 0; j_2__ < A_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < A_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < A_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "A" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t B_j_2_max__ = nt;
        size_t B_j_1_max__ = nt;
        size_t B_k_0_max__ = P;
        for (size_t j_2__ = 0; j_2__ < B_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < B_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "B" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t rts_out_j_2_max__ = T;
        size_t rts_out_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < rts_out_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rts_out_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_out" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_k_0_max__ = T;
        for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t corC_j_2_max__ = nt;
        size_t corC_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < corC_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < corC_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "corC" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t corH_j_2_max__ = nt;
        size_t corH_j_1_max__ = nt;
        size_t corH_k_0_max__ = T;
        for (size_t j_2__ = 0; j_2__ < corH_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < corH_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < corH_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "corH" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t C_var_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < C_var_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "C_var" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t phi0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < phi0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "phi0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t phi_j_2_max__ = nt;
        size_t phi_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < phi_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < phi_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "phi" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t theta_j_2_max__ = nt;
        size_t theta_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t beta0_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta0_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta0" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t beta1_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < beta1_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "beta1" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t C_R_j_1_max__ = ((nt * (nt - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < C_R_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "C_R" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t A_diag_j_1_max__ = nt;
        size_t A_diag_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_diag_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_diag_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_diag" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t B_diag_j_1_max__ = nt;
        size_t B_diag_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_diag_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_diag_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "B_diag" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t A_lower_j_1_max__ = od;
        size_t A_lower_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_lower_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_lower_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_lower" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t B_lower_j_1_max__ = od;
        size_t B_lower_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_lower_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_lower_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "B_lower" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t A_upper_j_1_max__ = od;
        size_t A_upper_k_0_max__ = Q;
        for (size_t j_1__ = 0; j_1__ < A_upper_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < A_upper_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "A_upper" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t B_upper_j_1_max__ = od;
        size_t B_upper_k_0_max__ = P;
        for (size_t j_1__ = 0; j_1__ < B_upper_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < B_upper_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "B_upper" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t H1_init_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
        for (size_t j_1__ = 0; j_1__ < H1_init_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "H1_init" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        param_name_stream__.str(std::string());
        param_name_stream__ << "nu";
        param_names__.push_back(param_name_stream__.str());
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t H_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
            size_t H_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < H_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < H_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "H" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t rr_j_2_max__ = nt;
            size_t rr_j_1_max__ = nt;
            size_t rr_k_0_max__ = (T - 1);
            for (size_t j_2__ = 0; j_2__ < rr_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < rr_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < rr_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "rr" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t mu_j_1_max__ = nt;
            size_t mu_k_0_max__ = T;
            for (size_t j_1__ = 0; j_1__ < mu_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < mu_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "mu" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t A_part_j_2_max__ = nt;
            size_t A_part_j_1_max__ = nt;
            for (size_t j_2__ = 0; j_2__ < A_part_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < A_part_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "A_part" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t B_part_j_2_max__ = nt;
            size_t B_part_j_1_max__ = nt;
            for (size_t j_2__ = 0; j_2__ < B_part_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < B_part_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "B_part" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t beta_j_2_max__ = nt;
            size_t beta_j_1_max__ = (nt + 1);
            for (size_t j_2__ = 0; j_2__ < beta_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < beta_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "beta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t C_sd_j_1_max__ = nt;
            for (size_t j_1__ = 0; j_1__ < C_sd_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "C_sd" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Cnst_j_1_max__ = (nt + ((nt * (nt - 1)) / 2));
            for (size_t j_1__ = 0; j_1__ < Cnst_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Cnst" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t A_raw_j_2_max__ = nt;
            size_t A_raw_j_1_max__ = nt;
            size_t A_raw_k_0_max__ = Q;
            for (size_t j_2__ = 0; j_2__ < A_raw_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < A_raw_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < A_raw_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "A_raw" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
            size_t B_raw_j_2_max__ = nt;
            size_t B_raw_j_1_max__ = nt;
            size_t B_raw_k_0_max__ = P;
            for (size_t j_2__ = 0; j_2__ < B_raw_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < B_raw_j_1_max__; ++j_1__) {
                    for (size_t k_0__ = 0; k_0__ < B_raw_k_0_max__; ++k_0__) {
                        param_name_stream__.str(std::string());
                        param_name_stream__ << "B_raw" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                        param_names__.push_back(param_name_stream__.str());
                    }
                }
            }
        }
        if (!include_gqs__) return;
        size_t A_j_2_max__ = nt;
        size_t A_j_1_max__ = nt;
        size_t A_k_0_max__ = Q;
        for (size_t j_2__ = 0; j_2__ < A_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < A_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < A_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "A" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t B_j_2_max__ = nt;
        size_t B_j_1_max__ = nt;
        size_t B_k_0_max__ = P;
        for (size_t j_2__ = 0; j_2__ < B_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < B_j_1_max__; ++j_1__) {
                for (size_t k_0__ = 0; k_0__ < B_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "B" << '.' << k_0__ + 1 << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
        }
        size_t rts_out_j_2_max__ = T;
        size_t rts_out_j_1_max__ = nt;
        for (size_t j_2__ = 0; j_2__ < rts_out_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < rts_out_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "rts_out" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t log_lik_k_0_max__ = T;
        for (size_t k_0__ = 0; k_0__ < log_lik_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t corC_j_1_max__ = ((nt * (nt - 1)) / 2);
        for (size_t j_1__ = 0; j_1__ < corC_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "corC" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t corH_j_1_max__ = ((nt * (nt - 1)) / 2);
        size_t corH_k_0_max__ = T;
        for (size_t j_1__ = 0; j_1__ < corH_j_1_max__; ++j_1__) {
            for (size_t k_0__ = 0; k_0__ < corH_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "corH" << '.' << k_0__ + 1 << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t C_var_j_1_max__ = nt;
        for (size_t j_1__ = 0; j_1__ < C_var_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "C_var" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
    }
}; // model
}  // namespace
typedef model_pdBEKKMGARCH_namespace::model_pdBEKKMGARCH stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
