# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Find first common ancestor of 2 nodes in an hclust object
#' 
#' @param hc an hclust object
#' @param a an integer vector with the first leaf node
#' @param b an integer vector with the second leaf node (same length as a)
#' @return an integer vector of the same length as a and b identifing the first common ancestors of a and b
#' @author Julien Prados
#' @export
#' @useDynLib bmrm
#' @import Rcpp
#' @examples
#'   hc <- hclust(dist(USArrests), "complete")
#'   plot(hc)
#'   A <- outer(seq_along(hc$order),seq_along(hc$order),hclust_fca,hc=hc)
#'   H <- array(hc$height[A],dim(A))
#'   image(H[hc$order,hc$order])
#'   image(A[hc$order,hc$order])
hclust_fca <- function(hc, a, b) {
    .Call('_bmrm_hclust_fca', PACKAGE = 'bmrm', hc, a, b)
}

