% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{s3_read}
\alias{s3_read}
\title{Download and read a file from S3, then clean up}
\usage{
s3_read(uri, fun, ..., extract = c("none", "gzip", "bzip2", "xz"))
}
\arguments{
\item{uri}{string, URI of an S3 object, should start with \code{s3://}, then bucket name and object key}

\item{fun}{R function to read the file, eg \code{fromJSON}, \code{stream_in}, \code{fread} or \code{readRDS}}

\item{...}{optional params passed to \code{fun}}

\item{extract}{optionally extract/decompress the file after downloading from S3 but before passing to \code{fun}}
}
\value{
R object
}
\description{
Download and read a file from S3, then clean up
}
\examples{
\dontrun{
s3_read('s3://botor/example-data/mtcars.csv', read.csv)
s3_read('s3://botor/example-data/mtcars.csv', data.table::fread)
s3_read('s3://botor/example-data/mtcars.csv2', read.csv2)
s3_read('s3://botor/example-data/mtcars.RDS', readRDS)
s3_read('s3://botor/example-data/mtcars.json', jsonlite::fromJSON)
s3_read('s3://botor/example-data/mtcars.jsonl', jsonlite::stream_in)

## read compressed data
s3_read('s3://botor/example-data/mtcars.csv.gz', read.csv, extract = 'gzip')
s3_read('s3://botor/example-data/mtcars.csv.gz', data.table::fread, extract = 'gzip')
s3_read('s3://botor/example-data/mtcars.csv.bz2', read.csv, extract = 'bzip2')
s3_read('s3://botor/example-data/mtcars.csv.xz', read.csv, extract = 'xz')
}
}
