% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permkCCA_multipleRegion.R
\name{permkCCA_multipleRegion}
\alias{permkCCA_multipleRegion}
\title{Calculation of Strength of the Connectivity among multiple Brain Regions}
\usage{
permkCCA_multipleRegion(imageDat, region, resolution = "2mm",
  saveName = "None", kernel = "rbfdot", regionCode = "", niiFile2 = "",
  imgPath = getwd(), datPath = getwd(), parallel = FALSE, loc = "local",
  perm = 50, saveData = "None")
}
\arguments{
\item{imageDat}{there are two options for this argument: (1)(vectors of) imaging data (with extension .nii or .nii.gz).
You do not need to add extension in your argument, simply type in the name of file is enough. (2) the processed image data
produced by "nii2RData" function. No matter which option you choose, the result will be the same (as long as you use the same
dataset). When you would like to read and save nii data first and run kcca test later, you can first save output of "nii2RData"
and, in the future, choose option (2) to run kcca in order to save time (avoid reading same dataset multiple times).}

\item{region}{user-specified multiple brain regions (as vector, for example, c(1,2,30)).}

\item{resolution}{the resolution of your region data. It can take "2mm" as default.
If user would like to use 3mm resolution, type in "3mm".}

\item{saveName}{whether to save processed imaging data.
If you do not have enough space or do not want to use space to store processed data, just type in "None" (default);
otherwise you need to specify name in this argument. For example, saveName="myName.RData".}

\item{kernel}{the kernel function used in training and predicting.
The default kernel is the radial basis kernel function "Gaussian" (rbfdot). Use "?kernlab::kcca" to find more available kernels.}

\item{regionCode}{the region code provided by user or default. It should have 3 columns with index, region code and region name.}

\item{niiFile2}{the nii region file you would like to use. It has default nii file and can be left as blank.}

\item{imgPath}{the directory where your nii file(s) is (are) located. It chooses your current working directory as default.}

\item{datPath}{the directory where you would like to store .RData file(s). It chooses your current working directory as default.}

\item{parallel}{whether to use parallel computing. Type FALSE as not using parallel and TRUE as using parallel. Parallel is not
recommended in local computer as it may slow down your system. Use parallel in cluster is preferred}

\item{loc}{this argument can accept argument "local" or "cluster". if you choose to use parallel computing, please specify whether
you run your code in your local computer or cluster.
If you did not choose parallel computing, then "local" or "clutser" makes no difference.}

\item{perm}{number of permutation. Default time is 50.}

\item{saveData}{whether to save output as R data. Type "None" as not save output.
Type name of file if you would like to save. For example, "output_two.RData".}
}
\value{
(lists of) list of brain regions, p-value, region type ("two" or "multiple"), and sregion name.
}
\description{
This function can calculate strength of the connectivity among multiple brain regions via kernel canonical correlation analysis.
Permutaiton test is employed to assess the statistical significance. The p-values are adjusted for multiple testing.
}
\details{
(1) Kernel canonical correlation analysis (KCCA) can explore the nonlinear relationship between two variables.
It transformed sample vectors into the Hilbert space and maximize correlation coefficient by solving quadratically regularized
Lagrangean function.
Refer to Kang's paper for more details: Kang J, Bowman FD, Mayberg H, Liu H (2016). "A depression network of functionallyconnected
regions discovered via multi-attribute canonical correlation graphs."NeuroImage,141, 431-441.
(2) Use rgl.snapshot() function if you would like to save plot but forgot to use TRUE in screenShot argument.
}
\examples{
\donttest{
#It will take more than 10 s to run
#write data into temp file
filePath <- tempdir()
#the nii.gz fMRI imaging file is created (toy example)
oro.nifti::writeNIfTI(brainKCCA::input_img, paste(filePath, "/",  "temp", sep=""))
#read fMRI data
testcase1 <- nii2RData(niiFile1 = "temp", resolution = "3mm", imgPath = filePath)
result1<-permkCCA_multipleRegion(imageDat = testcase1, region = c(1,5,10))
}
}
\references{
\url{https://www.ncbi.nlm.nih.gov/pubmed/27474522}
}
\author{
Xubo Yue, Chia-Wei Hsu (tester), Jian Kang (maintainer)
}
