% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_alpha_estimates.R
\name{plot.alpha_estimates}
\alias{plot.alpha_estimates}
\title{Plot function for alpha_estimates class}
\usage{
\method{plot}{alpha_estimates}(
  x,
  physeq = NULL,
  measure = NULL,
  color = NULL,
  shape = NULL,
  title = NULL,
  trim_plot = FALSE,
  ...
)
}
\arguments{
\item{x}{Object of class \code{alpha_estimates}.}

\item{physeq}{(Optional). Default \code{NULL}. Required object of class \code{phyloseq} if including a \code{sample_data} variable for \code{color} or \code{shape}.}

\item{measure}{(Optional). If there are multiple richness measures included in \code{x}, this can be set to the the desired measure to be plotted. Defaults to the measure of the first alpha diversity estimate.}

\item{color}{(Optional). Default \code{NULL}. The sample variable to map to different colors. Can be a single character string of the variable name in \code{sample_data} or a custom supplied vector with length equal to the number of samples.}

\item{shape}{(Optional). Default \code{NULL}. The sample variable to map to different shapes. Can be a single character string of the variable name in \code{sample_data} or a custom supplied vector with length equal to the number of samples.}

\item{title}{(Optional). Default NULL. Character string. The main title for the graphic.}

\item{trim_plot}{(Optional). Default \code{FALSE}. Boolean indicator for whether you want the plot to include the full confidence intervals.}

\item{...}{See details}
}
\value{
A ggplot object with samples on the x-axis and estimated
alpha diversities on the y-axis
}
\description{
Plot function for alpha_estimates class
}
\details{
... does not currently have any implemented options. Optional arguments currently include "trim_plot", a  Optional
}
\examples{
\dontrun{
library(phyloseq)
data(GlobalPatterns)
alphas <- breakaway(GlobalPatterns)
plot(alphas)
}
}
