context("test-poisson")
library(breakaway)
library(phyloseq)

mytab <- data.frame(
  UID115 = c(0, 0, 30, 0, 51, 28, 805, 142, 41, 0, 0, 204, 1697, 55, 0, 0,
             0, 0, 0, 1, 272, 0, 0, 1),
  UID187 = c(1, 0, 591, 0, 491, 26, 1993, 5505, 21, 0, 2079, 2848, 22308,
             4271, 0, 0, 0, 0, 0, 0, 5268, 0, 0, 0),
  UID190 = c(1, 0, 852, 0, 767, 54, 2515, 4544, 24, 0, 1620, 4202, 24342,
             4627, 0, 0, 0, 0, 0, 0, 4768, 0, 0, 0),
  UID196 = c(1, 0, 1067, 0, 2414, 61, 2777, 7547, 31, 0, 1368, 5862, 27822,
             3344, 0, 0, 0, 0, 0, 0, 6155, 0, 0, 0),
  UID283 = c(0, 0, 379, 0, 157, 0, 3025, 455, 1, 0, 643, 1676, 84, 175, 1,
             1, 24, 25, 0, 14, 2831, 0, 0, 0),
  UID328 = c(1, 0, 0, 0, 922, 59, 3004, 7736, 24, 0, 0, 2972, 19601, 6854,
             0, 0, 0, 0, 0, 0, 1808, 0, 0, 0),
  UID369 = c(1, 0, 1044, 0, 3366, 72, 4250, 6641, 24, 0, 1, 7666, 30688,
             2600, 0, 0, 0, 0, 0, 278, 3219, 0, 0, 0),
  UID372 = c(1, 0, 916, 0, 2087, 64, 3325, 5850, 22, 0, 1, 6566, 23950,
             1499, 0, 0, 106, 0, 0, 315, 1594, 0, 0, 0),
  UID525 = c(1, 0, 684, 0, 61, 42, 11586, 194, 11, 0, 1605, 1849, 2909,
             612, 0, 23, 39, 0, 0, 139, 3591, 0, 0, 0),
  UID552 = c(1, 0, 0, 0, 905, 64, 7732, 14968, 18, 0, 0, 2125, 8501, 1427,
             0, 0, 0, 0, 0, 0, 783, 0, 0, 0),
  UID579 = c(1, 0, 852, 0, 784, 68, 6913, 8893, 23, 0, 403, 8270, 11112,
             5052, 0, 0, 265, 0, 0, 201, 5262, 0, 0, 0),
  UID73 = c(0, 0, 1478, 0, 400, 108, 11488, 1425, 47, 0, 256, 4704, 12101,
            373, 0, 1, 375, 0, 0, 274, 9833, 0, 0, 0)
)
row.names(mytab) <- c("HAMBI-0012", "HAMBI-1117", "HAMBI-0135", "HAMBI-0002",
                      "HAMBI-0445", "HAMBI-1279", "HAMBI-1287", "HAMBI-1292",
                      "HAMBI-5728", "HAMBI-4204", "HAMBI-6789", "HAMBI-1923", "HAMBI-2345",
                      "HAMBI-1277", "HAMBI-2234", "HAMBI-2453", "HAMBI-4352",
                      "HAMBI-3452", "HAMBI-2443", "HAMBI-4527", "HAMBI-4673", "HAMBI-9999",
                      "HAMBI-5862", "HAMBI-1111")

issue92 <- data.frame("x" = c(405, 1016, 2154, 5126, 5537, 6248, 11467, 23834, 47225, 65885, 116542, 124083, 190920, 1303602, 1707824, 1773553, 1966716, 2672048, 9362283),
                      "f" = c(1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1))


issue110 <- data.frame("x" = c(1, 2, 3, 4, 5, 6, 7, 8, 9, 11, 14, 16, 18, 24, 35, 121, 136),
                       "f" = c(934, 139, 43, 19, 8, 1, 3, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1))[1:10, ]

test_that("no issues with few rare species dataset", {
  skip_on_cran()
  myphylo <- phyloseq(otu_table(mytab, taxa_are_rows = TRUE))
  expect_warning(breakaway(myphylo))
  expect_is(poisson_model(myphylo, cutoff = 100), "alpha_estimates")

  expect_warning(breakaway(issue92))

})


test_that("no issues with many rare species dataset", {
  skip_on_cran()

  sample_richness(issue110)
  poisson_model(issue110) %>% class
  expect_is( breakaway(issue110), "alpha_estimate")
  expect_is( poisson_model(issue110), "alpha_estimate")
})

