% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pheno2covar.R
\name{pheno2covar}
\alias{pheno2covar}
\title{Create a covariate from a trait}
\usage{
pheno2covar(data_obj, pheno_which)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{pheno_which}{vector of trait names to be used as covariates}
}
\value{
Returns the data object with the specified traits removed
from the phenotype matrix and transferred where they will be used
as covariates. Information about assigned covariates can be retrieved
with \code{\link{get_covar}}.
}
\description{
This function takes a variable from the phenotype matrix
for example, diet treatment or sex and converts it to
a covariate.
}
\examples{
\dontrun{
#convert weight to a covariate
data_obj <- pheno2covar(data_obj, "weight")
}
}
