% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictLinks.R
\name{PredictLinks}
\alias{PredictLinks}
\title{Generates a network list from a food web and fits all network models}
\usage{
PredictLinks(web, RepeatModels = 10)
}
\arguments{
\item{web}{in format specified by the bipartite package. Rows = focal layer, columns = response layer}

\item{RepeatModels}{How many times to fit each model from different starting points. Uses best half (rounding up)}
}
\value{
A network list including a large number of outputs.
}
\description{
First calls \code{CreateListObject} to convert a matrix suitable for the bipartite package into a list structure.
}
\details{
Then it calls \code{FitAllModels} to fit each of the missing link models in turn.
}
\examples{
\dontrun{
data(Safariland, package = 'bipartite')
PredictLinks(Safariland)
}

\dontshow{
data(Safariland,package = 'bipartite')
PredictLinks(Safariland[,1:10], RepeatModels = 1) # Smaller to finish in time for CRAN tests
}




}
