% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_node.R
\name{create_node}
\alias{create_node}
\title{Node creator}
\usage{
create_node(ID, dens_vec, item, item_prev, est, SE, ID_sons, D, as_val)
}
\arguments{
\item{ID}{integer that represents the specified node identification in the
form of \code{10000*level+position}.}

\item{dens_vec}{vector of the density function values in the specified node
of the evaluated ability levels}

\item{item}{integer that represents the item of the specified node}

\item{item_prev}{vector of items of the previous nodes}

\item{est}{estimated ability level in the specified node}

\item{SE}{standard error of the estimated ability level}

\item{ID_sons}{data frame containing the information of the sons of the
specified node. Rows represent sons and columns represent the ID of the son,
the response given to the item of the specified node that leaded to the son
and the probability of reaching the son given that response (not equal to
one if the son had previously splitted)}

\item{D}{confluency of the specified node}

\item{as_val}{associated value of the specified node. It can be the MSE if
the selection criterium is "MEPV" and the FI if the selection criterium is
"MFI"}
}
\value{
A list that represents a node of the decision tree
}
\description{
Generates a list that represents a specific node of the CAT decision tree
}
\author{
Javier Rodr?guez-Cuadrado
}
