% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_ratings.R
\name{cfbd_rankings}
\alias{cfbd_rankings}
\title{\strong{Get historical Coaches and AP poll data}}
\usage{
cfbd_rankings(year, week = NULL, season_type = "regular")
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format (\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week, values from 1-15, 1-14 for seasons pre-playoff (i.e. 2013 or earlier)}

\item{season_type}{(\emph{String} default regular): Season type - regular or postseason}
}
\value{
\code{\link[=cfbd_rankings]{cfbd_rankings()}} - A data frame with 9 variables:
\describe{
\item{\code{season}: integer.}{Rankings season.}
\item{\code{season_type}: character.}{Season type of rankings.}
\item{\code{week}: integer.}{Week of rankings.}
\item{\code{poll}: character.}{Name of the poll.}
\item{\code{rank}: integer.}{Rank in the poll.}
\item{\code{school}: character.}{Team name.}
\item{\code{conference}: character.}{Conference of the team.}
\item{\code{first_place_votes}: integer.}{Number of first place votes.}
\item{\code{points}: integer.}{Total poll points.}
}
}
\description{
\strong{Get historical Coaches and AP poll data}
}
\examples{
\donttest{
cfbd_rankings(year = 2019, week = 12)

cfbd_rankings(year = 2018, week = 14)

cfbd_rankings(year = 2013, season_type = "postseason")
}

}
\keyword{CFB}
\keyword{Rankings}
