% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_teams.R
\name{cfbd_team_matchup_records}
\alias{cfbd_team_matchup_records}
\title{\strong{Get matchup history records between two teams.}}
\usage{
cfbd_team_matchup_records(team1, team2, min_year = NULL, max_year = NULL)
}
\arguments{
\item{team1}{(\emph{String} required): D-I Team 1}

\item{team2}{(\emph{String} required): D-I Team 2}

\item{min_year}{(\emph{Integer} optional): Minimum of year range, 4 digit format (\emph{YYYY})}

\item{max_year}{(\emph{Integer} optional): Maximum of year range, 4 digit format (\emph{YYYY})}
}
\value{
\code{\link[=cfbd_team_matchup_records]{cfbd_team_matchup_records()}} - A data frame with 7 variables:
\describe{
\item{\code{start_year}: character.}{Span starting year.}
\item{\code{end_year}: character.}{Span ending year.}
\item{\code{team1}: character.}{First team selected in query.}
\item{\code{team1_wins}: character.}{First team wins in series against \code{team2}.}
\item{\code{team2}: character.}{Second team selected in query.}
\item{\code{team2_wins}: character.}{Second team wins in series against \code{team1}.}
\item{\code{ties}: character.}{Number of ties in the series.}
}
}
\description{
\strong{Get matchup history records between two teams.}
}
\examples{
\donttest{
cfbd_team_matchup_records("Texas", "Oklahoma")

cfbd_team_matchup_records("Texas A&M", "TCU", min_year = 1975)
}

}
\keyword{Matchup}
\keyword{Records}
\keyword{Team}
