% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_polynomial.R
\name{local.refine.poly}
\alias{local.refine.poly}
\title{Local refinement for univariate polynomials change point detection.}
\usage{
local.refine.poly(cpt_init, y, r, delta_lr)
}
\arguments{
\item{cpt_init}{An \code{integer} vector of initial change points estimation (sorted in strictly increasing order).}

\item{y}{A \code{numeric} vector of univariate time series.}

\item{r}{An \code{integer} scalar order of polynomials.}

\item{delta_lr}{A positive \code{integer} scalar of minimum spacing for local refinement.}
}
\value{
An \code{integer} vector of locally refined change point estimation.
}
\description{
Perform local refinement for univariate polynomials change point detection.
}
\examples{
set.seed(0)
cpt_true = c(20, 50, 170)
y = rnorm(300) + c(rep(0,20),rep(2,30),rep(0,120),rep(2,130))
plot.ts(y)
gamma_set = 3:9
DP_result = CV.search.DP.poly(y, r = 2, gamma_set, delta = 5)
min_idx = which.min(DP_result$test_error)
cpt_init = unlist(DP_result$cpt_hat[min_idx])
local.refine.poly(cpt_init, y, r = 2, delta_lr = 5)
}
\references{
Yu and Chatterjee (2020) <arXiv:2007.09910>
}
\author{
Haotian Xu
}
