% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base-provider.R
\name{BaseProvider}
\alias{BaseProvider}
\title{BaseProvider}
\description{
BaseProvider

BaseProvider
}
\examples{
(x <- BaseProvider$new())

x$numerify("#\%\%asdf221?")
x$lexify("#\%\%asdf221?")
x$bothify("#\%\%asdf221?")

z <- PhoneNumberProvider$new()
x$numerify(z$render())

x$random_element(letters)
x$random_int()
x$random_digit()
x$random_digit_not_zero()
x$random_digit_or_empty()
x$random_digit_not_zero_or_empty()
x$random_letter()
x$check_locale("es_ES")
## fails
# x$check_locale("es_EQ")

x$randomize_nb_elements()
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-random_element}{\code{BaseProvider$random_element()}}
\item \href{#method-random_element_prob}{\code{BaseProvider$random_element_prob()}}
\item \href{#method-random_int}{\code{BaseProvider$random_int()}}
\item \href{#method-random_digit}{\code{BaseProvider$random_digit()}}
\item \href{#method-random_digit_not_zero}{\code{BaseProvider$random_digit_not_zero()}}
\item \href{#method-random_digit_or_empty}{\code{BaseProvider$random_digit_or_empty()}}
\item \href{#method-random_digit_not_zero_or_empty}{\code{BaseProvider$random_digit_not_zero_or_empty()}}
\item \href{#method-random_letter}{\code{BaseProvider$random_letter()}}
\item \href{#method-numerify}{\code{BaseProvider$numerify()}}
\item \href{#method-lexify}{\code{BaseProvider$lexify()}}
\item \href{#method-bothify}{\code{BaseProvider$bothify()}}
\item \href{#method-check_locale}{\code{BaseProvider$check_locale()}}
\item \href{#method-randomize_nb_elements}{\code{BaseProvider$randomize_nb_elements()}}
\item \href{#method-clone}{\code{BaseProvider$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-random_element"></a>}}
\subsection{Method \code{random_element()}}{
pick a random element from vector/list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$random_element(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector or list}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a single element from x
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-random_element_prob"></a>}}
\subsection{Method \code{random_element_prob()}}{
pick a random element with probability from vector/list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$random_element_prob(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{vector or list}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-random_int"></a>}}
\subsection{Method \code{random_int()}}{
any number of random integers from a min, max
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$random_int(min = 0, max = 9999, size = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{min}}{the minimum value. default: 0}

\item{\code{max}}{the maximum value. default: 9999}

\item{\code{size}}{number of values to return. default: 1}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
random integer
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-random_digit"></a>}}
\subsection{Method \code{random_digit()}}{
random integer between 0 and 9
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$random_digit()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-random_digit_not_zero"></a>}}
\subsection{Method \code{random_digit_not_zero()}}{
random integer between 1 and 9
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$random_digit_not_zero()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-random_digit_or_empty"></a>}}
\subsection{Method \code{random_digit_or_empty()}}{
random integer between 0 and 9 or empty character string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$random_digit_or_empty()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-random_digit_not_zero_or_empty"></a>}}
\subsection{Method \code{random_digit_not_zero_or_empty()}}{
random integer between 1 and 9 or empty character string
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$random_digit_not_zero_or_empty()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-random_letter"></a>}}
\subsection{Method \code{random_letter()}}{
random letter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$random_letter()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-numerify"></a>}}
\subsection{Method \code{numerify()}}{
replace a template with numbers
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$numerify(text = "###")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{(character) a string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-lexify"></a>}}
\subsection{Method \code{lexify()}}{
replace a template with letters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$lexify(text = "????")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{(character) a string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bothify"></a>}}
\subsection{Method \code{bothify()}}{
both numerify and lexify together
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$bothify(text = "## ??")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{text}}{(character) a string}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-check_locale"></a>}}
\subsection{Method \code{check_locale()}}{
check a locale to see if it exists, if not, stop with
error message
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$check_locale(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{a locale name, e.g, 'bg_BG'}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
returns nothing if locale is supported; stops w/ message if not
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-randomize_nb_elements"></a>}}
\subsection{Method \code{randomize_nb_elements()}}{
Returns a random value near number
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$randomize_nb_elements(
  number = 10,
  le = FALSE,
  ge = FALSE,
  min = NULL,
  max = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{number}}{value to which the result must be near}

\item{\code{le}}{result must be lower or equal to number}

\item{\code{ge}}{result must be greater or equal to number}

\item{\code{min}}{the minimum value. default: \code{NULL}}

\item{\code{max}}{the maximum value. default: \code{NULL}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a random int near number
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BaseProvider$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
