\name{batch.monepar}
\alias{batch.monepar}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
batch analysis to explore multiple species coexistence density for a varying parameter under multiple-species modeling
}
\description{
The batch form of sta.comparison() function, therefore handling different scenarios simultaneously.
}
\usage{
batch.monepar(coexistlist, coenum, island, spnum, parameters)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{coexistlist}{
a list of data generated by batch.mcoexistence() function
}
  \item{coenum}{
coexisting species number in a patch you want to explore across the scenarios. Should be >=2 and <=total species number
}
  \item{island}{
number of patches in the modeling
}
  \item{spnum}{
number of species in the moeling
}
  \item{parameters}{
a parameter sampling point vector,for example parameters=c(.2,.5,.9), indicating three sampling points in a single
parameter. The function will thus compare the coexistence patch numbers under the cases when the parameter (for example,
growth rate for species 1)=0.2,0.5 and 0.9 respectively.
}
}

\value{
will return a nested list, each list member is a list for one scneario, inside of which are the list members- matrices for each of possible
 parameters (for example, r1,r2,disp1,disp2,comp1,comp2,etc).
}
\references{
Chen YH (2012) coexist: an R package for performing species coexistence modeling and analysis under asymmetric dispersal and fluctuating source-sink dynamics.
http://code.google.com/p/coexist.
}
\author{
Youhua Chen <yhchen@zoology.ubc.ca>
}

\seealso{
\code{\link{sta.mcomparison}}, 
\code{\link{batch.mpaircomp}}
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (coexistlist, coenum, island, spnum, parameters) 
{
    if (is.list(coexistlist)) {
        scenarionum <- length(coexistlist)
        pairlist <- list()
        length(pairlist) <- scenarionum
        for (i in 1:scenarionum) {
            pairlist[[i]] <- sta.mcomparison(coexistlist[[i]], 
                coenum, island, spnum, parameters = parameters)
        }
        return(pairlist)
    }
  }
}
