% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_output_visualization.R
\name{scatter3dclusters}
\alias{scatter3dclusters}
\title{Plot 3D clusters in a 2D plot}
\usage{
scatter3dclusters(
  clusters,
  color.space,
  ref.white = "D65",
  xlim = "default",
  ylim = "default",
  zlim = "default",
  main = "Color clusters",
  scaling = 10,
  opacity = 0.9,
  plus = 0.01,
  ...
)
}
\arguments{
\item{clusters}{A single dataframe or a list of dataframes as returned by
\code{\link{getLabHist}}, \code{\link{getLabHistList}}, or
\code{\link{extractClusters}}. First three columns must be color
coordinates and fourth column must be cluster size.}

\item{color.space}{The color space (\code{"rgb"}, \code{"hsv"}, or
\code{"lab"}) in which to plot. If not specified, the function uses column
names to guess the color space.}

\item{ref.white}{Standard reference white for converting lab coordinates to
RGB coordinates for coloring clusters. One of either "A", "B", "C", "E",
"D50", "D55", or "D65".}

\item{xlim, ylim, zlim}{X, Y, and Z-axis limits. If not specified, the defaults
are 0-1 for all channels in RGB and HSV space, or 0-100 for L and -100-100
for a and b channels of CIE Lab space.}

\item{main}{Title for the plot.}

\item{scaling}{Scaling factor for size of clusters.}

\item{opacity}{Transparency value for plotting; must be between 0 and 1.}

\item{plus}{Amount to add to percent column for plotting; can help to make
very small (or 0) clusters visible.}

\item{...}{Additional parameters passed to
\code{\link[scatterplot3d]{scatterplot3d}}.}
}
\description{
Uses \code{\link[scatterplot3d]{scatterplot3d}} to plot clusters in color
space.
}
\examples{
clusters <- data.frame(R = runif(20, min = 0, max = 1),
                       G = runif(20, min = 0, max = 1),
                       B = runif(20, min = 0, max = 1),
                       Pct = runif(20, min = 0, max = 1))
# plot in RGB space
scatter3dclusters(clusters, scaling = 15, plus = 0.05)

# overrule determined color space and plot in HSV space
scatter3dclusters(clusters, scaling = 15, plus = 0.05, color.space = "hsv")
}
\seealso{
\code{\link{plotClusters}}, \code{\link{plotClustersMulti}}
}
