# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generate Autocorrelated Noise
#'
#' Generates temporally autocorrelated random numbers with a mean,
#' standard deviation, and autocorrelation you specify.
#' @param timesteps The number of temporally autocorrelated random numbers (one
#'   per timestep) you want.
#' @param mean The mean of the temporally autocorrelated random numbers.
#' @param sd The standard deviation of the temporally autocorrelated random
#'   numbers.
#' @param phi The temporal autocorrelation. 0 is white noise (uncorrelated),
#'   positive values are red noise (directly correlated) and negative values are blue
#'   noise (inversely correlated).
#' @return A vector of temporally autocorrelated random numbers.
#' @examples
#' rednoise <- colored_noise(timesteps = 30, mean = 0.5, sd = 0.2, phi = 0.3)
#' rednoise
#' @export
colored_noise <- function(timesteps, mean, sd, phi) {
    .Call(`_colorednoise_colored_noise`, timesteps, mean, sd, phi)
}

#' Generate Correlated Normal Random Numbers
#'
#' Generate random numbers from a multivariate normal distribution.
#' It can be used to create correlated random numbers.
#' @param n The number of samples desired for each variable.
#' @param mean A vector giving the mean of each variable.
#' @param sd A valid covariance matrix.
#' @return A matrix with n rows and as many columns as mean values.
#' @examples
#' mus <- c(0, 3, 5)
#' sigmas <- matrix(c(1, 0.265, 2.19, 0.265, 0.25, 0.66, 2.19, 0.66, 9), ncol = 3)
#' mat <- multi_rnorm(100, mus, sigmas)
#' var(mat)
#' @export
multi_rnorm <- function(n, mean, sd) {
    .Call(`_colorednoise_multi_rnorm`, n, mean, sd)
}

#' Convert from Correlation Matrix to Covariance Matrix
#'
#' Convert a correlation matrix to a covariance matrix.
#' @param sigma A vector of standard deviations for the variables you're describing. Length must be the same as the number of rows/columns of CorrMatrix.
#' @param corrMatrix A valid correlation matrix.
#' @return A covariance matrix with the same dimensions as corrMatrix.
#' @examples
#' corr <- matrix(c(1, 0.53, 0.73, 0.53, 1, 0.44, 0.73, 0.44, 1), nrow = 3)
#' sigmas <- c(2, 0.3, 1.2)
#' covar <- cor2cov(sigmas, corr)
#' cov2cor(covar)
#' @export
cor2cov <- function(sigma, corrMatrix) {
    .Call(`_colorednoise_cor2cov`, sigma, corrMatrix)
}

#' Generate Multiple Cross-Correlated & Autocorrelated Variables
#'
#' Generates random variables that are correlated to each other and temporally autocorrelated.
#'
#' @param timesteps The number of temporally autocorrelated random numbers (one
#'   per timestep) you want.
#' @param mean A vector giving the mean of each variable.
#' @param sd A vector giving the standard deviation of each variable.
#' @param phi A vector giving the temporal autocorrelation of each variable.
#' @param covMatrix A valid covariance matrix. The number of rows/columns must match the length of the mu, sigma, and phi vectors.
#' @return A matrix with as many rows as timesteps and as many columns as mu/sigma/phi values.
#' @examples
#' cov <- matrix(c(1, 0.53, 0.73, 0.53, 1, 0.44, 0.73, 0.44, 1), nrow = 3)
#' test <- colored_multi_rnorm(100, c(0, 3, 5), c(1, 0.5, 1), c(0.5, -0.3, 0), cov)
#' var(test)
#' library(data.table)
#' as.data.table(test)[, .(V1_mean = mean(V1), V2_mean = mean(V2), V3_mean = mean(V3),
#' V1_sd = sd(V1), V2_sd = sd(V2), V3_sd = sd(V3),
#' V1_autocorrelation = autocorrelation(V1), V2_autocorrelation = autocorrelation(V2),
#' V3_autocorrelation = autocorrelation(V3))]
#' @export
colored_multi_rnorm <- function(timesteps, mean, sd, phi, covMatrix) {
    .Call(`_colorednoise_colored_multi_rnorm`, timesteps, mean, sd, phi, covMatrix)
}

#' Translate Standard Deviation from the Natural Scale to the Log or Logit Scale
#'
#' This function changes a given standard deviation so that when a vector of samples is drawn from the given distribution,
#' the original standard deviation will be recovered once it is back-transformed from the log or logit scale. In effect,
#' the function "translates" a standard deviation from the natural scale to the log or logit scale for the purposes of
#' random draws from a probability distribution.
#' @param mu The mean of the distribution on the natural scale.
#' @param sigma The standard devation of the distribution on the natural scale.
#' @param dist The distribution to which the standard deviation should be transformed.
#' @return The standard deviation translated to the log or logit scale.
#' @examples
#' mean <- 10
#' stdev <- 2
#' mean_trans <- log(mean)
#' stdev_trans <- stdev_transform(mean, stdev, "log")
#' draws <- rnorm(50, mean_trans, stdev_trans)
#' natural_scale <- exp(draws)
#' mean(draws)
#' sd(draws)
#' @export
stdev_transform <- function(mu, sigma, dist) {
    .Call(`_colorednoise_stdev_transform`, mu, sigma, dist)
}

#' Simulated Time Series of an Unstructured Temporally Autocorrelated Population
#'
#' This function simulates an unstructured population with
#' temporally autocorrelated vital rates (survival and fertility). In other
#' words, this function will show you the dynamics over time of a population
#' whose survival and fertility is stochastic, but also correlated to the
#' survival and fertility in the previous year, respectively. The assumptions of the
#' simulation are that the population is asexually reproducing or female-only,
#' survival and fertility are the same at all ages / stages,
#' and that individuals continue to be reproductively capable until they die. The function
#' includes demographic stochasticity as well as environmental stochasticity, and
#' does not support density dependence at this time.
#'
#' Be advised that not all combinations of values will work. If you set survival and
#' fertility unrealistically high, the population size will tend toward infinity and
#' the simulation will fail because the numbers are too large to handle. Use your
#' common sense as a demographer / population biologist.
#' @param start The starting population size.
#' @param timesteps The number of timesteps you want to simulate. Individuals
#'   are added and killed off every timestep according to the survival and
#'   fertility rates. In ecological applications, timesteps are usually years,
#'   but theoretically they can be any length of time.
#' @param survPhi The temporal autocorrelation of survival. 0 is white noise (uncorrelated),
#'   positive values are red noise (directly correlated) and negative values are
#'   blue noise (inversely correlated).
#' @param fecundPhi The temporal autocorrelation of fecundity. As above.
#' @param survMean The mean survival from timestep to timestep. Must be a value
#'   between 0 (all individuals die) and 1 (all individuals live).
#' @param survSd The standard deviation of the survival from timestep to
#'   timestep. Must be a value between 0 and 1.
#' @param fecundMean The mean fertility: mean offspring produced by each individual per timestep.
#' @param fecundSd The standard deviation of the fertility.
#' @return A data frame with four variables: timestep, population (total individuals
#'   alive at the start of the timestep), newborns (new individuals
#'   born this timestep), and survivors (individuals who survive this timestep).
#' @examples
#' series1 <- unstructured_pop(start = 20, timesteps = 10, survPhi = 0.7, fecundPhi = -0.1,
#' survMean = 0.6, survSd = 0.52, fecundMean = 1.2, fecundSd = 0.7)
#' head(series1)
#' @export
unstructured_pop <- function(start, timesteps, survPhi, fecundPhi, survMean, survSd, fecundMean, fecundSd) {
    .Call(`_colorednoise_unstructured_pop`, start, timesteps, survPhi, fecundPhi, survMean, survSd, fecundMean, fecundSd)
}

projection <- function(initialPop, noise) {
    .Call(`_colorednoise_projection`, initialPop, noise)
}

