% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nbacolors.r
\name{nba.colors}
\alias{nba.colors}
\title{NBA colors}
\usage{
nba.colors(set = c("hawks", "hornets", "mavs", "warriors", "clippers", "heat",
  "pelicans", "magic", "blazers", "raptors", "celtics", "bulls", "nuggets",
  "rockets", "lakers", "bucks", "knicks", "sixers", "kings", "jazz", "nets",
  "cavs", "pistons", "pacers", "grizzlies", "wolves", "thunder", "suns",
  "spurs", "wizards", "sonics"))
}
\arguments{
\item{set}{Character string denoting an NBA team's color palette.}
}
\value{
Vector of character strings from the selected NBA team's color palette.
}
\description{
Function returns a vector of character strings from a selected NBA team's color palette. The team options are c("hawks", "hornets", "mavs", "warriors", "clippers", "heat", "pelicans", "magic", "blazers", "raptors", "celtics", "bulls", "nuggets", "rockets", "lakers", "bucks", "knicks", "sixers", "kings", "jazz", "nets", "cavs", "pistons", "pacers", "grizzlies", "wolves", "thunder", "suns", "spurs", "wizards", "sonics")
}
\examples{
\dontrun{
# Detroit Pistons colors
(pal = nba.colors("pistons"))
pie(rep(1, length(pal)), labels = sprintf("\%d (\%s)", seq_along(pal), pal), col = pal)

# Milwaukee Bucks colors
(pal = nba.colors("bucks"))
pie(rep(1, length(pal)), labels = sprintf("\%d (\%s)", seq_along(pal), pal), col = pal)
}
}
\author{
Charles Crabtree \email{ccrabtr@umich.edu}
}
