% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcATHBpmv.r
\name{calcATHBpmv}
\alias{calcATHBpmv}
\title{PMV based on Adaptive Thermal Heat Balance Framework}
\usage{
calcATHBpmv(trm, psych, ta, tr, vel, rh, met, wme)
}
\arguments{
\item{trm}{- Running mean outdoor temperature in [degree C]}

\item{psych}{- factor related to fixed effect on perceived control}

\item{ta}{- a numeric value presenting air temperature in [degree C]}

\item{tr}{- a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{- a numeric value presenting air velocity in [m/s]}

\item{rh}{- a numeric value presenting relative humidity [\%]}

\item{met}{- a numeric value presenting metabolic rate in [met]}

\item{wme}{- a numeric value presenting external work in [met]}
}
\value{
\code{calcATHBpmv} PMV value adapted through the ATHB appoach
}
\description{
\code{calcATHBpmv} calculates the PMV based on adaptive thermal heat balance framework
}
\details{
aliases athb ATHB

All variables must have the same length 1. For the calculation of several values use function \code{calcComfInd}.
}
\examples{
calcATHBpmv(20, 0, 25, 25, .1, 50, 1.1, 0)
}
\references{
Schweiker & Wagner (2015) <doi:10.1016/j.buildenv.2015.08.018>
Schweiker & Wagner (2016) Exploring potentials and limitations of the adaptive thermal heat balance framework Proceedings of 9th Windsor Conference: making comfort relevant Cumberland Lodge, Windsor, UK, 2016
}
\seealso{
see also \code{\link{calcComfInd}}, \code{link{calcATHBpts}}, \code{link{calcATHBset}}
}
\author{
Marcel Schweiker
}
