% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plot.bootcoefs}
\alias{plot.bootcoefs}
\title{Plot the distribution of the bootstrap estimates}
\usage{
\method{plot}{bootcoefs}(x, y = NULL, conf.level = 0.95,
  conf.type = "perc", kernel = "gaussian", adjust = 1,
  which = "all", theme = theme_bw(), confStyle = list(color =
  "#56B4E9", alpha = 0.4), estLineStyle = list(color = "black", width =
  rel(1), alpha = 1, linetype = "dashed"), densityStyle = list(color =
  "black", width = rel(0.5), alpha = 1, linetype = "solid"), ...)
}
\arguments{
\item{x}{the object returned by a call to the \code{\link{bootcoefs}} function.}

\item{y}{ignored.}

\item{conf.level}{the level of the confidence interval that is plotted as shaded region under the
density estimate.}

\item{conf.type}{the confidence interval type, see \code{\link[boot]{boot.ci}} for details.}

\item{kernel}{the kernel used for density estimation, see \code{\link[stats]{density}} for details.}

\item{adjust}{see \code{\link[stats]{density}} for details.}

\item{which}{which parameters to plot}

\item{theme}{the ggplot2 theme to use for the plot.}

\item{confStyle}{a list with style parameters for the confidence region below the density estimate (possible entries
are \code{color}, and \code{alpha})}

\item{estLineStyle}{a list with style parameters for the line at the original parameter estimate (possible entries
are \code{color}, \code{width}, \code{alpha}, and \code{linetype})}

\item{densityStyle}{a list with style parameters for the line of the density estimate (possible entries
are \code{color}, \code{width}, \code{alpha}, and \code{linetype})}

\item{...}{ignored}
}
\description{
Plot the distribution of the bootstrap estimates and the confidence intervals for the estimates
}
\examples{
data <- data.frame(lifeExp = state.x77[, "Life Exp"], USArrests[ , -3])
mUSArr <- complmrob(lifeExp ~ ., data = data)
bc <- bootcoefs(mUSArr, R = 200) # this can take some time
plot(bc) # for the model diagnostic plots
}
\seealso{
\code{\link[=confint.bccomplmrob]{confint}} to get the numerical values for the confidence intervals
}
