% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ops-extract.R
\name{OpsExtract}
\alias{OpsExtract}
\alias{[.Container}
\alias{[[.Container}
\title{Extract Parts of a Container Object}
\usage{
\method{[}{Container}(x, ...)

\method{[[}{Container}(x, i)
}
\arguments{
\item{x}{\code{Container} object from which to extract elements.}

\item{i, ...}{indices specifying elements to extract. Indices
are \code{numeric} or \code{character} vectors or a \code{list} containing both.}
}
\description{
Extract parts of a \code{Container} object similar
to R's base extract operators on lists.
}
\details{
\code{[} selects multiple values. The indices can be \code{numeric} or
\code{character} or both. They can be passed as a \code{vector} or \code{list} or,
for convenience, just as a comma-separated sequence (see Examples).
Non-existing indices are ignored.

\code{[[} selects a single value using a \code{numeric} or \code{character} index.
}
\examples{
co = container(a = 1, b = 2, c = 3, d = 4)
co[1:2]
co[1, 4]
co["d", 2]
co[list("d", 2)]
co[0:10]

co = container(a = 1, b = 2)
co[[1]]
co[["a"]]
co[["x"]]
}
