% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TransferFunction.R
\name{TF}
\alias{TF}
\title{Evaluate Transfer function Expressions}
\usage{
TF(str_expr)
}
\arguments{
\item{str_expr}{String expression containing the transfer function}
}
\value{
Returns an object of 'tf' class list with a transfer function. Numerator and denominator
coefficients could then be retrieved from the object the same way as any other \code{tf} object
}
\description{
\code{TF} Evaluates a given transfer function expression in the s-domain
}
\details{
\code{TF} Evaluates a given transfer function polynomial expression in the s-domain.
The evaluation of the expressions are performed similar to symbolic math computations for polynomials.
A transfer function model is created as the result of the expression evaluation.
Thus, this is an alternative way of creating transfer function models following the natural math expressions
found in block diagrams. It also provides an alternative way to perform system interconnections. Only transfer
function models are currently supported for system interconnection using this function. System interconnections
for other models could be performed using the \code{series}, \code{parallel}, \code{feedback} or \code{connect} functions.
See the Examples section for further details.
}
\examples{

# Example taken from the GitHub page of Julia Control - an electric motor example
J <- 2.0
b <- 0.04
K <- 1.0
R <- 0.08
L <- 1e-4
P <- TF("K/(s*((J*s + b)*(L*s + R) + K^2))")
Cls <- TF("P/(1 + P)") # closed-loop connection

# More examples
TF("s+1")
sys1 <- tf(1, c(1, 2, 5))
sys2 <- tf(2, c(1, 2, 5))
TF("sys1 + sys2") # parallel system interconnection
TF("sys1 * sys2") # series system interconnection
TF("sys1 - sys2")
TF("sys1 - 1")
TF("sys1 + 1")
TF("sys1 - sys2 + sys2")
TF("sys1 / sys2 / sys2")

}
\seealso{
\code{\link{tf}} \code{\link{tf2ss}} \code{\link{series}} \code{\link{parallel}}
}
