% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c2d.R
\name{c2d}
\alias{c2d}
\title{Continuous Time model conversion to Discrete Time model.}
\usage{
c2d(sys, t)
}
\arguments{
\item{sys}{An object of transfer function, state-space or zero-pole class}

\item{t}{Sample time; a numeric value greater than 0}
}
\value{
Returns the provided system (transfer function, state-space or zero-pole) in an equivalent discrete-time.
}
\description{
\code{c2d} converts a system in continuous-time model to a discrete time model
}
\details{
\code{c2d} converts the continuous-time system: x = Ax + Bu
to the discrete-time state-space system: x[n+1] = Phi * x[n] + Gamma * u[n] based on the method
of assuming a zero-order hold on the inputs and sample time
Transfer function and zero-pole systems are converted to state-space representation before
conversion to discrete-time.
}
\examples{

## for TF
c2d(tf(c(1,-1), c(1,4,5)), 0.1)
## for ZPK
sys <- zpkdata( tf(c(1,-1), c(1,4,5)) )
c2d(sys, 0.1)
c2d(zpkdata( tf(c(1,-1), c(1,4,5)) ), 0.1)

}
\seealso{
\code{\link{ltitr}}
}
