% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feedback.R
\name{feedback}
\alias{feedback}
\alias{fdbcksys}
\title{Feedback Connection of LTI systems}
\usage{
feedback(sys1, sys2, in1, out1)
}
\arguments{
\item{sys1}{LTI system model of transfer-function or state-space model}

\item{sys2}{LTI system model of transfer-function or state-space model}

\item{in1}{vector of inputs}

\item{out1}{vector of outputs}
}
\value{
Returns the feedback system in \code{tf} or \code{ss} model
}
\description{
\code{feedback} forms a feedback connection for two LTI state-space or transfer function systems
}
\details{
When \code{sys1} and \code{sys2} are transfer functions \code{feedback(sys1, sys2, SIGN)} produces the SISO
closed loop system in transfer function form obtained by
connecting the two SISO transfer function systems in feedback
with the sign SIGN.

\code{feedback(sys1, sys2, SIGN)} produces an
aggregate state-space system consisting of the feedback connection
of the two systems 1 and 2.    If \code{SIGN = 1} then positive feedback is
used. If \code{SIGN = -1} then negative feedback is used.  In all cases,
the resulting system has the same inputs and outputs as system 1.

\code{feedback(sys1, sys2, inputs, outputs)}
produces the feedback system formed by feeding all the outputs of
system2 into the inputs of system 1 specified by INPUTS1 and by
feeding the outputs of system 2 specified by OUTPUTS1 into all the
inputs of system 2.  Positive feedback is assumed.  To connect
with negative feedback, use negative values in the vector INPUTS1.

\code{feedback()} calls \code{fdbcksys()} to perform the feedback connection for two systems.
Unity feedback calls are possile, for example, \code{feedback(sys1, 1)}, \code{feedback(1, sys1)}
}
\examples{
C <- pid(350,300,50)
P <- TF(" 1/(s^2 + 10* s + 20)")
feedback(C,P)
feedback(P,P,1)
feedback(P,P,-1)
feedback(P,P)
feedback(P,1)
feedback(TF("C*P"))
\dontrun{ On Octave: feedback(C*P)}

}
\seealso{
\code{\link{cloop}} \code{\link{parallel}} \code{\link{series}}
}
