% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertId2.R
\name{convertId2}
\alias{convertId2}
\title{Convert Gene Symbols to Ensembl Gene IDs or vice versa}
\usage{
convertId2(id, species = c("Human", "Mouse"))
}
\arguments{
\item{id}{(\code{character}). Vector of gene symbols.}

\item{species}{(\code{character}). One of "Human" and "Mouse". Defaults to "Human".}
}
\value{
A named character vector where the input IDs are the names and the query results the values.
}
\description{
\command{convertId2} uses the Bimap interface in AnnotationDbi to extract information from
    annotation packages. The function is limited to Human and Mouse annotations and is provided only as
    fallback mechanism for the most common use cases in data analysis. Please use the Biomart interface
    function \code{convert.bm()} for more flexibility.
}
\examples{
convertId2("ENSG00000111199")
convertId2("TRPV4")
}
\seealso{
\code{\link[AnnotationDbi]{Bimap-envirAPI}}
}
