% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_document_extractor.R
\name{run_document_extractor}
\alias{run_document_extractor}
\title{Launch Shiny app for retrieval of documents from text collection}
\usage{
run_document_extractor(corpus_object, max_html_docs = 400, ...)
}
\arguments{
\item{corpus_object}{A \code{corporaexplorer} object created by
\code{\link[corporaexplorer]{prepare_data}}.}

\item{max_html_docs}{The maximum number of documents allowed in one HTML report.}

\item{...}{Other arguments passed to \code{\link[shiny]{runApp}} in the Shiny
package.}
}
\description{
Shiny app for simple retrieval/extraction of
documents from a "corporaexplorerobject" in a reading-friendly format.
Interrupt R to stop the application (usually by pressing Ctrl+C or Esc).
}
\examples{
# Constructing test data frame:
dates <- as.Date(paste(2011:2020, 1:10, 21:30, sep = "-"))
texts <- paste0(
  "This is a document about ", month.name[1:10], ". ",
  "This is not a document about ", rev(month.name[1:10]), "."
)
titles <- paste("Text", 1:10)
test_df <- tibble::tibble(Date = dates, Text = texts, Title = titles)

# Converting to corporaexplorer object:
corpus <- prepare_data(test_df, corpus_name = "Test corpus")
if(interactive()){
# Running exploration app:
explore(corpus)

# Running app to extract documents:
run_document_extractor(corpus)
}
}
