% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{individual_probability}
\alias{individual_probability}
\title{Calculate a time series of probability for an individual following exposure}
\usage{
individual_probability(test_day, pre0, sens, spec, asympt, days, mu, sigma)
}
\arguments{
\item{test_day}{Day of PCR test (days since exposure)}

\item{pre0}{Pre-test probability of person on day of exposure}

\item{sens}{A vector of sensitivities by day since exposure}

\item{spec}{The specificity of the PCR test}

\item{asympt}{The proportion of infected patients expected to remain
asymptomatic throughout the course of infection}

\item{days}{Days since exposure for calculation range}

\item{mu}{The mean of a lognormal distribution that approximates the
incubation period for COVID-19. E.g. 1.63 (see reference).}

\item{sigma}{The standard deviation of a lognormal distribution that
approximates the incubation period for COVID-19. E.g. 0.5
(see reference).}
}
\value{
A time series of probabilities
}
\description{
The probability that an individual has COVID-19 will change over time as new
information is gleaned. The initial probability is the pretest probability
(pre0) associated with the nature of the interaction/exposure. This
probability will decrease with each passing day that the individual does not
develop symptoms. When a test is done, the probability is the posttest
probability; this reduces the probability based on the test characteristics
at the time of testing. Subsequently, the probability will continue to
decrease with each passing day that no symptoms develop. This function
returns a time series including those 3 phases.
}
