% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/JHU.R
\name{JHU}
\alias{JHU}
\title{R6 Class containing specific attributes and methods for John Hopkins
University data}
\source{
\url{https://github.com/CSSEGISandData/COVID-19/tree/master/csse_covid_19_data}
}
\description{
Attributes and methods for COVID-19 data used for the 2019
Novel Coronavirus Visual Dashboard operated by the Johns Hopkins University
Center for Systems Science and Engineering (JHU CSSE). Supported by ESRI
Living Atlas Team and the Johns Hopkins University Applied Physics Lab
(JHU APL)
}
\details{
This dataset support both national and subnational data sources
with national level data returned by default. Subnational data is supported
for a subset of countries which can be found after cleaning using the
\code{available_regions()} method, see the examples for more details. These data
sets are sourced, cleaned, standardised by the JHU team so please see the
source repository for further details. Note that unlike many other data sets
this means methods applied to this source are not being applied to raw
surveillance data but instead to already cleaned data. If using for
analysis checking the JHU source for further details is advisable.

If using this data please cite:
"Dong E, Du H, Gardner L. An interactive web-based dashboard to track
COVID-19 in real time.
Lancet Inf Dis. 20(5):533-534. doi: 10.1016/S1473-3099(20)30120-1"
}
\examples{
# nolint start
\dontrun{
# set up a data cache
start_using_memoise()

# get all countries data
jhu <- JHU$new(level = "1", get = TRUE)
jhu$return()

# show available regions with data at the second level of interest
jhu_level_2 <- JHU$new(level = "2")
jhu_level_2$download()
jhu_level_2$clean()
jhu$available_regions()

# get all region data for the uk
jhu_level_2$filter("uk")
jhu_level_2$process()
jhu_level_2$return()
}
# nolint end
}
\seealso{
Aggregated data sources
\code{\link{Covid19DataHub}},
\code{\link{Google}}

National data sources
\code{\link{Covid19DataHub}},
\code{\link{ECDC}},
\code{\link{Google}},
\code{\link{JRC}},
\code{\link{WHO}}

Subnational data sources
\code{\link{Belgium}},
\code{\link{Brazil}},
\code{\link{Canada}},
\code{\link{Colombia}},
\code{\link{Covid19DataHub}},
\code{\link{Cuba}},
\code{\link{Estonia}},
\code{\link{France}},
\code{\link{Germany}},
\code{\link{Google}},
\code{\link{India}},
\code{\link{Italy}},
\code{\link{Lithuania}},
\code{\link{Mexico}},
\code{\link{Netherlands}},
\code{\link{SouthAfrica}},
\code{\link{Switzerland}},
\code{\link{UK}},
\code{\link{USA}}
}
\concept{aggregations}
\concept{dataset}
\concept{national}
\concept{subnational}
\section{Super classes}{
\code{\link[covidregionaldata:DataClass]{covidregionaldata::DataClass}} -> \code{\link[covidregionaldata:CountryDataClass]{covidregionaldata::CountryDataClass}} -> \code{JHU}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{origin}}{name of country to fetch data for}

\item{\code{supported_levels}}{A list of supported levels.}

\item{\code{supported_region_names}}{A list of region names in order of level.}

\item{\code{supported_region_codes}}{A list of region codes in order of level.}

\item{\code{common_data_urls}}{List of named links to raw data. The first, and
only entry, is be named main.}

\item{\code{source_data_cols}}{existing columns within the raw data}

\item{\code{source_text}}{Plain text description of the source of the data}

\item{\code{source_url}}{Website address for explanation/introduction of the
data}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-set_region_codes}{\code{JHU$set_region_codes()}}
\item \href{#method-clean_common}{\code{JHU$clean_common()}}
\item \href{#method-clean_level_1}{\code{JHU$clean_level_1()}}
\item \href{#method-clone}{\code{JHU$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="available_regions">}\href{../../covidregionaldata/html/DataClass.html#method-available_regions}{\code{covidregionaldata::DataClass$available_regions()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="clean">}\href{../../covidregionaldata/html/DataClass.html#method-clean}{\code{covidregionaldata::DataClass$clean()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="download">}\href{../../covidregionaldata/html/DataClass.html#method-download}{\code{covidregionaldata::DataClass$download()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="download_JSON">}\href{../../covidregionaldata/html/DataClass.html#method-download_JSON}{\code{covidregionaldata::DataClass$download_JSON()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="get">}\href{../../covidregionaldata/html/DataClass.html#method-get}{\code{covidregionaldata::DataClass$get()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="initialize">}\href{../../covidregionaldata/html/DataClass.html#method-initialize}{\code{covidregionaldata::DataClass$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="process">}\href{../../covidregionaldata/html/DataClass.html#method-process}{\code{covidregionaldata::DataClass$process()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="return">}\href{../../covidregionaldata/html/DataClass.html#method-return}{\code{covidregionaldata::DataClass$return()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="summary">}\href{../../covidregionaldata/html/DataClass.html#method-summary}{\code{covidregionaldata::DataClass$summary()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="DataClass" data-id="test">}\href{../../covidregionaldata/html/DataClass.html#method-test}{\code{covidregionaldata::DataClass$test()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="covidregionaldata" data-topic="CountryDataClass" data-id="filter">}\href{../../covidregionaldata/html/CountryDataClass.html#method-filter}{\code{covidregionaldata::CountryDataClass$filter()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_region_codes"></a>}}
\if{latex}{\out{\hypertarget{method-set_region_codes}{}}}
\subsection{Method \code{set_region_codes()}}{
Set up a table of region codes for clean data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JHU$set_region_codes()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clean_common"></a>}}
\if{latex}{\out{\hypertarget{method-clean_common}{}}}
\subsection{Method \code{clean_common()}}{
JHU specific data cleaning. Joins the raw data sets, checks
column types and renames where needed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JHU$clean_common()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clean_level_1"></a>}}
\if{latex}{\out{\hypertarget{method-clean_level_1}{}}}
\subsection{Method \code{clean_level_1()}}{
JHU specific country level data cleaning. Aggregates the
data to the country (level 2) level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JHU$clean_level_1()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{JHU$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
