% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CowbellAnalyzer.R
\name{predict.cowbell}
\alias{predict.cowbell}
\title{Performs a prediction on the cowbell model that has been generated.}
\usage{
\method{predict}{cowbell}(object, newdata, ...)
}
\arguments{
\item{object}{The data obtained by function \code{\link{generateCowbell}}.}

\item{newdata}{The data set to perform the prediction on. If omitted the original data is used.}

\item{...}{Just for compatibility purposes.}
}
\value{
The vector with the predicted data.
}
\description{
Implementation of the \code{\link{predict}} generic. The provided data has to have the exact column names
 that were used when the cowbell analysis was done. If no data is provided the original data is used.
}
\examples{
# Run a simplified anaylsis with 10 iterations only (to save time.)
concept<-generateCowbellConcept(Fun ~ Fluency * Absorption, 1, 9, 1, 7, 1, 7)
data(allFun)
test<-generateCowbell(concept, allFun, 10)
predict(test)
}
