% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{refine_ordinate}
\alias{refine_ordinate}
\alias{coarsen_ordinate}
\alias{hat_ordinate}
\alias{insertion_matrix}
\title{Knot Insertion, Removal, and Reinsertion}
\usage{
refine_ordinate(x, xi, theta, order = 4L)

coarsen_ordinate(x, xi, theta, order = 4L)

hat_ordinate(x, xi, theta, order = 4L)

insertion_matrix(x, xi, order = 4L)
}
\arguments{
\item{x}{the value of the knot to be inserted into the knot vector}

\item{xi}{the (whole) knot vector, including the repeated boundary knots.
Regardless of refinement or coarsening, this vector should be the
'reduced' vector such that x will be added to it.  See details and
examples.}

\item{theta}{the ordinates of the control polygon vertices}

\item{order}{the order of the B-spline, defaults to 4 for cubic splines}
}
\value{
numeric vectors
}
\description{
Functions for the insertion, removal, and reinsertion of internal knots for
B-splines.
}
\examples{
\dontrun{
# See the vignette
vignette("cpr-pkg", package = "cpr")
}

}
\author{
Peter DeWitt \email{dewittpe@gmail.com}
}
