% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cps_load_basic.R
\name{cps_load_basic}
\alias{cps_load_basic}
\title{load some basic/default CPS data into the environment}
\usage{
cps_load_basic(years = seq(1994, 2018, 2), datadir = "cps_data", outdir = NULL)
}
\arguments{
\item{years}{Which years should be read}

\item{datadir}{The location where the CPS zip files live (or should be
downloaded to)}

\item{outdir}{The location where the final data file should be saved to}
}
\description{
This function is a quick starter to working with the CPS, using all of the
defaults that are baked into this package. Because the data is so large, it
made more sense to ship a "basic" CPS data set as a function rather than as a
package data object (which would have been over 10 MB). This function will
take you from nothing to having some basic CPS data in your environment, with
the option to save this data locally for future ease. A sample of the data
that comes out of this function is provided as \code{cpsvote::cps_allyears_10k}.
}
\examples{
\dontrun{cps_load-basic(years = 2016, outdir = "data")}

}
