% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_relation.R
\name{sch_evaluate_redundancy}
\alias{sch_evaluate_redundancy}
\title{Evaluate Redundancy}
\usage{
sch_evaluate_redundancy(sch)
}
\arguments{
\item{sch}{Object Schedule}
}
\value{
Object Schedule redundancy column added. Or the Schedule without any
modification, is trere is no relation in it.
}
\description{
Evaluates redundancy of each relation and creates another column in
relation tibble. If the schedule does not have any relation, this function do
nothing.
}
\examples{
atb <- tibble::tibble(
  id        = 1:17,
  name      = paste("a", as.character(1:17), sep=""),
  duration  = c(1L,2L,2L,4L,3L,3L,3L,2L,1L,1L,2L,1L,1L,1L,1L,2L,1L)
)
rtb <- data.frame(
  from = c(1L, 1L, 2L, 2L, 2L, 3L, 3L, 3L,  3L,  4L,  5L,  6L,
           7L,  8L,  9L, 10L, 11L, 11L, 12L, 12L, 13L, 13L, 14L, 14L, 15L, 15L),
  to   = c(2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 11L, 11L,
           12L, 13L, 14L, 15L, 16L, 17L, 16L, 17L, 16L, 17L, 16L, 17L, 16L, 17L)
)
sch <- sch_new() \%>\%
  sch_title("Project 1: Cost Information System") \%>\%
  sch_reference("VANHOUCKE, Mario.
      Integrated project management and control:
      first comes the theory, then the practice.
      Gent: Springer, 2014, p. 6") \%>\%
  sch_add_activities_tibble(atb) \%>\%
  sch_add_relations_tibble(rtb) \%>\%
  sch_plan() \%>\%
  sch_evaluate_redundancy()

sch_duration(sch)  # 11L

rtb <- sch_relations(sch)
sum(rtb$redundant) # 0

sch1 <- sch \%>\%
  sch_add_relation(1L, 6L) \%>\%
  sch_add_relation(3L, 16L) \%>\%
  sch_add_relation(4L, 17L) \%>\%
  sch_plan() \%>\%
  sch_evaluate_redundancy()

sch_duration(sch)  # 11L

rtb <- sch_relations(sch1)
sum(rtb$redundant) # 3L

}
