% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reciprocal_space.R
\name{load_anomalous_data}
\alias{load_anomalous_data}
\title{Load anomalous data for a specific chemical element}
\usage{
load_anomalous_data(chem_el)
}
\arguments{
\item{chem_el}{1- or 2-letters character string. The chemical symbol of
interest.}
}
\value{
A dataframe with 3 columns, the specific wavelength in angstroms
   (lambda), f' (f1) and f'' (f2).
}
\description{
Returns a dataframe with f' and f'' at various wavelengths
for the specific chemical element.
}
\examples{
# Load anomalous data for Fe
ano_Fe <- load_anomalous_data("Fe")
print(ano_Fe[1:10,])
}
