% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossnma.model.R
\name{crossnma.model}
\alias{crossnma.model}
\title{Create JAGS model and data to perform cross network meta-analysis
or meta-regression}
\usage{
crossnma.model(
  trt,
  study,
  outcome,
  n,
  design,
  cov1 = NULL,
  cov2 = NULL,
  cov3 = NULL,
  bias = NULL,
  unfav = NULL,
  bias.covariate = NULL,
  bias.group = NULL,
  prt.data = NULL,
  std.data = NULL,
  reference = NULL,
  trt.effect = "random",
  cov1.ref = NULL,
  cov2.ref = NULL,
  cov3.ref = NULL,
  reg0.effect = "independent",
  regb.effect = "random",
  regw.effect = "random",
  split.regcoef = TRUE,
  method.bias = NULL,
  bias.type = NULL,
  bias.effect = "common",
  down.wgt = NULL,
  prior = list(tau.trt = NULL, tau.reg0 = NULL, tau.regb = NULL, tau.regw = NULL,
    tau.gamma = NULL, pi.high.rct = NULL, pi.low.rct = NULL, pi.high.nrs = NULL,
    pi.low.nrs = NULL),
  run.nrs = list(var.infl = 1, mean.shift = 0, trt.effect = "common", n.adapt = 2000,
    n.iter = 10000, n.burnin = 4000, thin = 1, n.chains = 2),
  quiet = TRUE
)
}
\arguments{
\item{trt}{Treatment variable in prt.data and std.data.}

\item{study}{Study variable in prt.data and std.data.}

\item{outcome}{Outcome variable in prt.data and std.data.}

\item{n}{Number of participants in std.data.}

\item{design}{Design variable in prt.data and std.data.}

\item{cov1}{Optional first covariate in prt.data and std.data to
conduct network meta-regression (see Details).}

\item{cov2}{Optional second covariate in prt.data and std.data to
conduct network meta-regression (see Details).}

\item{cov3}{Optional third covariate in prt.data and std.data to
conduct network meta-regression (see Details).}

\item{bias}{Variable with information on risk of bias in prt.data
and std.data (can be provided when method.bias = 'adjust1' or
'adjust2'). Possible values of this variable are 'low', 'high' or
'unclear' (can be abbreviated). These values must be identical
for all participants from the same study.}

\item{unfav}{Variable in prt.data and std.data indicating the
unfavored treatment in each study (can be provided when
method.bias = 'adjust1' or 'adjust2'). The entries of this
variable are either 0 (unfavored treatment) or 1 (favorable
treatment or treatments). Each study should include only one 0
entry. The values need to be repeated for participants who take
the same treatment.}

\item{bias.covariate}{Variable in prt.data and std.data used to
estimate the probability of bias (can be provided when
method.bias = 'adjust1' or 'adjust2').}

\item{bias.group}{An optional variable in prt.data and std.data
that indicates the bias effect in each study (can be provided
when method.bias = 'adjust1' or 'adjust2'). The entries of these
variables should be either 1 (study has inactive treatment and
its estimate should be adjusted for bias effect), 2 (study has
only active treatments and its estimate should be adjusted for
bias effect (different from inactive bias effect) or 0 (study
does not need any bias adjustment). The values need to be
repeated for the participants assigned to the same
treatment. Default is 1.}

\item{prt.data}{An object of class data.frame containing the
individual participant dataset. Each row contains the data of a
single participant.  The dataset needs to have the following
columns: treatment, study identification, outcome (event and
non-event), design. Additional columns might be required for
certain analyses.}

\item{std.data}{An object of class data.frame containing the
study-level dataset. Each row represents the information of study
arm.  The dataset needs to have the following columns: treatment,
study identification, outcome (number of events), sample size and
design. Additional columns might be required for certain
analyses.}

\item{reference}{A character indicating the name of the reference
treatment. When the reference is not specified, the first
alphabetic treatment will be used as a reference in the analysis.}

\item{trt.effect}{A character defining the model for the
study-specific treatment effects. Options are 'random' (default)
or 'common'.}

\item{cov1.ref}{An optional value to center the first covariate
which is only useful for a continuous covariate. Dichotomous
covariates should be given NA value. The default is the overall
minimum covariate value from all studies.}

\item{cov2.ref}{An optional value to center the second covariate
which is only useful for a continuous covariate. Dichotomous
covariates should be given NA value. The default is the overall
minimum covariate value from all studies.}

\item{cov3.ref}{An optional value to center the third covariate
which is only useful for a continuous covariate. Dichotomous
covariates should be given NA value. The default is the overall
minimum covariate value from all studies.}

\item{reg0.effect}{An optional character (needed when at least
\code{cov1} is not NULL) indicating the relationship across
studies for the prognostic effects expressed by the regression
coefficient, (\eqn{\beta_0}), in a study \eqn{j}.  Options are
'independent' or 'random'. We recommend using 'independent'
(default).}

\item{regb.effect}{An optional character (needed when at least
\code{cov1} is not NULL) indicating the relationship across
treatments for the between-study regression coefficient
(\eqn{\beta^B}). This parameter quantifies the treatment-mean
covariate interaction.  Options are 'independent', 'random' or
'common'. Default is 'random'.}

\item{regw.effect}{An optional character (needed when at least
\code{cov1} is not NULL) indicating the relationship across
treatments for the within-study regression coefficient
(\eqn{\beta^W}). This parameter quantifies the
treatment-covariate interaction effect at the individual level.
Options are 'independent', 'random' and 'common'. Default is
'random'.}

\item{split.regcoef}{A logical value (needed when at least
\code{cov1} is not NULL). If TRUE (default) the within- and
between-study coefficients will be splitted in the analysis of
prt.data.  When the split.regcoef = FALSE, only a single
regression coefficient will be estimated to represent both the
between-studies and within-studies covariate effects.  In this
case, both arguments \code{regb.effect} and \code{regw.effect}
need to be given the same option to model the single regression
effect.}

\item{method.bias}{A character for defining the method to combine
randomized clinical trials (RCT) and non-randomized studies
(NRS).  Options are 'naive' for naive or unadjusted synthesize,
'prior' for using NRS evidence to construct priors for the
relative treatment effects in RCTs analysis, or 'adjust1' and
'adjust2' to allow a bias adjustment. When only one design is
available (either rct or nrs), this argument needs also to be
specified to indicate whether unadjusted (naive) or bias-adjusted
analysis (adjust1 or adjust2) should be applied.}

\item{bias.type}{An optional character defining of bias on the
treatment effect (required when method.bias='adjust1').  Three
options are possible: 'add' to add the additive bias
effect,'mult' for multiplicative bias effect and 'both' includes
both an additive and a multiplicative terms.}

\item{bias.effect}{An optional character indicating the
relationship for the bias coefficients across studies.  Options
are 'random' or 'common' (default). It is required when
method.bias='adjust1' or 'adjust2'.}

\item{down.wgt}{An optional numeric indicating the percent to which
studies at high risk of bias will be downweighed on average. The
value ranges between 0 and 1. It can be provided when
method.bias='adjust1' or 'adjust2'.}

\item{prior}{An optional list to control the prior for various
parameters in JAGS model. When effects are set as 'random', we
can set the heterogeneity parameters for: tau.trt for the
treatment effects, tau.reg0 for the effect of prognostic
covariates, tau.regb and tau.regw for within- and between-study
covariate effect, respectively.  and tau.gamma for bias
effect. The default of all heterogeneity parameters is
'dunif(0,2)'. Currently only the uniform distribution is
supported.  When the method.bias= 'adjust1' or 'adjust2', the
user may provide priors to control the bias probability.  For the
bias probabilities, beta distributions are assumed with the
following default values: RCT with low
(pi.low.rct='dbeta(1,10)'), high (pi.high.rct='dbeta(10,1)')
bias, NRS with low (pi.low.rct='dbeta(1,30)') / high
(pi.high.rct='dbeta(30,1)') bias (pi.low.nrs, pi.high.nrs).}

\item{run.nrs}{An optional list is needed when the NRS used as a
prior (method.bias='prior').  The list consists of the following:
(\code{var.infl}) controls the common inflation of the variance
of NRS estimates (\eqn{w}) and its values range between 0 (NRS
does not contribute at all and the prior is vague) and 1 (the NRS
evidence is used at face value, default approach).  The parameter
(\code{mean.shift}) is the bias shift (\eqn{\zeta}) to be
added/subtracted from the estimated mean treatment effects (on
the log-scale) from NRS network (0 is the default).
\code{trt.effect} is a character indicates how to combine
treatment effects across NRS studies .Options are 'random' or
'common' (default).  Here you can also specify the arguments to
control the MCMC chains with default value is in the parentheses:
the number of adaptions n.adapt (500), number of iterations
n.iter(10000), number of burn in n.burnin (4000), number of
thinning thin (1) and number of chains n.chains
(2). \code{\link[rjags]{jags.model}} from rjags package describes
these arguments.}

\item{quiet}{A logical passed on to
\code{\link[rjags]{jags.model}}.}
}
\value{
An object of class \code{crossnma.model} containing information on
the JAGS model, which is a list containing the following
components:

\item{model}{A long character string containing JAGS code that
  will be run in \code{\link[rjags]{jags.model}}.}
\item{data}{The data to be used to run JAGS model.}
\item{trt.key}{A table of the treatments and its mapped integer
  number (as used in JAGS model).}
\item{study.key}{A table of the studies and its mapped integer
  number (as used in JAGS model).}
\item{trt.effect}{A character defining the model for the
  study-specific treatment effects.}
\item{method.bias}{A character for defining the method to combine
  randomized clinical trials (RCT) and non-randomized studies
  (NRS).}
\item{covariate}{A vector of the the names of the covariates
  (\code{cov1, cov2 and cov3}) in prt.data and std.data used in
  network meta-regression.}
\item{cov.ref}{A vector of values of \code{cov1.ref, cov2.ref,
  cov3.ref} to center continuous covariates. Dichotomous covariates
  take NA.}
\item{dich.cov.labels}{A matrix with the levels of each dichotomous
  covariate and the corresponding assigned 0 / 1 values.}
\item{split.regcoef}{A logical value. If FALSE the within- and
  between-study regression coefficients will be considered equal.}
\item{regb.effect}{A character indicating the model for the
  between-study regression coefficients across studies.}
\item{regw.effect}{A character indicating the model for the
  within-study regression coefficients across studies.}
\item{bias.effect}{A character indicating the model for the bias
  coefficients across studies.}
\item{bias.type}{A character indicating the effect of bias on the
  treatment effect; additive ('add') or multiplicative ('mult') or
  both ('both').}
\item{all.data.ad}{A data.frame object with the prt.data (after it
  is aggregated) and std.data in a single dataset.}
\item{call}{Function call.}
\item{version}{Version of R package \bold{crossnma} used to create
  object.}
}
\description{
This function creates a JAGS model and the needed data for
cross-design and cross-format network meta-analysis or
meta-regression of a binary outcome with the odds ratio as effect
measure.
}
\details{
This function creates a JAGS model and the needed data. The JAGS
code is created from the internal function \code{crossnma.code}.

Covariates provided in arguments \code{cov1}, \code{cov2} and
\code{cov3} can be either numeric or dichotomous (should be
provided as factor or character) variables. By default, no
covariate adjustment is applied (network meta-analysis).
}
\examples{
# We conduct a network meta-analysis assuming a random-effects
# model.
# The data comes from randomized-controlled trials and
# non-randomized studies (combined naively)
head(ipddata) # participant-level data
head(stddata) # study-level data

# Create a JAGS model
mod <- crossnma.model(treat, id, relapse, n, design,
  prt.data = ipddata, std.data = stddata,
  reference = "A", trt.effect = "random", method.bias = "naive")

# Fit JAGS model
# (suppress warning 'Adaptation incomplete' due to n.adapt = 20)
fit <-
  suppressWarnings(crossnma(mod, n.adapt = 20,
    n.iter = 50, thin = 1, n.chains = 3))

# Display the output
summary(fit)
plot(fit)

}
\seealso{
\code{\link{crossnma}}, \code{\link[rjags]{jags.model}}
}
\author{
Tasnim Hamza \email{tasnim.hamza@ispm.unibe.ch}, Guido
  Schwarzer \email{sc@imbi.uni-freiburg.de}
}
