% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeFilteredImList.R
\name{makeFilteredImList}
\alias{makeFilteredImList}
\title{Make filtered im list from phase 3 im list}
\usage{
makeFilteredImList(D, Q, rm, til, filter.thresh)
}
\arguments{
\item{D}{binary matrix of events by samples}

\item{Q}{penalty matrix of events by samples}

\item{rm}{matrix of rules ordered by phase one}

\item{til}{im list from phase 3}

\item{filter.thresh}{minimum percentage of samples assigned to each rule in rs}
}
\value{
filtered top im list
}
\description{
Make filtered im list from phase 3 im list
}
\examples{
library(crso)
data(skcm)
list2env(skcm.list,envir=globalenv())
Q <- log10(P)
rm.full <- buildRuleLibrary(D,rule.thresh = 0.05) # Rule library matrix, dimension: 60 x 71
til.p2 <- makePhaseTwoImList(D,Q,rm.full,k.max = 3,
          pool.sizes=c(60,20,20),max.stored=100,shouldPrint = FALSE)
filtered.im.list <- makeFilteredImList(D,Q,rm.full,til.p2,filter.thresh = 0.05)
}
