% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube-result.R
\name{margin-translation}
\alias{margin-translation}
\alias{user2realMargin}
\alias{real2userMargin}
\title{Convert from user margins to real cube margins or vice versa}
\usage{
user2realMargin(margin, dimTypes = getDimTypes(cube), cube)

real2userMargin(margin, dimTypes = getDimTypes(cube), cube, dedupe = TRUE)
}
\arguments{
\item{margin}{the margin or margins for the user cube to be translated}

\item{dimTypes}{dimension types from \code{getDimTypes()} (by default:
\code{getDimTypes(cube)})}

\item{cube}{the cube to translate the margin for (optional if \code{dimTypes} is
explicitly supplied)}

\item{dedupe}{logical, should the user dimensions in the result be
deduplicated (for \code{real2userMargin} only)}
}
\value{
margin or margins in the higher-dimension real cube
}
\description{
It is helpful to programmatically move from user-specified margins to real
cube margins that apply to the higher-dimensional real cube (with
\code{user2realMargin}). Or to move from the higher-dimensional real cube to user cube
(with \code{real2userMargin}).
}
\keyword{internal}
