% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7-Path.R
\name{path_ray}
\alias{path_ray}
\title{Ray Path}
\usage{
path_ray(start, end, lim = c(64, 128), n = 200)
}
\arguments{
\item{start}{start \code{(row, col)} coordinate of the ray}

\item{end}{either an ending coording, an angle in radians, or a character direction (u, d, l, r, ul, ur, dl, dr)}

\item{lim}{bounding box dimensions used to calculate ray}

\item{n}{number of points along curve to calculate}
}
\value{
Nx2 matrix of \code{(row, column)} coordinates
}
\description{
Calculate the path of a ray extending
}
\examples{
path_ray(start=c(10,10), end=pi/6)
path_ray(start=c(10,10), end=pi/6, lim=c(15,15))
path_ray(start=c(10,10), end=c(4,2))

}
\seealso{
Other path-fitting functions: 
\code{\link{path_arc}()},
\code{\link{path_bezier}()},
\code{\link{path_circle}()},
\code{\link{path_ellipse}()},
\code{\link{path_fill}()},
\code{\link{path_fn}()},
\code{\link{path_intersection}()},
\code{\link{path_lerp}()},
\code{\link{path_rect}()},
\code{\link{path_shape}()}
}
\concept{path-fitting functions}
