% Generated by roxygen2 (4.0.0): do not edit by hand
\name{cutoff}
\alias{cutoff}
\title{The CUTOFF Spatio-temporal Imputation Method}
\usage{
cutoff(data, N = 4, cutoff = 0.75, P = 5, M = floor(P/2), Adj = 1,
  space.weight = FALSE, method = c("correlation", "number", "penalty"),
  time.opts = c("average", "adjacent"), kernel = FALSE, kerFUN = NULL,
  lambda = NULL, corr = "pearson", keep.ID = FALSE, ...)
}
\arguments{
\item{data}{a matrix or data frame with missing values}

\item{N}{a number indicating the number used for the "CUTOFF by number" method}

\item{cutoff}{a number indicating the cutoff value used fot he "CUTOFF by correlation" method}

\item{P}{a number for the "penalty" imputation option for CUTOFF. That is, for those candidate missing
station with too many reference stations, we can penalise and fix the number of reference stations to P}

\item{M}{a number used for the "relaxation" imputation option for CUTOFF. That is, for those cadidate
missing station with too few reference stations, we can relax and add its number of reference stations to M}

\item{Adj}{a number used for the "adjacent" method in CUTOFF. That is, the missing value's adjacent points in time
is also used for imputation. The default values is 1. 2 is also avaialbe. Any number bigger than 2 has not been implemented
yet. This options is useful when the length of the time series is short so may be more temporal information can be useful
to improve the imputation performance.}

\item{space.weight}{a logical value. If true, then space weighting strategy is carried out. The default is FALSE.}

\item{method}{the imputation method to be used. There are three options: "correlation", "number" and "penalty". Details
can be found in Feng et al.(2014).}

\item{time.opts}{options for the temporal dimension; either "average" or "adjacent" can be used. "average" refers to
simple averaging, "adjacent" refers to the "aajacent" method.}

\item{kernel}{logical, if TRUE then kernel smoothing can be used to smooth the averaging. Default is FALSE. If TURE, then kerFUN
has to be specified.}

\item{kerFUN}{the kernel function to be used for kernel smoothing. There are four kernel functions available in this package: Epank, UnifK
GaussK and CosK. User can define their own kernel function to pass to this function.}

\item{lambda}{a number indicating the bandwidth parameter value for kernel smoothing.}

\item{corr}{the type of correlation coefficient to be used for the "CUTOFF by correlation" method. Default is "pearson",
"spearman" and "kendall" are alternatives.}

\item{keep.ID}{if the reference ID for each missing stations need to be kept. If TRUE, relevant ID information can be retrieved after imputation.
Default is FALSE.}

\item{...}{other arguments that can passed}
}
\value{
If keep.ID = FALSE, then return the imputed data matrix with no
missing values. If keep.ID = TRUE, then return a list of two components:

\item{imputed}{The imputed data matrix with no missing values}
\item{ID}{The reference information during the imputation}
}
\description{
The CUTOFF Spatio-temporal Imputation Method
}
\details{
This function implements the CUTOFF spatio-temporal imputation
method that is described in Feng et al.(2014)
}
\examples{
data(hqmr.data)
# check the number of missing values
nmissing(hqmr.data[, -79])
# impute the data by the CUTOFF method
impdata <- cutoff(data = hqmr.data)
nmissing(impdata)
}
\references{
Lingbing Feng, Gen Nowak, Alan. H. Welsh and Terry. J. O'Neill
(2014): CUTOFF: A Spatio-temporal Imputation Method,
\emph{Journal of Hydrology}. (submitted)
}

