% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxnet.deviance.R
\name{coxnet.deviance}
\alias{coxnet.deviance}
\title{Compute deviance for Cox model}
\usage{
coxnet.deviance(pred = NULL, y, weights = NULL, std.weights = TRUE)
}
\arguments{
\item{pred}{Fit vector or matrix. If `NULL`, it is set to all ones.}

\item{y}{Survival response variable, must be a \code{Surv} or
\code{stratifySurv} object.}

\item{weights}{Observation weights (default is all equal to 1).}

\item{std.weights}{If TRUE (default), observation weights are standardized
to sum to 1.}
}
\value{
A vector of deviances, one for each column of predictions.
}
\description{
Compute the deviance (-2 log partial likelihood) for Cox model. This is a
pared down version of `glmnet`'s `coxnet.deviance` with one big difference:
here, `pred` is on the scale of `y` (`mu`) while in `glmnet`, `pred` is the
linear predictor (`eta`).
}
\details{
Computes the deviance for a single set of predictions, or for a matrix
of predictions. Uses the Breslow approach to ties.

\code{coxnet.deviance()} is a wrapper: it calls the appropriate internal
routine based on whether the response is right-censored data or
(start, stop] survival data.
}
\examples{
set.seed(1)
eta <- rnorm(10)
time <- runif(10, min = 1, max = 10)
d <- ifelse(rnorm(10) > 0, 1, 0)
y <- survival::Surv(time, d)
coxnet.deviance(pred = exp(eta), y = y)

# if pred not provided, it is set to ones vector
coxnet.deviance(y = y)

# example with (start, stop] data
y2 <- survival::Surv(time, time + runif(10), d)
coxnet.deviance(pred = exp(eta), y = y2)

}
