/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Fit;
import java.util.Date;

public class DateTime {
    public static final long MIN = 0x10000000L;
    public static final long INVALID = Fit.UINT32_INVALID;
    public static final long OFFSET = 631065600000L;
    private long timestamp;
    private double fractional_timestamp;

    public DateTime(long l) {
        this.timestamp = l;
        this.fractional_timestamp = 0.0;
    }

    public DateTime(Date date) {
        this.timestamp = (date.getTime() - 631065600000L) / 1000L;
        this.fractional_timestamp = (double)((date.getTime() - 631065600000L) % 1000L) / 1000.0;
    }

    public DateTime(DateTime dateTime) {
        this(dateTime.getTimestamp(), dateTime.getFractionalTimestamp());
    }

    public DateTime(long l, double d) {
        this.timestamp = l + (long)Math.floor(d);
        this.fractional_timestamp = d - Math.floor(d);
    }

    public boolean equals(DateTime dateTime) {
        return this.getTimestamp().equals(dateTime.getTimestamp()) && this.getFractionalTimestamp().equals(dateTime.getFractionalTimestamp());
    }

    public void convertSystemTimeToUTC(long l) {
        if (this.timestamp < 0x10000000L) {
            this.timestamp += l;
        }
    }

    public Double getFractionalTimestamp() {
        return new Double(this.fractional_timestamp);
    }

    public Long getTimestamp() {
        return new Long(this.timestamp);
    }

    public Date getDate() {
        long l = Math.round(this.fractional_timestamp * 1000.0);
        return new Date(this.timestamp * 1000L + l + 631065600000L);
    }

    public String toString() {
        return this.getDate().toString();
    }

    public void add(DateTime dateTime) {
        this.timestamp += dateTime.getTimestamp().longValue();
        this.fractional_timestamp += dateTime.getFractionalTimestamp().doubleValue();
        this.timestamp += (long)Math.floor(this.fractional_timestamp);
        this.fractional_timestamp -= (double)((float)Math.floor(this.fractional_timestamp));
    }

    public void add(long l) {
        this.add(new DateTime(l));
    }

    public void add(double d) {
        this.add(new DateTime(0L, d));
    }

    public int compareTo(DateTime dateTime) {
        if (this.timestamp == dateTime.getTimestamp()) {
            return Double.compare(this.fractional_timestamp, dateTime.getFractionalTimestamp());
        }
        if (this.timestamp > dateTime.getTimestamp()) {
            return 1;
        }
        return -1;
    }
}

