/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.FieldComponent;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.SubField;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class Field {
    protected String name;
    protected int num;
    protected int type;
    protected double scale;
    protected double offset;
    protected String units;
    protected boolean isAccumulated;
    protected ArrayList<Object> values;
    protected ArrayList<FieldComponent> components;
    protected ArrayList<SubField> subFields;
    protected static boolean forceShowInvalids = false;

    public Field(Field field) {
        if (field == null) {
            this.name = "unknown";
            this.num = 255;
            this.type = 0;
            this.scale = 1.0;
            this.offset = 0.0;
            this.units = "";
            this.isAccumulated = false;
            this.values = new ArrayList();
            this.components = new ArrayList();
            this.subFields = new ArrayList();
            return;
        }
        this.name = new String(field.name);
        this.num = field.num;
        this.type = field.type;
        this.scale = field.scale;
        this.offset = field.offset;
        this.units = new String(field.units);
        this.isAccumulated = field.isAccumulated;
        this.values = new ArrayList();
        for (Object object : field.values) {
            if (object instanceof Byte) {
                this.values.add(new Byte((Byte)object));
                continue;
            }
            if (object instanceof Short) {
                this.values.add(new Short((Short)object));
                continue;
            }
            if (object instanceof Integer) {
                this.values.add(new Integer((Integer)object));
                continue;
            }
            if (object instanceof Long) {
                this.values.add(new Long((Long)object));
                continue;
            }
            if (object instanceof Float) {
                this.values.add(new Float(((Float)object).floatValue()));
                continue;
            }
            if (object instanceof Double) {
                this.values.add(new Double((Double)object));
                continue;
            }
            if (!(object instanceof String)) continue;
            this.values.add(new String((String)object));
        }
        this.components = field.components;
        this.subFields = field.subFields;
    }

    protected Field(String string, int n, int n2, double d, double d2, String string2, boolean bl) {
        this.name = new String(string);
        this.num = n;
        this.type = n2;
        this.scale = d;
        this.offset = d2;
        this.units = new String(string2);
        this.isAccumulated = bl;
        this.values = new ArrayList();
        this.components = new ArrayList();
        this.subFields = new ArrayList();
    }

    public String getName() {
        return this.getNameInternal(null);
    }

    public String getName(int n) {
        return this.getNameInternal(this.getSubField(n));
    }

    public String getName(String string) {
        return this.getNameInternal(this.getSubField(string));
    }

    private String getNameInternal(SubField subField) {
        if (subField == null) {
            return this.name;
        }
        return subField.name;
    }

    public int getNum() {
        return this.num;
    }

    public int getType() {
        return this.getTypeInternal(null);
    }

    public int getType(int n) {
        return this.getTypeInternal(this.getSubField(n));
    }

    public int getType(String string) {
        return this.getTypeInternal(this.getSubField(string));
    }

    private int getTypeInternal(SubField subField) {
        if (subField == null) {
            return this.type;
        }
        return subField.type;
    }

    public String getUnits() {
        return this.getUnitsInternal(null);
    }

    public String getUnits(int n) {
        return this.getUnitsInternal(this.getSubField(n));
    }

    public String getUnits(String string) {
        return this.getUnitsInternal(this.getSubField(string));
    }

    private String getUnitsInternal(SubField subField) {
        if (subField == null) {
            return this.units;
        }
        return subField.units;
    }

    public boolean getIsAccumulated() {
        return this.isAccumulated;
    }

    protected int getSize() {
        int n = 0;
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 10: 
            case 13: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 136: 
            case 137: 
            case 139: 
            case 140: {
                n = this.getNumValues() * Fit.baseTypeSizes[this.type & 0x1F];
                break;
            }
            case 7: {
                for (Object object : this.values) {
                    try {
                        n += object.toString().getBytes("UTF-8").length + 1;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                }
                break;
            }
        }
        return n;
    }

    protected SubField getSubField(String string) {
        for (int i = 0; i < this.subFields.size(); ++i) {
            if (!this.subFields.get((int)i).name.equals(string)) continue;
            return this.subFields.get(i);
        }
        return null;
    }

    protected SubField getSubField(int n) {
        if (n >= 0 && n < this.subFields.size()) {
            return this.subFields.get(n);
        }
        return null;
    }

    protected boolean isSignedInteger() {
        return this.isSignedIntegerInternal(null);
    }

    protected boolean isSignedInteger(int n) {
        return this.isSignedIntegerInternal(this.getSubField(n));
    }

    protected boolean isSignedInteger(String string) {
        return this.isSignedIntegerInternal(this.getSubField(string));
    }

    private boolean isSignedIntegerInternal(SubField subField) {
        switch (this.getTypeInternal(subField)) {
            case 1: 
            case 131: 
            case 133: {
                return true;
            }
        }
        return false;
    }

    public void addValue(Object object) {
        if (object instanceof Number && this.type == 7) {
            String string = this.getStringValueInternal(0, null);
            Number number = (Number)object;
            if (string == null) {
                string = "";
            }
            string = string + String.valueOf((char)number.intValue());
            this.setValueInternal(0, string, null);
            return;
        }
        this.values.add(object);
    }

    public void addRawValue(Object object) {
        if (object == null) {
            this.values.add(null);
        } else if (object instanceof Double) {
            switch (this.type) {
                case 0: 
                case 2: 
                case 10: 
                case 13: 
                case 131: {
                    this.values.add((short)Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 1: {
                    this.values.add((byte)Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 132: 
                case 133: 
                case 139: {
                    this.values.add((int)Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 134: 
                case 140: {
                    this.values.add(Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 136: {
                    this.values.add((Float)object);
                    break;
                }
                case 137: {
                    this.values.add((Double)object);
                    break;
                }
                case 7: {
                    this.values.add(object.toString());
                    break;
                }
            }
        } else if (object instanceof String && ((String)object).equals("")) {
            switch (this.type) {
                case 0: {
                    this.values.add(Fit.ENUM_INVALID);
                    break;
                }
                case 1: {
                    this.values.add(Fit.SINT8_INVALID);
                    break;
                }
                case 2: {
                    this.values.add(Fit.UINT8_INVALID);
                    break;
                }
                case 10: {
                    this.values.add(Fit.UINT8Z_INVALID);
                    break;
                }
                case 131: {
                    this.values.add(Fit.SINT16_INVALID);
                    break;
                }
                case 132: {
                    this.values.add(Fit.UINT16_INVALID);
                    break;
                }
                case 139: {
                    this.values.add(Fit.UINT16Z_INVALID);
                    break;
                }
                case 133: {
                    this.values.add(Fit.SINT32_INVALID);
                    break;
                }
                case 134: {
                    this.values.add(Fit.UINT32_INVALID);
                    break;
                }
                case 140: {
                    this.values.add(Fit.UINT32Z_INVALID);
                    break;
                }
                case 7: {
                    this.values.add(object);
                    break;
                }
                case 136: {
                    this.values.add(Fit.FLOAT32_INVALID);
                    break;
                }
                case 137: {
                    this.values.add(Fit.FLOAT64_INVALID);
                    break;
                }
                case 13: {
                    this.values.add(Fit.BYTE_INVALID);
                    break;
                }
            }
        } else {
            this.values.add(object);
        }
    }

    public int getNumValues() {
        return this.values.size();
    }

    public Object getRawValue() {
        return this.getRawValueInternal(0, null);
    }

    public Object getRawValue(int n) {
        return this.getRawValueInternal(n, null);
    }

    public Object getRawValue(int n, int n2) {
        return this.getRawValueInternal(n, this.getSubField(n2));
    }

    public Object getRawValue(int n, String string) {
        return this.getRawValueInternal(n, this.getSubField(string));
    }

    private Object getRawValueInternal(int n, SubField subField) {
        if (n >= this.values.size()) {
            return null;
        }
        Object object = this.values.get(n);
        return object;
    }

    public Object getValue() {
        return this.getValueInternal(0, null);
    }

    public Object getValue(int n) {
        return this.getValueInternal(n, null);
    }

    public Object getValue(int n, int n2) {
        return this.getValueInternal(n, this.getSubField(n2));
    }

    public Object getValue(int n, String string) {
        return this.getValueInternal(n, this.getSubField(string));
    }

    private Object getValueInternal(int n, SubField subField) {
        double d;
        double d2;
        if (n >= this.values.size()) {
            return null;
        }
        if (subField == null) {
            d2 = this.scale;
            d = this.offset;
        } else {
            d2 = subField.scale;
            d = subField.offset;
        }
        Object object = this.values.get(n);
        if (object instanceof Number) {
            switch (this.type) {
                case 0: {
                    if (!Short.valueOf(((Number)object).shortValue()).equals(Fit.ENUM_INVALID)) break;
                    return Fit.ENUM_INVALID;
                }
                case 1: {
                    if (!Byte.valueOf(((Number)object).byteValue()).equals(Fit.SINT8_INVALID)) break;
                    return Fit.SINT8_INVALID;
                }
                case 2: {
                    if (!Short.valueOf(((Number)object).shortValue()).equals(Fit.UINT8_INVALID)) break;
                    return Fit.UINT8_INVALID;
                }
                case 10: {
                    if (!Short.valueOf(((Number)object).shortValue()).equals(Fit.UINT8Z_INVALID)) break;
                    return Fit.UINT8Z_INVALID;
                }
                case 131: {
                    if (!Short.valueOf(((Number)object).shortValue()).equals(Fit.SINT16_INVALID)) break;
                    return Fit.SINT16_INVALID;
                }
                case 132: {
                    if (!Integer.valueOf(((Number)object).intValue()).equals(Fit.UINT16_INVALID)) break;
                    return Fit.UINT16_INVALID;
                }
                case 139: {
                    if (!Integer.valueOf(((Number)object).intValue()).equals(Fit.UINT16Z_INVALID)) break;
                    return Fit.UINT16Z_INVALID;
                }
                case 133: {
                    if (!Integer.valueOf(((Number)object).intValue()).equals(Fit.SINT32_INVALID)) break;
                    return Fit.SINT32_INVALID;
                }
                case 134: {
                    if (!Long.valueOf(((Number)object).longValue()).equals(Fit.UINT32_INVALID)) break;
                    return Fit.UINT32_INVALID;
                }
                case 140: {
                    if (!Long.valueOf(((Number)object).longValue()).equals(Fit.UINT32Z_INVALID)) break;
                    return Fit.UINT32Z_INVALID;
                }
                case 136: {
                    if (!Float.valueOf(((Number)object).floatValue()).equals(Fit.FLOAT32_INVALID)) break;
                    return Fit.FLOAT32_INVALID;
                }
                case 137: {
                    if (!Double.valueOf(((Number)object).doubleValue()).equals(Fit.FLOAT64_INVALID)) break;
                    return Fit.FLOAT64_INVALID;
                }
                case 13: {
                    if (!Short.valueOf(((Number)object).shortValue()).equals(Fit.BYTE_INVALID)) break;
                    return Fit.BYTE_INVALID;
                }
            }
            if (d2 != 1.0 || d != 0.0) {
                return new Double(((Number)object).doubleValue() / d2 - d);
            }
        }
        return object;
    }

    public void setValue(Object object) {
        this.setValueInternal(0, object, null);
    }

    public void setValue(Object object, int n) {
        this.setValueInternal(0, object, this.getSubField(n));
    }

    public void setValue(Object object, String string) {
        this.setValueInternal(0, object, this.getSubField(string));
    }

    public void setValue(int n, Object object) {
        this.setValueInternal(n, object, null);
    }

    public void setValue(int n, Object object, int n2) {
        SubField subField = null;
        if (n2 != 65535 && (subField = this.getSubField(n2)) == null) {
            throw new FitRuntimeException("com.garmin.fit.Field.setValue(): " + n2 + " is not a valid subfield index of " + this.name + ".");
        }
        this.setValueInternal(n, object, subField);
    }

    public void setValue(int n, Object object, String string) {
        this.setValueInternal(n, object, this.getSubField(string));
    }

    private void setValueInternal(int n, Object object, SubField subField) {
        double d;
        double d2;
        while (n >= this.getNumValues()) {
            this.addValue(new Object());
        }
        if (subField == null) {
            d2 = this.scale;
            d = this.offset;
        } else {
            d2 = subField.scale;
            d = subField.offset;
        }
        if (object == null) {
            this.values.set(n, null);
        } else if (object instanceof Number && (d2 != 1.0 || d != 0.0)) {
            double d3 = (((Number)object).doubleValue() + d) * d2;
            switch (this.type) {
                case 0: 
                case 2: 
                case 10: 
                case 13: 
                case 131: {
                    this.values.set(n, (short)Math.round(d3));
                    break;
                }
                case 1: {
                    this.values.set(n, (byte)Math.round(d3));
                    break;
                }
                case 132: 
                case 133: 
                case 139: {
                    this.values.set(n, (int)Math.round(d3));
                    break;
                }
                case 134: 
                case 140: {
                    this.values.set(n, Math.round(d3));
                    break;
                }
                case 136: {
                    this.values.set(n, Float.valueOf((float)d3));
                    break;
                }
                case 137: {
                    this.values.set(n, d3);
                    break;
                }
                case 7: {
                    this.values.set(n, Double.valueOf(d3).toString());
                    break;
                }
            }
        } else if (object instanceof String && ((String)object).equals("")) {
            switch (this.type) {
                case 0: {
                    this.values.set(n, Fit.ENUM_INVALID);
                    break;
                }
                case 1: {
                    this.values.set(n, Fit.SINT8_INVALID);
                    break;
                }
                case 2: {
                    this.values.set(n, Fit.UINT8_INVALID);
                    break;
                }
                case 10: {
                    this.values.set(n, Fit.UINT8Z_INVALID);
                    break;
                }
                case 131: {
                    this.values.set(n, Fit.SINT16_INVALID);
                    break;
                }
                case 132: {
                    this.values.set(n, Fit.UINT16_INVALID);
                    break;
                }
                case 139: {
                    this.values.set(n, Fit.UINT16Z_INVALID);
                    break;
                }
                case 133: {
                    this.values.set(n, Fit.SINT32_INVALID);
                    break;
                }
                case 134: {
                    this.values.set(n, Fit.UINT32_INVALID);
                    break;
                }
                case 140: {
                    this.values.set(n, Fit.UINT32Z_INVALID);
                    break;
                }
                case 7: {
                    this.values.set(n, object);
                    break;
                }
                case 136: {
                    this.values.set(n, Fit.FLOAT32_INVALID);
                    break;
                }
                case 137: {
                    this.values.set(n, Fit.FLOAT64_INVALID);
                    break;
                }
                case 13: {
                    this.values.set(n, Fit.BYTE_INVALID);
                    break;
                }
            }
        } else {
            this.values.set(n, object);
        }
    }

    public void setRawValue(int n, Object object) {
        while (n >= this.getNumValues()) {
            this.addValue(new Object());
        }
        if (object == null) {
            this.values.set(n, null);
        } else if (object instanceof Double) {
            switch (this.type) {
                case 0: 
                case 2: 
                case 10: 
                case 13: 
                case 131: {
                    this.values.set(n, (short)Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 1: {
                    this.values.set(n, (byte)Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 132: 
                case 133: 
                case 139: {
                    this.values.set(n, (int)Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 134: 
                case 140: {
                    this.values.set(n, Math.round(((Number)object).doubleValue()));
                    break;
                }
                case 136: {
                    this.values.set(n, (Float)object);
                    break;
                }
                case 137: {
                    this.values.set(n, (Double)object);
                    break;
                }
                case 7: {
                    this.values.set(n, object.toString());
                    break;
                }
            }
        } else if (object instanceof String && ((String)object).equals("")) {
            switch (this.type) {
                case 0: {
                    this.values.set(n, Fit.ENUM_INVALID);
                    break;
                }
                case 1: {
                    this.values.set(n, Fit.SINT8_INVALID);
                    break;
                }
                case 2: {
                    this.values.set(n, Fit.UINT8_INVALID);
                    break;
                }
                case 10: {
                    this.values.set(n, Fit.UINT8Z_INVALID);
                    break;
                }
                case 131: {
                    this.values.set(n, Fit.SINT16_INVALID);
                    break;
                }
                case 132: {
                    this.values.set(n, Fit.UINT16_INVALID);
                    break;
                }
                case 139: {
                    this.values.set(n, Fit.UINT16Z_INVALID);
                    break;
                }
                case 133: {
                    this.values.set(n, Fit.SINT32_INVALID);
                    break;
                }
                case 134: {
                    this.values.set(n, Fit.UINT32_INVALID);
                    break;
                }
                case 140: {
                    this.values.set(n, Fit.UINT32Z_INVALID);
                    break;
                }
                case 7: {
                    this.values.set(n, object);
                    break;
                }
                case 136: {
                    this.values.set(n, Fit.FLOAT32_INVALID);
                    break;
                }
                case 137: {
                    this.values.set(n, Fit.FLOAT64_INVALID);
                    break;
                }
                case 13: {
                    this.values.set(n, Fit.BYTE_INVALID);
                    break;
                }
            }
        } else {
            this.values.set(n, object);
        }
    }

    public Long getBitsValue(int n, int n2, boolean bl) {
        long l;
        long l2 = 0L;
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            Object object;
            if ((object = this.getRawValueInternal(n4++, null)) == null) {
                return null;
            }
            if (!(object instanceof Number)) {
                return null;
            }
            Long l3 = ((Number)object).longValue();
            l3 = l3 >> n;
            int n5 = Fit.baseTypeSizes[this.type & 0x1F] * 8 - n;
            n -= Fit.baseTypeSizes[this.type & 0x1F] * 8;
            if (n5 <= 0) continue;
            n = 0;
            if (n5 > n2 - n3) {
                n5 = n2 - n3;
            }
            long l4 = (1L << n5) - 1L;
            l2 |= (l3 & l4) << n3;
            n3 += n5;
        }
        if (bl && (l2 & (l = 1L << n2 - 1)) != 0L) {
            l2 = -l + (l2 & l - 1L);
        }
        return l2;
    }

    public Byte getByteValue() {
        return this.getByteValueInternal(0, null);
    }

    public Byte getByteValue(int n) {
        return this.getByteValueInternal(n, null);
    }

    public Byte getByteValue(int n, int n2) {
        return this.getByteValueInternal(n, this.getSubField(n2));
    }

    public Byte getByteValue(int n, String string) {
        return this.getByteValueInternal(n, this.getSubField(string));
    }

    private Byte getByteValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return ((Number)object).byteValue();
    }

    public Short getShortValue() {
        return this.getShortValueInternal(0, null);
    }

    public Short getShortValue(int n) {
        return this.getShortValueInternal(n, null);
    }

    public Short getShortValue(int n, int n2) {
        return this.getShortValueInternal(n, this.getSubField(n2));
    }

    public Short getShortValue(int n, String string) {
        return this.getShortValueInternal(n, this.getSubField(string));
    }

    private Short getShortValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return ((Number)object).shortValue();
    }

    public Integer getIntegerValue() {
        return this.getIntegerValueInternal(0, null);
    }

    public Integer getIntegerValue(int n) {
        return this.getIntegerValueInternal(n, null);
    }

    public Integer getIntegerValue(int n, int n2) {
        return this.getIntegerValueInternal(n, this.getSubField(n2));
    }

    public Integer getIntegerValue(int n, String string) {
        return this.getIntegerValueInternal(n, this.getSubField(string));
    }

    private Integer getIntegerValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return ((Number)object).intValue();
    }

    public Long getLongValue() {
        return this.getLongValueInternal(0, null);
    }

    public Long getLongValue(int n) {
        return this.getLongValueInternal(n, null);
    }

    public Long getLongValue(int n, int n2) {
        return this.getLongValueInternal(n, this.getSubField(n2));
    }

    public Long getLongValue(int n, String string) {
        return this.getLongValueInternal(n, this.getSubField(string));
    }

    private Long getLongValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return ((Number)object).longValue();
    }

    public Float getFloatValue() {
        return this.getFloatValueInternal(0, null);
    }

    public Float getFloatValue(int n) {
        return this.getFloatValueInternal(n, null);
    }

    public Float getFloatValue(int n, int n2) {
        return this.getFloatValueInternal(n, this.getSubField(n2));
    }

    public Float getFloatValue(int n, String string) {
        return this.getFloatValueInternal(n, this.getSubField(string));
    }

    private Float getFloatValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return new Float(((Number)object).doubleValue());
    }

    public Double getDoubleValue() {
        return this.getDoubleValueInternal(0, null);
    }

    public Double getDoubleValue(int n) {
        return this.getDoubleValueInternal(n, null);
    }

    public Double getDoubleValue(int n, int n2) {
        return this.getDoubleValueInternal(n, this.getSubField(n2));
    }

    public Double getDoubleValue(int n, String string) {
        return this.getDoubleValueInternal(n, this.getSubField(string));
    }

    private Double getDoubleValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        return new Double(((Number)object).doubleValue());
    }

    public String getStringValue() {
        return this.getStringValueInternal(0, null);
    }

    public String getStringValue(int n) {
        return this.getStringValueInternal(n, null);
    }

    public String getStringValue(int n, int n2) {
        return this.getStringValueInternal(n, this.getSubField(n2));
    }

    public String getStringValue(int n, String string) {
        return this.getStringValueInternal(n, this.getSubField(string));
    }

    private String getStringValueInternal(int n, SubField subField) {
        Object object = this.getValueInternal(n, subField);
        if (object == null) {
            return null;
        }
        if (!forceShowInvalids) {
            switch (this.type) {
                case 0: {
                    if (!object.equals(Fit.ENUM_INVALID)) break;
                    return null;
                }
                case 1: {
                    if (!object.equals(Fit.SINT8_INVALID)) break;
                    return null;
                }
                case 2: {
                    if (!object.equals(Fit.UINT8_INVALID)) break;
                    return null;
                }
                case 10: {
                    if (!object.equals(Fit.UINT8Z_INVALID)) break;
                    return null;
                }
                case 131: {
                    if (!object.equals(Fit.SINT16_INVALID)) break;
                    return null;
                }
                case 132: {
                    if (!object.equals(Fit.UINT16_INVALID)) break;
                    return null;
                }
                case 139: {
                    if (!object.equals(Fit.UINT16Z_INVALID)) break;
                    return null;
                }
                case 133: {
                    if (!object.equals(Fit.SINT32_INVALID)) break;
                    return null;
                }
                case 134: {
                    if (!object.equals(Fit.UINT32_INVALID)) break;
                    return null;
                }
                case 140: {
                    if (!object.equals(Fit.UINT32Z_INVALID)) break;
                    return null;
                }
                case 136: {
                    if (!object.equals(Fit.FLOAT32_INVALID)) break;
                    return null;
                }
                case 137: {
                    if (!object.equals(Fit.FLOAT64_INVALID)) break;
                    return null;
                }
                case 13: {
                    if (!object.equals(Fit.BYTE_INVALID)) break;
                    return null;
                }
            }
        }
        return object.toString();
    }

    protected boolean read(InputStream inputStream, int n) {
        block29: {
            try {
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                if (this.type == 7) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        int n2 = 0;
                        for (int i = 0; i < n; ++i) {
                            int n3 = inputStream.read();
                            if (n3 == 0) {
                                if (byteArrayOutputStream.size() > 0) {
                                    while (n2 > 0) {
                                        this.values.add(new String());
                                        --n2;
                                    }
                                    this.values.add(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
                                } else {
                                    ++n2;
                                }
                                byteArrayOutputStream.reset();
                                continue;
                            }
                            byteArrayOutputStream.write(n3);
                        }
                        if (byteArrayOutputStream.size() > 0) {
                            while (n2 > 0) {
                                this.values.add(new String());
                                --n2;
                            }
                            this.values.add(new String(byteArrayOutputStream.toByteArray(), "UTF-8"));
                        }
                        break block29;
                    }
                    catch (EOFException eOFException) {
                        return true;
                    }
                }
                boolean bl = true;
                block22: for (int i = n; i > 0; i -= Fit.baseTypeSizes[this.type & 0x1F]) {
                    switch (this.type) {
                        case 0: {
                            Number number = (short)(dataInputStream.readByte() & 0xFF);
                            this.values.add(number);
                            if (((Short)number).equals(Fit.ENUM_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 2: {
                            Number number = (short)(dataInputStream.readByte() & 0xFF);
                            this.values.add(number);
                            if (((Short)number).equals(Fit.UINT8_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 10: {
                            Number number = (short)(dataInputStream.readByte() & 0xFF);
                            this.values.add(number);
                            if (((Short)number).equals(Fit.UINT8Z_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 1: {
                            Number number = dataInputStream.readByte();
                            this.values.add(number);
                            if (((Byte)number).equals(Fit.SINT8_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 131: {
                            Number number = dataInputStream.readShort();
                            this.values.add(number);
                            if (((Short)number).equals(Fit.SINT16_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 132: {
                            Number number = dataInputStream.readByte() & 0xFF;
                            number = (Integer)number << 8;
                            number = (Integer)number | dataInputStream.readByte() & 0xFF;
                            this.values.add(number);
                            if (((Integer)number).equals(Fit.UINT16_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 139: {
                            Number number = dataInputStream.readByte() & 0xFF;
                            number = (Integer)number << 8;
                            number = (Integer)number | dataInputStream.readByte() & 0xFF;
                            this.values.add(number);
                            if (((Integer)number).equals(Fit.UINT16Z_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 133: {
                            Number number = dataInputStream.readInt();
                            this.values.add(number);
                            if (((Integer)number).equals(Fit.SINT32_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 134: {
                            Number number = (long)(dataInputStream.readByte() & 0xFF);
                            number = (Long)number << 8;
                            number = (Long)number | (long)(dataInputStream.readByte() & 0xFF);
                            number = (Long)number << 8;
                            number = (Long)number | (long)(dataInputStream.readByte() & 0xFF);
                            number = (Long)number << 8;
                            number = (Long)number | (long)(dataInputStream.readByte() & 0xFF);
                            this.values.add(number);
                            if (((Long)number).equals(Fit.UINT32_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 140: {
                            Number number = (long)(dataInputStream.readByte() & 0xFF);
                            number = (Long)number << 8;
                            number = (Long)number | (long)(dataInputStream.readByte() & 0xFF);
                            number = (Long)number << 8;
                            number = (Long)number | (long)(dataInputStream.readByte() & 0xFF);
                            number = (Long)number << 8;
                            number = (Long)number | (long)(dataInputStream.readByte() & 0xFF);
                            this.values.add(number);
                            if (((Long)number).equals(Fit.UINT32Z_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 136: {
                            Number number = Float.valueOf(dataInputStream.readFloat());
                            this.values.add(number);
                            if (((Float)number).equals(Fit.FLOAT32_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 137: {
                            Number number = dataInputStream.readDouble();
                            this.values.add(number);
                            if (((Double)number).equals(Fit.FLOAT64_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        case 13: {
                            Number number = (short)(dataInputStream.readByte() & 0xFF);
                            this.values.add(number);
                            if (((Short)number).equals(Fit.BYTE_INVALID)) continue block22;
                            bl = false;
                            continue block22;
                        }
                        default: {
                            return false;
                        }
                    }
                }
                if (bl && !forceShowInvalids) {
                    this.values.clear();
                }
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    protected void write(OutputStream outputStream, FieldDefinition fieldDefinition) {
        this.write(outputStream);
        for (int i = fieldDefinition.size - this.getSize(); i > 0; i -= Fit.baseTypeSizes[this.type & 0x1F]) {
            this.writeValue(outputStream, null);
        }
    }

    protected void write(OutputStream outputStream) {
        for (Object object : this.values) {
            this.writeValue(outputStream, object);
        }
    }

    private void writeValue(OutputStream outputStream, Object object) {
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            if (object == null) {
                switch (this.type) {
                    case 0: {
                        dataOutputStream.writeByte(Fit.ENUM_INVALID.shortValue());
                        break;
                    }
                    case 2: {
                        dataOutputStream.writeByte(Fit.UINT8_INVALID.shortValue());
                        break;
                    }
                    case 10: {
                        dataOutputStream.writeByte(Fit.UINT8Z_INVALID.shortValue());
                        break;
                    }
                    case 1: {
                        dataOutputStream.writeByte(Fit.SINT8_INVALID.byteValue());
                        break;
                    }
                    case 13: {
                        dataOutputStream.writeByte(Fit.BYTE_INVALID.shortValue());
                        break;
                    }
                    case 131: {
                        dataOutputStream.writeShort(Fit.SINT16_INVALID.shortValue());
                        break;
                    }
                    case 132: {
                        dataOutputStream.writeShort(Fit.UINT16_INVALID);
                        break;
                    }
                    case 139: {
                        dataOutputStream.writeShort(Fit.UINT16Z_INVALID);
                        break;
                    }
                    case 133: {
                        dataOutputStream.writeInt(Fit.SINT32_INVALID);
                        break;
                    }
                    case 134: {
                        dataOutputStream.writeInt((int)Fit.UINT32_INVALID.longValue());
                        break;
                    }
                    case 140: {
                        dataOutputStream.writeInt((int)Fit.UINT32Z_INVALID.longValue());
                        break;
                    }
                    case 7: {
                        dataOutputStream.writeByte(0);
                        break;
                    }
                    case 136: {
                        dataOutputStream.writeFloat(Fit.FLOAT32_INVALID.floatValue());
                        break;
                    }
                    case 137: {
                        dataOutputStream.writeDouble(Fit.FLOAT64_INVALID);
                        break;
                    }
                }
            } else {
                switch (this.type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 10: 
                    case 13: {
                        if (object instanceof String) {
                            System.err.printf("Field.write(): Field %s value should not be string value %s\n", this.name, object);
                        }
                        dataOutputStream.writeByte((int)Math.round(((Number)object).doubleValue()));
                        break;
                    }
                    case 131: 
                    case 132: 
                    case 139: {
                        dataOutputStream.writeShort((int)Math.round(((Number)object).doubleValue()));
                        break;
                    }
                    case 133: 
                    case 134: 
                    case 140: {
                        dataOutputStream.writeInt((int)Math.round(((Number)object).doubleValue()));
                        break;
                    }
                    case 7: {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
                        outputStreamWriter.write(object.toString());
                        outputStreamWriter.flush();
                        outputStream.write(0);
                        break;
                    }
                    case 136: {
                        dataOutputStream.writeFloat(((Number)object).floatValue());
                        break;
                    }
                    case 137: {
                        dataOutputStream.writeDouble(((Number)object).doubleValue());
                        break;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

